/*
 * Decompiled with CFR 0.152.
 */
package org.bushe.swing.event;

import java.lang.reflect.Type;
import java.util.List;
import java.util.regex.Pattern;
import org.bushe.swing.event.EventService;
import org.bushe.swing.event.EventServiceLocator;
import org.bushe.swing.event.EventSubscriber;
import org.bushe.swing.event.EventTopicSubscriber;
import org.bushe.swing.event.VetoEventListener;
import org.bushe.swing.event.VetoTopicEventListener;

public class EventBus {
    private static EventService globalEventService = EventServiceLocator.getSwingEventService();

    public static EventService getGlobalEventService() {
        return globalEventService;
    }

    public static void publish(Object event) {
        if (event == null) {
            throw new IllegalArgumentException("Can't publish null.");
        }
        globalEventService.publish(event);
    }

    public static void publish(String topic, Object o) {
        if (topic == null) {
            throw new IllegalArgumentException("Can't publish to null topic.");
        }
        globalEventService.publish(topic, o);
    }

    public static void publish(Type genericType, Object o) {
        if (genericType == null) {
            throw new IllegalArgumentException("Can't publish to null type.");
        }
        globalEventService.publish(genericType, o);
    }

    public static boolean subscribe(Class eventClass, EventSubscriber subscriber) {
        return globalEventService.subscribe(eventClass, subscriber);
    }

    public static boolean subscribe(Type genericType, EventSubscriber subscriber) {
        return globalEventService.subscribe(genericType, subscriber);
    }

    public static boolean subscribeExactly(Class eventClass, EventSubscriber subscriber) {
        return globalEventService.subscribeExactly(eventClass, subscriber);
    }

    public static boolean subscribe(String topic, EventTopicSubscriber subscriber) {
        return globalEventService.subscribe(topic, subscriber);
    }

    public static boolean subscribe(Pattern topicPattern, EventTopicSubscriber subscriber) {
        return globalEventService.subscribe(topicPattern, subscriber);
    }

    public static boolean subscribeStrongly(Class eventClass, EventSubscriber subscriber) {
        return globalEventService.subscribeStrongly(eventClass, subscriber);
    }

    public static boolean subscribeExactlyStrongly(Class eventClass, EventSubscriber subscriber) {
        return globalEventService.subscribeExactlyStrongly(eventClass, subscriber);
    }

    public static boolean subscribeStrongly(String topic, EventTopicSubscriber subscriber) {
        return globalEventService.subscribeStrongly(topic, subscriber);
    }

    public static boolean subscribeStrongly(Pattern topicPattern, EventTopicSubscriber subscriber) {
        return globalEventService.subscribeStrongly(topicPattern, subscriber);
    }

    public static boolean unsubscribe(Class eventClass, EventSubscriber subscriber) {
        return globalEventService.unsubscribe(eventClass, subscriber);
    }

    public static boolean unsubscribeExactly(Class eventClass, EventSubscriber subscriber) {
        return globalEventService.unsubscribeExactly(eventClass, subscriber);
    }

    public static boolean unsubscribe(String topic, EventTopicSubscriber subscriber) {
        return globalEventService.unsubscribe(topic, subscriber);
    }

    public static boolean unsubscribe(Pattern topicPattern, EventTopicSubscriber subscriber) {
        return globalEventService.unsubscribe(topicPattern, subscriber);
    }

    public static boolean unsubscribe(Class eventClass, Object object) {
        return globalEventService.unsubscribe(eventClass, object);
    }

    public static boolean unsubscribeExactly(Class eventClass, Object subscriber) {
        return globalEventService.unsubscribeExactly(eventClass, subscriber);
    }

    public static boolean unsubscribe(String topic, Object subscriber) {
        return globalEventService.unsubscribe(topic, subscriber);
    }

    public static boolean unsubscribe(Pattern topicPattern, Object subscriber) {
        return globalEventService.unsubscribe(topicPattern, subscriber);
    }

    public static boolean subscribeVetoListener(Class eventClass, VetoEventListener vetoListener) {
        return globalEventService.subscribeVetoListener(eventClass, vetoListener);
    }

    public static boolean subscribeVetoListenerExactly(Class eventClass, VetoEventListener vetoListener) {
        return globalEventService.subscribeVetoListenerExactly(eventClass, vetoListener);
    }

    public static boolean subscribeVetoListener(String topic, VetoTopicEventListener vetoListener) {
        return globalEventService.subscribeVetoListener(topic, vetoListener);
    }

    public static boolean subscribeVetoListener(Pattern topicPattern, VetoTopicEventListener vetoListener) {
        return globalEventService.subscribeVetoListener(topicPattern, vetoListener);
    }

    public static boolean subscribeVetoListenerStrongly(Class eventClass, VetoEventListener vetoListener) {
        return globalEventService.subscribeVetoListenerStrongly(eventClass, vetoListener);
    }

    public static boolean subscribeVetoListenerExactlyStrongly(Class eventClass, VetoEventListener vetoListener) {
        return globalEventService.subscribeVetoListenerExactlyStrongly(eventClass, vetoListener);
    }

    public static boolean subscribeVetoListenerStrongly(String topic, VetoTopicEventListener vetoListener) {
        return globalEventService.subscribeVetoListenerStrongly(topic, vetoListener);
    }

    public static boolean subscribeVetoListenerStrongly(Pattern topicPattern, VetoTopicEventListener vetoListener) {
        return globalEventService.subscribeVetoListenerStrongly(topicPattern, vetoListener);
    }

    public static boolean unsubscribeVetoListener(Class eventClass, VetoEventListener vetoListener) {
        return globalEventService.unsubscribeVetoListener(eventClass, vetoListener);
    }

    public static boolean unsubscribeVetoListenerExactly(Class eventClass, VetoEventListener vetoListener) {
        return globalEventService.unsubscribeVetoListenerExactly(eventClass, vetoListener);
    }

    public static boolean unsubscribeVetoListener(String topic, VetoTopicEventListener vetoListener) {
        return globalEventService.unsubscribeVetoListener(topic, vetoListener);
    }

    public static boolean unsubscribeVetoListener(Pattern topicPattern, VetoTopicEventListener vetoListener) {
        return globalEventService.unsubscribeVetoListener(topicPattern, vetoListener);
    }

    public static List getSubscribers(Class eventClass) {
        return globalEventService.getSubscribers(eventClass);
    }

    public static List getSubscribersToClass(Class eventClass) {
        return globalEventService.getSubscribersToClass(eventClass);
    }

    public static List getSubscribersToExactClass(Class eventClass) {
        return globalEventService.getSubscribersToExactClass(eventClass);
    }

    public static List getSubscribers(String topic) {
        return globalEventService.getSubscribers(topic);
    }

    public static List getSubscribersToTopic(String topic) {
        return globalEventService.getSubscribersToTopic(topic);
    }

    public static List getSubscribersByPattern(String topic) {
        return globalEventService.getSubscribersByPattern(topic);
    }

    public static List getVetoSubscribers(Class eventClass) {
        return globalEventService.getVetoSubscribers(eventClass);
    }

    public static List getVetoSubscribersToExactClass(Class eventClass) {
        return globalEventService.getVetoSubscribersToExactClass(eventClass);
    }

    public static List getVetoSubscribers(String topic) {
        return globalEventService.getVetoSubscribers(topic);
    }

    public static List getVetoSubscribersToClass(Class eventClass) {
        return globalEventService.getVetoSubscribersToClass(eventClass);
    }

    public static List getVetoSubscribers(Pattern pattern) {
        return globalEventService.getVetoSubscribers(pattern);
    }

    public static void clearAllSubscribers() {
        globalEventService.clearAllSubscribers();
    }

    public static void setDefaultCacheSizePerClassOrTopic(int defaultCacheSizePerClassOrTopic) {
        globalEventService.setDefaultCacheSizePerClassOrTopic(defaultCacheSizePerClassOrTopic);
    }

    public static int getDefaultCacheSizePerClassOrTopic() {
        return globalEventService.getDefaultCacheSizePerClassOrTopic();
    }

    public static void setCacheSizeForEventClass(Class eventClass, int cacheSize) {
        globalEventService.setCacheSizeForEventClass(eventClass, cacheSize);
    }

    public static int getCacheSizeForEventClass(Class eventClass) {
        return globalEventService.getCacheSizeForEventClass(eventClass);
    }

    public static void setCacheSizeForTopic(String topicName, int cacheSize) {
        globalEventService.setCacheSizeForTopic(topicName, cacheSize);
    }

    public static void setCacheSizeForTopic(Pattern pattern, int cacheSize) {
        globalEventService.setCacheSizeForTopic(pattern, cacheSize);
    }

    public static int getCacheSizeForTopic(String topic) {
        return globalEventService.getCacheSizeForTopic(topic);
    }

    public static Object getLastEvent(Class eventClass) {
        return globalEventService.getLastEvent(eventClass);
    }

    public static List getCachedEvents(Class eventClass) {
        return globalEventService.getCachedEvents(eventClass);
    }

    public static Object getLastTopicData(String topic) {
        return globalEventService.getLastTopicData(topic);
    }

    public static List getCachedTopicData(String topic) {
        return globalEventService.getCachedTopicData(topic);
    }

    public static void clearCache(Class eventClass) {
        globalEventService.clearCache(eventClass);
    }

    public static void clearCache(String topic) {
        globalEventService.clearCache(topic);
    }

    public static void clearCache(Pattern pattern) {
        globalEventService.clearCache(pattern);
    }

    public static void clearCache() {
        globalEventService.clearCache();
    }
}

