/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.applet.Applet;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import javax.swing.CellEditor;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import sun.swing.UIAction;

public class JXTree
extends JTree {
    private static final Logger LOG = Logger.getLogger(JXTree.class.getName());
    private Method conversionMethod = null;
    private static final Class[] methodSignature = new Class[]{Object.class};
    private static final Object[] methodArgs = new Object[]{null};
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final TreePath[] EMPTY_TREEPATH_ARRAY = new TreePath[0];
    private boolean overwriteIcons;
    private CellEditorRemover editorRemover;
    private CellEditorListener editorListener;
    protected ComponentAdapter dataAdapter;

    public JXTree() {
        this.init();
    }

    public JXTree(Object[] value) {
        super(value);
        this.init();
    }

    public JXTree(Vector value) {
        super(value);
        this.init();
    }

    public JXTree(Hashtable value) {
        super(value);
        this.init();
    }

    public JXTree(TreeNode root) {
        super(root, false);
        this.init();
    }

    public JXTree(TreeNode root, boolean asksAllowsChildren) {
        super(root, asksAllowsChildren);
        this.init();
    }

    public JXTree(TreeModel newModel) {
        super(newModel);
        this.init();
    }

    public void setModel(TreeModel newModel) {
        this.conversionMethod = this.getValueConversionMethod(newModel);
        super.setModel(newModel);
    }

    protected Method getValueConversionMethod(TreeModel model) {
        try {
            return model == null ? null : model.getClass().getMethod("convertValueToText", methodSignature);
        }
        catch (NoSuchMethodException ex) {
            LOG.finer("ex " + ex);
            LOG.finer("no conversionMethod in " + model.getClass());
            return null;
        }
    }

    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value != null) {
            if (this.conversionMethod == null) {
                return value.toString();
            }
            try {
                JXTree.methodArgs[0] = value;
                return (String)this.conversionMethod.invoke((Object)this.getModel(), methodArgs);
            }
            catch (Exception ex) {
                LOG.finer("ex " + ex);
                LOG.finer("can't invoke " + this.conversionMethod);
            }
        }
        return "";
    }

    private void init() {
        this.conversionMethod = this.getValueConversionMethod(this.getModel());
        ActionMap map = this.getActionMap();
        map.put("expand-all", new Actions("expand-all"));
        map.put("collapse-all", new Actions("collapse-all"));
    }

    protected TreeModelListener createTreeModelListener() {
        return new XTreeModelHandler();
    }

    public void collapseAll() {
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            this.collapseRow(i);
        }
    }

    public void expandAll() {
        if (this.getRowCount() == 0) {
            this.expandRoot();
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    private void expandRoot() {
        TreeModel model = this.getModel();
        if (model != null && model.getRoot() != null) {
            this.expandPath(new TreePath(model.getRoot()));
        }
    }

    public int[] getSelectionRows() {
        int[] rows = super.getSelectionRows();
        return rows != null ? rows : EMPTY_INT_ARRAY;
    }

    public TreePath[] getSelectionPaths() {
        TreePath[] paths = super.getSelectionPaths();
        return paths != null ? paths : EMPTY_TREEPATH_ARRAY;
    }

    public void setExpandedIcon(Icon expanded) {
        if (this.getUI() instanceof BasicTreeUI) {
            ((BasicTreeUI)this.getUI()).setExpandedIcon(expanded);
        }
    }

    public void setCollapsedIcon(Icon collapsed) {
        if (this.getUI() instanceof BasicTreeUI) {
            ((BasicTreeUI)this.getUI()).setCollapsedIcon(collapsed);
        }
    }

    public void setOverwriteRendererIcons(boolean overwrite) {
        if (this.overwriteIcons == overwrite) {
            return;
        }
        boolean old = this.overwriteIcons;
        this.overwriteIcons = overwrite;
        this.firePropertyChange("overwriteRendererIcons", old, overwrite);
    }

    public boolean isOverwriteRendererIcons() {
        return this.overwriteIcons;
    }

    public void startEditingAtPath(TreePath path) {
        super.startEditingAtPath(path);
        if (this.isEditing()) {
            this.updateEditorListener();
            this.updateEditorRemover();
        }
    }

    private void updateEditorListener() {
        if (this.editorListener == null) {
            this.editorListener = new CellEditorListener(){

                public void editingCanceled(ChangeEvent e) {
                    this.terminated(e);
                }

                private void terminated(ChangeEvent e) {
                    JXTree.this.analyseFocus();
                    ((CellEditor)e.getSource()).removeCellEditorListener(JXTree.this.editorListener);
                }

                public void editingStopped(ChangeEvent e) {
                    this.terminated(e);
                }
            };
        }
        this.getCellEditor().addCellEditorListener(this.editorListener);
    }

    protected void analyseFocus() {
        boolean isFocusOwnerInTheTable = this.isFocusOwnerDescending();
        if (isFocusOwnerInTheTable) {
            this.requestFocusInWindow();
        }
    }

    private boolean isFocusOwnerDescending() {
        if (!this.isEditing()) {
            return false;
        }
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner == null) {
            return false;
        }
        if (this.isDescending(focusOwner)) {
            return true;
        }
        Component permanent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        return this.isDescending(permanent);
    }

    private boolean isDescending(Component focusOwner) {
        while (focusOwner != null) {
            if (focusOwner instanceof JPopupMenu && (focusOwner = ((JPopupMenu)focusOwner).getInvoker()) == null) {
                return false;
            }
            if (focusOwner == this) {
                return true;
            }
            focusOwner = focusOwner.getParent();
        }
        return false;
    }

    public void removeNotify() {
        if (this.editorRemover != null) {
            this.editorRemover.release();
            this.editorRemover = null;
        }
        super.removeNotify();
    }

    private void updateEditorRemover() {
        if (this.editorRemover == null) {
            this.editorRemover = new CellEditorRemover();
        }
        this.editorRemover.updateKeyboardFocusManager();
    }

    protected ComponentAdapter getComponentAdapter() {
        if (this.dataAdapter == null) {
            this.dataAdapter = new TreeAdapter(this);
        }
        return this.dataAdapter;
    }

    protected ComponentAdapter getComponentAdapter(int index) {
        ComponentAdapter adapter = this.getComponentAdapter();
        adapter.column = 0;
        adapter.row = index;
        return adapter;
    }

    protected static class TreeAdapter
    extends ComponentAdapter {
        private final JXTree tree;

        public TreeAdapter(JXTree component) {
            super(component);
            this.tree = component;
        }

        public JXTree getTree() {
            return this.tree;
        }

        public boolean hasFocus() {
            return this.tree.isFocusOwner() && this.tree.getLeadSelectionRow() == this.row;
        }

        public Object getValueAt(int row, int column) {
            TreePath path = this.tree.getPathForRow(row);
            return path.getLastPathComponent();
        }

        public Object getFilteredValueAt(int row, int column) {
            return this.getValueAt(row, column);
        }

        public boolean isEditable() {
            return this.tree.isPathEditable(this.tree.getPathForRow(this.row));
        }

        public boolean isSelected() {
            return this.tree.isRowSelected(this.row);
        }

        public boolean isExpanded() {
            return this.tree.isExpanded(this.row);
        }

        public int getDepth() {
            return this.tree.getPathForRow(this.row).getPathCount() - 1;
        }

        public boolean isLeaf() {
            return this.tree.getModel().isLeaf(this.getValue());
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public void setValueAt(Object aValue, int row, int column) {
        }

        public String getColumnName(int columnIndex) {
            return "Column_" + columnIndex;
        }

        public String getColumnIdentifier(int columnIndex) {
            return null;
        }
    }

    public class CellEditorRemover
    implements PropertyChangeListener {
        KeyboardFocusManager focusManager;

        public CellEditorRemover() {
            this.updateKeyboardFocusManager();
        }

        public void updateKeyboardFocusManager() {
            KeyboardFocusManager current = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.setKeyboardFocusManager(current);
        }

        public void release() {
            this.setKeyboardFocusManager(null);
        }

        private void setKeyboardFocusManager(KeyboardFocusManager current) {
            if (this.focusManager == current) {
                return;
            }
            KeyboardFocusManager old = this.focusManager;
            if (old != null) {
                old.removePropertyChangeListener("permanentFocusOwner", this);
            }
            this.focusManager = current;
            if (this.focusManager != null) {
                this.focusManager.addPropertyChangeListener("permanentFocusOwner", this);
            }
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if (!JXTree.this.isEditing()) {
                return;
            }
            Component c = this.focusManager.getPermanentFocusOwner();
            JXTree tree = JXTree.this;
            while (c != null) {
                if (c instanceof JPopupMenu) {
                    c = ((JPopupMenu)c).getInvoker();
                    continue;
                }
                if (c == tree) {
                    return;
                }
                if (c instanceof Window || c instanceof Applet && c.getParent() == null) {
                    if (c != SwingUtilities.getRoot(tree)) break;
                    if (tree.getInvokesStopCellEditing()) {
                        tree.stopEditing();
                    }
                    if (!tree.isEditing()) break;
                    tree.cancelEditing();
                    break;
                }
                c = c.getParent();
            }
        }
    }

    private class Actions
    extends UIAction {
        Actions(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent evt) {
            if ("expand-all".equals(this.getName())) {
                JXTree.this.expandAll();
            } else if ("collapse-all".equals(this.getName())) {
                JXTree.this.collapseAll();
            }
        }
    }

    protected class XTreeModelHandler
    extends JTree.TreeModelHandler {
        protected XTreeModelHandler() {
            super(JXTree.this);
        }

        public void treeNodesInserted(TreeModelEvent e) {
            TreePath path = e.getTreePath();
            if (path.getParentPath() == null && !JXTree.this.isRootVisible() && JXTree.this.isCollapsed(path)) {
                JXTree.this.expandPath(path);
            }
            super.treeNodesInserted(e);
        }
    }
}

