/*
 * Decompiled with CFR 0.152.
 */
package phex.bootstrap;

import java.util.concurrent.atomic.AtomicInteger;

public abstract class BootstrapHost {
    private static final long RECONNECT_PENALTY = 3600000L;
    protected final boolean isPhexCache;
    protected long lastRequestTime;
    private AtomicInteger failedInRowCount = new AtomicInteger(0);

    public BootstrapHost(boolean isPhexCache) {
        this.isPhexCache = isPhexCache;
    }

    public boolean isPhexCache() {
        return this.isPhexCache;
    }

    public long getLastRequestTime() {
        return this.lastRequestTime;
    }

    public void setLastRequestTime(long lastRequestTime) {
        this.lastRequestTime = lastRequestTime;
    }

    public int getFailedInRowCount() {
        return this.failedInRowCount.get();
    }

    public void incFailedInRowCount() {
        this.failedInRowCount.incrementAndGet();
    }

    public void resetFailedInRowCount() {
        this.failedInRowCount.set(0);
    }

    public void setFailedInRowCount(int val) {
        this.failedInRowCount.set(val);
    }

    public long getEarliestReConnectTime() {
        return this.getReconnectPenalty() * (long)(this.getFailedInRowCount() + 1) + this.lastRequestTime;
    }

    public long getReconnectPenalty() {
        return 3600000L;
    }
}

