/*
 * Decompiled with CFR 0.152.
 */
package phex.bootstrap;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import phex.bootstrap.BootstrapHost;
import phex.bootstrap.BootstrapHostComparator;
import phex.bootstrap.GWebCacheConnection;
import phex.bootstrap.GWebCacheHost;
import phex.common.Environment;
import phex.common.GeneralGnutellaNetwork;
import phex.common.address.AddressUtils;
import phex.common.address.DestAddress;
import phex.connection.ProtocolNotSupportedException;
import phex.event.ChangeEvent;
import phex.host.CaughtHostsContainer;
import phex.servent.Servent;
import phex.utils.IOUtil;
import phex.utils.NormalizableURL;
import phex.utils.StringUtils;

public class GWebCacheContainer {
    private static final Logger logger = LoggerFactory.getLogger(GWebCacheContainer.class);
    private static int MIN_G_WEB_CACHES_SIZE = 5;
    private static int MAX_G_WEB_CACHES_SIZE = 1000;
    private static List<String> BLOCKED_WEB_CACHES;
    private static List<String> PHEX_WEB_CACHES;
    private final List<GWebCacheHost> allGWebCaches;
    private final List<GWebCacheHost> functionalGWebCaches;
    private final List<GWebCacheHost> phexGWebCaches;
    private final Set<String> uniqueGWebCacheURLs;
    private final TreeSet<GWebCacheHost> sortedGWebCaches;
    private final Random random;
    private final Servent servent;

    public GWebCacheContainer(Servent servent) {
        if (servent == null) {
            throw new NullPointerException("Servent missing.");
        }
        logger.debug("Initializing GWebCacheContainer");
        this.servent = servent;
        this.allGWebCaches = new ArrayList<GWebCacheHost>();
        this.phexGWebCaches = new ArrayList<GWebCacheHost>();
        this.functionalGWebCaches = new ArrayList<GWebCacheHost>();
        this.uniqueGWebCacheURLs = new HashSet<String>();
        this.sortedGWebCaches = new TreeSet<BootstrapHost>(BootstrapHostComparator.INSTANCE);
        this.random = new Random();
        this.initializeGWebCacheContainer();
        servent.getEventService().processAnnotations(this);
    }

    private void initializeGWebCacheContainer() {
        this.allGWebCaches.clear();
        this.phexGWebCaches.clear();
        this.functionalGWebCaches.clear();
        this.uniqueGWebCacheURLs.clear();
        this.sortedGWebCaches.clear();
        this.insertPhexGWebCaches();
        this.loadFromConfigInBackgrd();
    }

    @EventTopicSubscriber(topic="phex:servent/gnutellaNetwork")
    public void onGnutellaNetworkEvent(String topic, ChangeEvent event) {
        this.initializeGWebCacheContainer();
    }

    public boolean queryMoreHosts(boolean preferPhex) {
        int retrys = 0;
        boolean succ = false;
        do {
            ++retrys;
            GWebCacheConnection connection = this.getRandomGWebCacheConnection(preferPhex);
            if (connection == null) continue;
            DestAddress[] hosts = connection.sendHostFileRequest(this.servent.getSecurityService());
            if (!this.verifyGWebCache(connection) || hosts == null) continue;
            CaughtHostsContainer container = this.servent.getHostService().getCaughtHostsContainer();
            for (int i = 0; i < hosts.length; ++i) {
                container.addCaughtHost(hosts[i], (short)2);
            }
            succ = true;
        } while (!succ && retrys < 5);
        return succ;
    }

    public boolean updateRemoteGWebCache(DestAddress myHostAddress, boolean preferPhex) {
        String fullHostName = null;
        if (myHostAddress != null) {
            fullHostName = myHostAddress.getFullHostName();
        }
        int retrys = 0;
        boolean succ = false;
        do {
            ++retrys;
            GWebCacheConnection connection = this.getRandomGWebCacheConnection(preferPhex);
            if (connection == null) continue;
            String urlString = null;
            GWebCacheHost gWebCache = this.getGWebCacheForUpdate(connection.getGWebCache());
            if (gWebCache != null) {
                assert (!gWebCache.isPhexCache() && !gWebCache.equals(connection.getGWebCache())) : "isPhexCache: " + gWebCache.isPhexCache() + ",equals " + gWebCache.getUrl() + " - " + connection.getGWebCache().getUrl();
                urlString = gWebCache.getUrl().toExternalForm();
            }
            if (fullHostName == null && urlString == null) continue;
            succ = connection.updateRequest(fullHostName, urlString);
            this.verifyGWebCache(connection);
        } while (!succ && retrys < 5);
        return succ;
    }

    public boolean queryMoreGWebCaches(boolean preferPhex) {
        int retrys = 0;
        boolean succ = false;
        do {
            ++retrys;
            GWebCacheConnection connection = this.getRandomGWebCacheConnection(preferPhex);
            if (connection == null) continue;
            URL[] urls = connection.sendURLFileRequest();
            if (!this.verifyGWebCache(connection) || urls == null) continue;
            for (int i = 0; i < urls.length; ++i) {
                try {
                    boolean isPhexCache = this.isPhexGWebCache(urls[i].toExternalForm());
                    GWebCacheHost gWebCache = new GWebCacheHost(urls[i], isPhexCache);
                    if (!this.isCacheAccessAllowed(gWebCache)) continue;
                    this.insertGWebCache(gWebCache);
                    continue;
                }
                catch (IOException exp) {
                    logger.debug(exp.toString(), (Throwable)exp);
                }
            }
            succ = true;
        } while (!succ && retrys < 5);
        return succ;
    }

    public int getGWebCacheCount() {
        return this.allGWebCaches.size();
    }

    private GWebCacheHost getGWebCacheForUpdate(GWebCacheHost ignore) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GWebCacheHost getRandomGWebCache(boolean preferPhex) {
        this.ensureMinGWebCaches();
        List<GWebCacheHost> list = this.allGWebCaches;
        synchronized (list) {
            boolean usePhexCache;
            GWebCacheHost cache = null;
            boolean bl = usePhexCache = preferPhex && this.random.nextInt(8) == 0;
            if (usePhexCache && this.phexGWebCaches.size() > 0) {
                Collections.sort(this.phexGWebCaches, BootstrapHostComparator.INSTANCE);
                cache = this.phexGWebCaches.get(0);
            } else {
                int count = this.allGWebCaches.size();
                if (count == 0) {
                    return null;
                }
                cache = this.sortedGWebCaches.first();
            }
            long now = System.currentTimeMillis();
            if (now > cache.getEarliestReConnectTime()) {
                return cache;
            }
            return null;
        }
    }

    private GWebCacheConnection getRandomGWebCacheConnection(boolean preferPhex) {
        GWebCacheConnection connection = null;
        GWebCacheHost gWebCache = null;
        try {
            gWebCache = this.getRandomGWebCache(preferPhex);
            if (gWebCache == null) {
                return null;
            }
            connection = new GWebCacheConnection(gWebCache);
        }
        catch (ProtocolNotSupportedException exp) {
            this.removeGWebCache(gWebCache, true);
            return null;
        }
        return connection;
    }

    private boolean verifyGWebCache(GWebCacheConnection connection) {
        GWebCacheHost gWebCache = connection.getGWebCache();
        this.sortedGWebCaches.remove(gWebCache);
        gWebCache.countConnectionAttempt(connection.isCacheBad());
        this.sortedGWebCaches.add(gWebCache);
        if (!(connection.isCacheBad() || gWebCache.isPhexCache() || this.functionalGWebCaches.contains(gWebCache))) {
            this.functionalGWebCaches.add(gWebCache);
        }
        this.saveGWebCacheToFile();
        return true;
    }

    private GWebCacheHost parseGWebCacheFromLine(String line) throws IOException {
        int failedInRowCount;
        long lastRequestTime;
        String urlStr;
        StringTokenizer tokenizer = new StringTokenizer(line, " ");
        int tokenCount = tokenizer.countTokens();
        if (tokenCount == 1) {
            urlStr = line;
            lastRequestTime = -1L;
            failedInRowCount = -1;
        } else if (tokenCount == 3) {
            urlStr = tokenizer.nextToken();
            try {
                lastRequestTime = Long.parseLong(tokenizer.nextToken());
            }
            catch (NumberFormatException exp) {
                lastRequestTime = -1L;
            }
            try {
                failedInRowCount = Integer.parseInt(tokenizer.nextToken());
            }
            catch (NumberFormatException exp) {
                failedInRowCount = -1;
            }
        } else {
            logger.warn("Unknown HostCache line format: {}", (Object)line);
            return null;
        }
        NormalizableURL helpUrl = new NormalizableURL(urlStr);
        helpUrl.normalize();
        URL url = new URL(helpUrl.toExternalForm());
        boolean isPhexCache = this.isPhexGWebCache(url.toExternalForm());
        GWebCacheHost cache = new GWebCacheHost(url, isPhexCache);
        if (lastRequestTime > 0L) {
            cache.setLastRequestTime(lastRequestTime);
        }
        if (failedInRowCount > 0) {
            cache.setFailedInRowCount(failedInRowCount);
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertGWebCache(GWebCacheHost gWebCache) {
        List<GWebCacheHost> list = this.allGWebCaches;
        synchronized (list) {
            if (this.allGWebCaches.size() >= MAX_G_WEB_CACHES_SIZE) {
                logger.error("Limit of 1000 GWebCaches reached.");
                this.removeGWebCache(this.sortedGWebCaches.last(), true);
                return;
            }
            String uniqueString = gWebCache.getHostDomain();
            if (!this.uniqueGWebCacheURLs.contains(uniqueString)) {
                this.allGWebCaches.add(gWebCache);
                this.sortedGWebCaches.add(gWebCache);
                this.uniqueGWebCacheURLs.add(uniqueString);
                if (gWebCache.isPhexCache()) {
                    this.phexGWebCaches.add(gWebCache);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeGWebCache(GWebCacheHost gWebCache, boolean force) {
        List<GWebCacheHost> list = this.allGWebCaches;
        synchronized (list) {
            if (this.allGWebCaches.size() > MIN_G_WEB_CACHES_SIZE || force) {
                this.allGWebCaches.remove(gWebCache);
                this.functionalGWebCaches.remove(gWebCache);
                this.sortedGWebCaches.remove(gWebCache);
                String uniqueString = gWebCache.getHostDomain();
                this.uniqueGWebCacheURLs.remove(uniqueString);
                if (gWebCache.isPhexCache()) {
                    this.phexGWebCaches.remove(gWebCache);
                }
                this.saveGWebCacheToFile();
            }
        }
    }

    private void insertGWebCacheFromLine(String gWebCacheLine) {
        try {
            GWebCacheHost gWebCache = this.parseGWebCacheFromLine(gWebCacheLine);
            if (gWebCache != null && this.isCacheAccessAllowed(gWebCache)) {
                this.insertGWebCache(gWebCache);
            }
        }
        catch (IOException exp) {
            logger.debug(exp.toString(), (Throwable)exp);
        }
    }

    private void ensureMinGWebCaches() {
        if (this.allGWebCaches.size() >= 10) {
            return;
        }
        if (!(this.servent.getGnutellaNetwork() instanceof GeneralGnutellaNetwork)) {
            return;
        }
        logger.debug("Load default GWebCache file.");
        InputStream inStream = ClassLoader.getSystemResourceAsStream("phex/resources/gwebcache.cfg");
        if (inStream != null) {
            InputStreamReader reader = new InputStreamReader(inStream);
            try {
                this.loadGWebCacheFromReader(reader);
                this.saveGWebCacheToFile();
            }
            catch (IOException exp) {
                logger.warn(exp.toString(), (Throwable)exp);
            }
        } else {
            logger.warn("Default GWebCache file not found.");
        }
        if (this.allGWebCaches.size() < 1) {
            this.insertPhexGWebCaches();
            this.saveGWebCacheToFile();
        }
    }

    private void insertPhexGWebCaches() {
        if (!(this.servent.getGnutellaNetwork() instanceof GeneralGnutellaNetwork)) {
            return;
        }
        for (String phexCachesURL : PHEX_WEB_CACHES) {
            try {
                URL url = new URL(phexCachesURL);
                GWebCacheHost cache = new GWebCacheHost(url, true);
                this.insertGWebCache(cache);
            }
            catch (IOException e) {
                logger.error(e.toString(), (Throwable)e);
            }
        }
    }

    private boolean isCacheAccessAllowed(GWebCacheHost gWebCache) {
        URL cacheURL = gWebCache.getUrl();
        String hostName = cacheURL.getHost();
        if (AddressUtils.isIPHostName(hostName) && StringUtils.isEmpty(cacheURL.getPath())) {
            return false;
        }
        for (String blocked : BLOCKED_WEB_CACHES) {
            if (hostName.indexOf(blocked) == -1) continue;
            logger.debug("GWebCache host blocked.");
            return false;
        }
        return true;
    }

    public boolean isPhexGWebCache(String url) {
        return PHEX_WEB_CACHES.indexOf(url) != -1;
    }

    private void loadFromConfigInBackgrd() {
        Runnable runner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    File gWebCacheFile = GWebCacheContainer.this.servent.getGnutellaNetwork().getGWebCacheFile();
                    if (!gWebCacheFile.exists()) {
                        return;
                    }
                    GWebCacheContainer.this.loadGWebCacheFromReader(new FileReader(gWebCacheFile));
                }
                catch (IOException exp) {
                    logger.error("Failed loading GWebCache file.", (Throwable)exp);
                }
                finally {
                    GWebCacheContainer.this.ensureMinGWebCaches();
                }
            }
        };
        Environment.getInstance().executeOnThreadPool(runner, "LoadGWebCacheRunner");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGWebCacheFromReader(Reader reader) throws IOException {
        BufferedReader br = new BufferedReader(reader);
        List<GWebCacheHost> list = this.allGWebCaches;
        synchronized (list) {
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                this.insertGWebCacheFromLine(line);
            }
        }
        br.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveGWebCacheToFile() {
        logger.debug("Saving GWebCaches.");
        BufferedWriter writer = null;
        try {
            File file = this.servent.getGnutellaNetwork().getGWebCacheFile();
            writer = new BufferedWriter(new FileWriter(file));
            List<GWebCacheHost> list = this.allGWebCaches;
            synchronized (list) {
                for (GWebCacheHost gWebCache : this.allGWebCaches) {
                    if (gWebCache.isPhexCache()) continue;
                    writer.write(gWebCache.getUrl().toExternalForm() + " " + gWebCache.getLastRequestTime() + " " + gWebCache.getFailedInRowCount());
                    writer.newLine();
                }
            }
            IOUtil.closeQuietly(writer);
        }
        catch (IOException exp) {
            logger.error(exp.toString(), (Throwable)exp);
        }
        finally {
            IOUtil.closeQuietly(writer);
        }
    }

    static {
        String[] arr = new String[]{"http://phexgwc.kouk.de/gcache.php"};
        PHEX_WEB_CACHES = Collections.unmodifiableList(Arrays.asList(arr));
        String[] blockedArr = new String[]{"gavinroy.com"};
        BLOCKED_WEB_CACHES = Collections.unmodifiableList(Arrays.asList(blockedArr));
    }
}

