/*
 * Decompiled with CFR 0.152.
 */
package phex.bootstrap;

import java.io.IOException;
import java.net.URL;
import phex.bootstrap.BootstrapHost;
import phex.common.address.AddressUtils;
import phex.connection.ProtocolNotSupportedException;

public class GWebCacheHost
extends BootstrapHost {
    private static final long RECONNECT_PENALTY = 14400000L;
    private URL url;

    public GWebCacheHost(URL url, boolean isPhexCache) throws IOException {
        super(isPhexCache);
        if (url == null) {
            throw new NullPointerException("Null url given.");
        }
        if (!url.getProtocol().equals("http")) {
            throw new ProtocolNotSupportedException("Only http URLs are supported for a GWebCacheConnection");
        }
        if (url.getPort() == 80) {
            url = new URL(url.getProtocol(), url.getHost(), -1, url.getFile());
        }
        this.url = url;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getHostDomain() {
        String host = this.url.getHost();
        if (AddressUtils.isIPHostName(host)) {
            return host;
        }
        int topLevelIdx = host.lastIndexOf(46);
        int domainIdx = host.lastIndexOf(46, topLevelIdx - 1);
        if (domainIdx != -1) {
            return host.substring(domainIdx + 1);
        }
        return host;
    }

    public void countConnectionAttempt(boolean isFailed) {
        this.lastRequestTime = System.currentTimeMillis();
        if (isFailed) {
            this.incFailedInRowCount();
        } else {
            this.resetFailedInRowCount();
        }
    }

    public long getReconnectPenalty() {
        return 14400000L;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GWebCacheHost)) {
            return false;
        }
        GWebCacheHost gwc = (GWebCacheHost)obj;
        return this.url.getHost().equals(gwc.getUrl().getHost());
    }

    public int hashCode() {
        return 527 + this.url.getHost().hashCode();
    }
}

