/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.HashMap;
import phex.common.address.DestAddress;

public class AddressCounter {
    private final HashMap<Object, Integer> addressCountMap = new HashMap();
    private int maxCount;
    private boolean isFullAddressUsed;

    public AddressCounter(int maxCount, boolean isFullAddressUsed) {
        this.maxCount = maxCount;
        this.isFullAddressUsed = isFullAddressUsed;
    }

    public synchronized void setMaxCount(int val) {
        this.maxCount = val;
    }

    public synchronized boolean validateAndCountAddress(DestAddress address) {
        Object significantPart = this.provideSignificantAddressPart(address);
        Integer count = this.addressCountMap.get(significantPart);
        if (count != null) {
            if (count == this.maxCount) {
                return false;
            }
            this.addressCountMap.put(significantPart, count + 1);
        } else {
            this.addressCountMap.put(significantPart, 1);
        }
        return true;
    }

    public synchronized void relaseAddress(DestAddress address) {
        Object significantPart = this.provideSignificantAddressPart(address);
        Integer count = this.addressCountMap.get(significantPart);
        if (count != null) {
            if (count == 1) {
                this.addressCountMap.remove(significantPart);
                return;
            }
            this.addressCountMap.put(significantPart, count - 1);
        }
    }

    protected Object provideSignificantAddressPart(DestAddress address) {
        if (this.isFullAddressUsed) {
            return address;
        }
        return address.getIpAddress();
    }
}

