/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import org.apache.commons.lang.SystemUtils;
import phex.common.JThreadPool;
import phex.common.PhexVersion;
import phex.event.UserMessageListener;
import phex.utils.SystemProperties;

public class Environment {
    private UserMessageListener userMessageListener;
    private final Timer timerService = new Timer(true);
    private final JThreadPool threadPool = new JThreadPool();

    private Environment() {
    }

    public static Environment getInstance() {
        return Holder.environment;
    }

    public File getPhexConfigFile(String configFileName) {
        return new File(SystemProperties.getPhexConfigRoot(), configFileName);
    }

    public String getPhexVendor() {
        return "Phex " + PhexVersion.getFullVersion();
    }

    public void scheduleTimerTask(TimerTask task, long delay, long period) {
        this.timerService.schedule(task, delay, period);
    }

    public void scheduleTimerTask(TimerTask task, long delay) {
        this.timerService.schedule(task, delay);
    }

    public void executeOnThreadPool(Runnable runnable, String name) {
        this.threadPool.executeNamed(runnable, name);
    }

    public Executor getThreadPool() {
        return this.threadPool.getThreadPool();
    }

    public boolean isUltrapeerOS() {
        return !SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_WINDOWS_2000 || SystemUtils.IS_OS_WINDOWS_XP;
    }

    public void setUserMessageListener(UserMessageListener listener) {
        this.userMessageListener = listener;
    }

    public void fireDisplayUserMessage(String userMessageId) {
        if (this.userMessageListener != null) {
            this.userMessageListener.displayUserMessage(userMessageId, null);
        }
    }

    public void fireDisplayUserMessage(String userMessageId, String[] args) {
        if (this.userMessageListener != null) {
            this.userMessageListener.displayUserMessage(userMessageId, args);
        }
    }

    private static class Holder {
        protected static final Environment environment = new Environment();

        private Holder() {
        }
    }
}

