/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JThreadPool {
    private static final Logger logger = LoggerFactory.getLogger(JThreadPool.class);
    private final ThreadPoolExecutor pool = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new DefaultThreadFactory());

    public Executor getThreadPool() {
        return this.pool;
    }

    public void executeNamed(Runnable runnable, String name) {
        this.pool.execute(new NamedThreadRunnable(name, runnable));
    }

    public void shutdown() {
        this.pool.shutdown();
    }

    private static final class NamedThreadRunnable
    implements Runnable {
        private final String name;
        private final Runnable runnable;

        private NamedThreadRunnable(String name, Runnable runnable) {
            this.name = name;
            this.runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread currentThread = Thread.currentThread();
            String oldName = currentThread.getName();
            currentThread.setName(this.name + "-" + oldName);
            try {
                this.runnable.run();
            }
            catch (Throwable t) {
                logger.error(t.toString(), t);
            }
            finally {
                currentThread.setName(oldName);
            }
        }
    }

    private class DefaultThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        DefaultThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "PhexPool-thread-";
        }

        public Thread newThread(Runnable r) {
            logger.debug("Creating new thread for pool: {} {}", (Object)JThreadPool.this.pool.getPoolSize(), (Object)JThreadPool.this.pool.getActiveCount());
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

