/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaType {
    public static final String MEDIA_TYPE_ANY = "AnyMediaType";
    public static final String MEDIA_TYPE_AUDIO = "AudioMediaType";
    public static final String MEDIA_TYPE_VIDEO = "VideoMediaType";
    public static final String MEDIA_TYPE_PROGRAM = "ProgramMediaType";
    public static final String MEDIA_TYPE_IMAGES = "ImagesMediaType";
    public static final String MEDIA_TYPE_DOCUMENTS = "DocumentsMediaType";
    public static final String MEDIA_TYPE_ROMS = "RomsMediaType";
    public static final String MEDIA_TYPE_OPEN_FORMATS = "OpenFormatsType";
    public static final String MEDIA_TYPE_META = "MetaMediaType";
    public static final String[] AUDIO_FILE_EXT = new String[]{"aif", "aifc", "aiff", "ape", "apl", "au", "iso", "lqt", "mac", "med", "mid", "midi", "mod", "mp3", "mpa", "mpga", "mp1", "ogg", "ra", "ram", "rm", "rmi", "rmj", "snd", "vqf", "wav", "wma"};
    public static final String[] VIDEO_FILE_EXT = new String[]{"asf", "avi", "dcr", "div", "divx", "dv", "dvd", "ogm", "dvx", "flc", "fli", "flx", "jve", "m2p", "m2v", "m1v", "mkv", "mng", "mov", "mp2", "mp2v", "mp4", "mpe", "mpeg", "mpg", "mpv", "mpv2", "nsv", "ogg", "ram", "rm", "rv", "smi", "smil", "swf", "qt", "vcd", "vob", "vrml", "wml", "wmv"};
    public static final String[] PROGRAM_FILE_EXT = new String[]{"7z", "ace", "arj", "awk", "bin", "bz2", "cab", "csh", "deb", "dmg", "img", "exe", "gz", "gzip", "hqx", "iso", "jar", "lzh", "lha", "mdb", "msi", "msp", "pl", "rar", "rpm", "sh", "shar", "sit", "tar", "tgz", "taz", "z", "zip", "zoo", "pl", "ebuild"};
    public static final String[] IMAGE_FILE_EXT = new String[]{"ani", "bmp", "cpt", "cur", "dcx", "dib", "drw", "emf", "fax", "gif", "icl", "ico", "iff", "ilbm", "img", "jif", "jiff", "jpe", "jpeg", "jpg", "lbm", "mac", "mic", "pbm", "pcd", "pct", "pcx", "pic", "png", "pnm", "ppm", "psd", "ras", "rgb", "rle", "sgi", "sxd", "svg", "tga", "tif", "tiff", "wmf", "wpg", "xbm", "xcf", "xpm", "xwd"};
    public static final String[] DOCUMENTS_FILE_EXT = new String[]{"ans", "asc", "chm", "csv", "dif", "diz", "doc", "eml", "eps", "epsf", "hlp", "html", "htm", "info", "latex", "man", "mcw", "mht", "mhtml", "odt", "pdf", "ppt", "ps", "rtd", "rtf", "rtt", "sxw", "sxc", "tex", "texi", "txt", "wk1", "wps", "wri", "xhtml", "xls", "xml", "sla", "kwd"};
    public static final String[] ROMS_FILE_EXT = new String[]{"bin", "smd", "smc", "fig", "srm", "zip", "sav", "rar", "frz", "fra", "zs1", "pcx"};
    public static final String[] OPEN_FORMATS_FILE_EXT = new String[]{"ogg", "ogm", "tgz", "gz", "tbz", "bz2", "bz", "png", "flac", "tar", "gzip", "txt", "mkv", "odt", "sla", "kwd", "tex"};
    public static final String[] META_FILE_EXT = new String[]{"magma", "xml", "collection", "torrent", "col"};
    private static MediaType[] allMediaTypes = new MediaType[9];
    private static MediaType streamableMediaTypes;
    private String name;
    private Set<String> fileExtSet;
    private String fileTypesView;

    private MediaType(String aName, String[] fileExtArray) {
        this.name = aName;
        this.fileExtSet = new TreeSet<String>(Arrays.asList(fileExtArray));
    }

    private MediaType(String aName, Set<String> fileExtSet) {
        this.name = aName;
        this.fileExtSet = fileExtSet;
    }

    public String getName() {
        return this.name;
    }

    public String getFileTypesUIText() {
        if (this.fileTypesView == null) {
            if (this.fileExtSet == null || this.fileExtSet.size() == 0) {
                return "";
            }
            StringBuffer buffer = new StringBuffer(this.fileExtSet.size() * 5);
            buffer.append("<html>");
            int charCount = 0;
            Iterator<String> iterator = this.fileExtSet.iterator();
            while (iterator.hasNext()) {
                String val = iterator.next();
                buffer.append(val);
                charCount += val.length();
                if (iterator.hasNext()) {
                    buffer.append(", ");
                    charCount += 2;
                }
                if (charCount <= 50) continue;
                charCount = 0;
                buffer.append("<br>");
            }
            this.fileTypesView = buffer.toString();
        }
        return this.fileTypesView;
    }

    public boolean isExtensionOf(String extension) {
        if (this.fileExtSet == null) {
            return true;
        }
        extension = extension.toLowerCase();
        return this.fileExtSet.contains(extension);
    }

    public boolean isFilenameOf(String filename) {
        if (this.fileExtSet == null) {
            return true;
        }
        int index = filename.lastIndexOf(".");
        if (index == -1 || index == filename.length()) {
            return false;
        }
        String extension = filename.substring(index + 1, filename.length());
        return this.isExtensionOf(extension);
    }

    public static MediaType getStreamableMediaType() {
        return streamableMediaTypes;
    }

    public static MediaType[] getAllMediaTypes() {
        return allMediaTypes;
    }

    public static MediaType getMediaTypeAny() {
        return allMediaTypes[0];
    }

    public static MediaType getAudioMediaType() {
        return allMediaTypes[1];
    }

    public static MediaType getVideoMediaType() {
        return allMediaTypes[2];
    }

    public static MediaType getProgramMediaType() {
        return allMediaTypes[3];
    }

    public static MediaType getImageMediaType() {
        return allMediaTypes[4];
    }

    public static MediaType getDocumentsMediaType() {
        return allMediaTypes[5];
    }

    public static MediaType getRomsMediaType() {
        return allMediaTypes[6];
    }

    public static MediaType getOpenFormatsMediaType() {
        return allMediaTypes[7];
    }

    public static MediaType getMetaMediaType() {
        return allMediaTypes[8];
    }

    public static MediaType getNoWmvMovAsfMediaType() {
        return allMediaTypes[9];
    }

    public static MediaType getTypeForName(String name) {
        if (name.equals(MEDIA_TYPE_ANY)) {
            return MediaType.getMediaTypeAny();
        }
        if (name.equals(MEDIA_TYPE_AUDIO)) {
            return MediaType.getAudioMediaType();
        }
        if (name.equals(MEDIA_TYPE_VIDEO)) {
            return MediaType.getVideoMediaType();
        }
        if (name.equals(MEDIA_TYPE_PROGRAM)) {
            return MediaType.getProgramMediaType();
        }
        if (name.equals(MEDIA_TYPE_IMAGES)) {
            return MediaType.getImageMediaType();
        }
        if (name.equals(MEDIA_TYPE_DOCUMENTS)) {
            return MediaType.getDocumentsMediaType();
        }
        if (name.equals(MEDIA_TYPE_ROMS)) {
            return MediaType.getRomsMediaType();
        }
        if (name.equals(MEDIA_TYPE_OPEN_FORMATS)) {
            return MediaType.getOpenFormatsMediaType();
        }
        if (name.equals(MEDIA_TYPE_META)) {
            return MediaType.getMetaMediaType();
        }
        return null;
    }

    static {
        MediaType.allMediaTypes[0] = new MediaType(MEDIA_TYPE_ANY, (Set<String>)null);
        MediaType.allMediaTypes[1] = new MediaType(MEDIA_TYPE_AUDIO, AUDIO_FILE_EXT);
        MediaType.allMediaTypes[2] = new MediaType(MEDIA_TYPE_VIDEO, VIDEO_FILE_EXT);
        MediaType.allMediaTypes[3] = new MediaType(MEDIA_TYPE_PROGRAM, PROGRAM_FILE_EXT);
        MediaType.allMediaTypes[4] = new MediaType(MEDIA_TYPE_IMAGES, IMAGE_FILE_EXT);
        MediaType.allMediaTypes[5] = new MediaType(MEDIA_TYPE_DOCUMENTS, DOCUMENTS_FILE_EXT);
        MediaType.allMediaTypes[6] = new MediaType(MEDIA_TYPE_ROMS, ROMS_FILE_EXT);
        MediaType.allMediaTypes[7] = new MediaType(MEDIA_TYPE_OPEN_FORMATS, OPEN_FORMATS_FILE_EXT);
        MediaType.allMediaTypes[8] = new MediaType(MEDIA_TYPE_META, META_FILE_EXT);
        TreeSet<String> concatSet = new TreeSet<String>();
        concatSet.addAll(Arrays.asList(AUDIO_FILE_EXT));
        concatSet.addAll(Arrays.asList(VIDEO_FILE_EXT));
        streamableMediaTypes = new MediaType("", concatSet);
    }
}

