/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.io.File;
import phex.common.Environment;
import phex.common.GnutellaNetwork;
import phex.utils.FileUtils;

public class NamedGnutellaNetwork
extends GnutellaNetwork {
    private String networkName;

    public NamedGnutellaNetwork(String name) {
        this.networkName = name;
    }

    public String getName() {
        return this.networkName;
    }

    public File getHostsFile() {
        String filename = "phex_" + this.networkName + ".hosts";
        filename = FileUtils.convertToLocalSystemFilename(filename);
        return Environment.getInstance().getPhexConfigFile(filename);
    }

    public File getFavoritesFile() {
        String filename = this.networkName + "_" + "favorites.xml";
        filename = FileUtils.convertToLocalSystemFilename(filename);
        return Environment.getInstance().getPhexConfigFile(filename);
    }

    public File getSearchFilterFile() {
        String filename = this.networkName + "_" + "searchfilters.xml";
        filename = FileUtils.convertToLocalSystemFilename(filename);
        return Environment.getInstance().getPhexConfigFile(filename);
    }

    public File getGWebCacheFile() {
        String filename = this.networkName + "_" + "gwebcache.cfg";
        filename = FileUtils.convertToLocalSystemFilename(filename);
        return Environment.getInstance().getPhexConfigFile(filename);
    }

    public File getUdpHostCacheFile() {
        String filename = this.networkName + "_" + "udphostcache.cfg";
        filename = FileUtils.convertToLocalSystemFilename(filename);
        return Environment.getInstance().getPhexConfigFile(filename);
    }

    public String getNetworkGreeting() {
        return "GNUTELLA PCONNECT " + this.networkName;
    }
}

