/*
 * Decompiled with CFR 0.152.
 */
package phex.common.bandwidth;

public class TransferAverage {
    private int refreshRate;
    private int period;
    private long updateTimeFactor;
    private long[] values;

    public TransferAverage(int refreshRate, int period) {
        if (period * 1000 < refreshRate) {
            throw new IllegalArgumentException("Invalid period");
        }
        this.refreshRate = refreshRate;
        this.period = period;
        this.updateTimeFactor = System.currentTimeMillis() / (long)refreshRate;
        int elementCount = period * 1000 / refreshRate + 2;
        this.values = new long[elementCount];
    }

    private synchronized void update(long currentTimeFactor) {
        if (this.updateTimeFactor < currentTimeFactor - (long)this.values.length) {
            this.updateTimeFactor = currentTimeFactor - (long)this.values.length - 1L;
        }
        for (long i = this.updateTimeFactor + 1L; i <= currentTimeFactor; ++i) {
            this.values[(int)(i % (long)this.values.length)] = 0L;
        }
        this.values[(int)((currentTimeFactor + 1L) % (long)this.values.length)] = 0L;
        this.updateTimeFactor = currentTimeFactor;
    }

    public void addValue(long value) {
        long currentTimeFactor = System.currentTimeMillis() / (long)this.refreshRate;
        this.update(currentTimeFactor);
        int n = (int)(currentTimeFactor % (long)this.values.length);
        this.values[n] = this.values[n] + value;
    }

    public long getAverage() {
        long currentTimeFactor = System.currentTimeMillis() / (long)this.refreshRate;
        this.update(currentTimeFactor);
        long sum = 0L;
        for (long i = currentTimeFactor + 2L; i < currentTimeFactor + (long)this.values.length; ++i) {
            sum += this.values[(int)(i % (long)this.values.length)];
        }
        return sum / (long)this.period;
    }

    public String toString() {
        return super.toString() + " Rate: " + this.refreshRate + " Period: " + this.period + " Avg: " + this.getAverage();
    }
}

