/*
 * Decompiled with CFR 0.152.
 */
package phex.common.file;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.commons.collections.map.ReferenceMap;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.common.file.ReadOnlyManagedFile;
import phex.prefs.core.FilePrefs;

public class FileManager {
    private static FileManager instance;
    private ReferenceMap fileManagedFileMap = new ReferenceMap(2, 2);
    private LinkedHashMap<ManagedFile, ManagedFile> openFileMap;

    public static FileManager getInstance() {
        if (instance == null) {
            instance = new FileManager();
        }
        return instance;
    }

    public void shutdown() {
        if (this.openFileMap == null) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagedFile getManagedFile(File file) {
        ReferenceMap referenceMap = this.fileManagedFileMap;
        synchronized (referenceMap) {
            ManagedFile managedFile = (ManagedFile)this.fileManagedFileMap.get(file);
            if (managedFile == null) {
                managedFile = new ManagedFile(file);
                this.fileManagedFileMap.put(file, managedFile);
            }
            return managedFile;
        }
    }

    public ManagedFile getReadWriteManagedFile(File file) throws ManagedFileException {
        ManagedFile managedFile = this.getManagedFile(file);
        managedFile.setAccessMode(ManagedFile.AccessMode.READ_WRITE_ACCESS);
        return managedFile;
    }

    public ReadOnlyManagedFile getReadOnlyManagedFile(File file) throws ManagedFileException {
        ManagedFile managedFile = this.getManagedFile(file);
        managedFile.setAccessMode(ManagedFile.AccessMode.READ_ONLY_ACCESS);
        return managedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOpenFileTracking() {
        if (FilePrefs.OpenFilesLimit.get() == 0) {
            this.openFileMap = null;
            return;
        }
        FileManager fileManager = this;
        synchronized (fileManager) {
            if (this.openFileMap == null) {
                this.openFileMap = new LinkedHashMap(FilePrefs.OpenFilesLimit.get(), 0.75f, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackFileOpen(ManagedFile managedFile) throws ManagedFileException {
        this.initOpenFileTracking();
        if (this.openFileMap == null) {
            return;
        }
        ManagedFile oldestEntry = null;
        LinkedHashMap<ManagedFile, ManagedFile> linkedHashMap = this.openFileMap;
        synchronized (linkedHashMap) {
            if (this.openFileMap.size() >= FilePrefs.OpenFilesLimit.get()) {
                Iterator<ManagedFile> iterator = this.openFileMap.keySet().iterator();
                oldestEntry = iterator.next();
                iterator.remove();
            }
            this.openFileMap.put(managedFile, managedFile);
        }
        if (oldestEntry != null) {
            oldestEntry.closeFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackFileInUse(ManagedFile managedFile) {
        this.initOpenFileTracking();
        if (this.openFileMap == null) {
            return;
        }
        LinkedHashMap<ManagedFile, ManagedFile> linkedHashMap = this.openFileMap;
        synchronized (linkedHashMap) {
            if (this.openFileMap.containsKey(managedFile)) {
                this.openFileMap.get(managedFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackFileClose(ManagedFile managedFile) {
        this.initOpenFileTracking();
        if (this.openFileMap == null) {
            return;
        }
        LinkedHashMap<ManagedFile, ManagedFile> linkedHashMap = this.openFileMap;
        synchronized (linkedHashMap) {
            this.openFileMap.remove(managedFile);
        }
    }
}

