/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.io.IOException;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import phex.common.address.AddressUtils;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.common.address.MalformedDestAddressException;
import phex.connection.ConnectionClosedException;
import phex.connection.ConnectionConstants;
import phex.connection.ConnectionRejectedException;
import phex.connection.handshake.HandshakeHandler;
import phex.connection.handshake.HandshakeStatus;
import phex.host.CaughtHostsContainer;
import phex.host.Host;
import phex.host.HostStatus;
import phex.http.HTTPHeader;
import phex.http.HTTPHeaderGroup;
import phex.http.HTTPProcessor;
import phex.io.buffer.ByteBuffer;
import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msg.MessageProcessor;
import phex.msg.MsgHeader;
import phex.msg.vendor.CapabilitiesVMsg;
import phex.msg.vendor.MessagesSupportedVMsg;
import phex.msghandling.MessageService;
import phex.net.connection.Connection;
import phex.net.repres.PresentationManager;
import phex.prefs.core.MessagePrefs;
import phex.security.AccessType;
import phex.security.PhexSecurityManager;
import phex.servent.Servent;
import phex.utils.HexConverter;
import phex.utils.Localizer;

public class ConnectionEngine
implements ConnectionConstants {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionEngine.class);
    private final Servent servent;
    private final MessageService messageService;
    private final PhexSecurityManager securityService;
    private byte[] headerBuffer;
    private final Host connectedHost;
    private final Connection connection;
    private HTTPHeaderGroup headersRead;
    private HTTPHeaderGroup headersSend;

    public ConnectionEngine(Servent servent, Host connectedHost) {
        this.servent = servent;
        this.messageService = servent.getMessageService();
        this.securityService = servent.getSecurityService();
        this.connectedHost = connectedHost;
        this.connection = connectedHost.getConnection();
    }

    public void processIncomingData() throws IOException {
        this.headerBuffer = new byte[23];
        try {
            while (true) {
                Message message;
                MsgHeader header;
                block12: {
                    header = this.readHeader();
                    byte[] body = MessageProcessor.readMessageBody(this.connection, header.getDataLength());
                    this.connectedHost.incReceivedCount();
                    byte ttl = header.getTTL();
                    byte hops = header.getHopsTaken();
                    if (ttl < 0 || hops < 0) {
                        this.messageService.dropMessage(header, body, "TTL or hops below 0", this.connectedHost);
                        continue;
                    }
                    if (hops > MessagePrefs.MaxNetworkTTL.get()) {
                        this.messageService.dropMessage(header, body, "Hops larger then maxNetworkTTL", this.connectedHost);
                        continue;
                    }
                    if (ttl >= MessagePrefs.MaxNetworkTTL.get()) {
                        header.setTTL((byte)(MessagePrefs.MaxNetworkTTL.get() - hops));
                    }
                    try {
                        message = MessageProcessor.createMessageFromBody(header, body, this.securityService);
                        if (message == null) {
                            this.messageService.dropMessage(header, body, "Unknown message type", this.connectedHost);
                        }
                        break block12;
                    }
                    catch (InvalidMessageException exp) {
                        this.messageService.dropMessage(header, body, "Invalid message: " + exp.getMessage(), this.connectedHost);
                        logger.warn(exp.toString(), (Throwable)exp);
                    }
                    continue;
                }
                header.countHop();
                this.messageService.dispatchMessage(message, this.connectedHost);
            }
        }
        catch (IOException exp) {
            logger.debug(exp.toString(), (Throwable)exp);
            if (this.connectedHost.isConnected()) {
                this.connectedHost.setStatus(HostStatus.ERROR, exp.getMessage());
                this.connectedHost.disconnect();
            }
            throw exp;
        }
        catch (Exception exp) {
            logger.warn(exp.toString(), (Throwable)exp);
            if (this.connectedHost.isConnected()) {
                this.connectedHost.setStatus(HostStatus.ERROR, exp.getMessage());
                this.connectedHost.disconnect();
            }
            throw new IOException("Exception occured: " + exp.getMessage());
        }
    }

    private MsgHeader readHeader() throws IOException {
        MsgHeader header = MessageProcessor.parseMessageHeader(this.connection, this.headerBuffer);
        if (header == null) {
            throw new ConnectionClosedException("Connection closed by remote host");
        }
        int length = header.getDataLength();
        if (length < 0) {
            throw new IOException("Negative body size. Disconnecting the remote host.");
        }
        if (length > MessagePrefs.MaxLength.get()) {
            if (logger.isWarnEnabled()) {
                byte[] body = MessageProcessor.readMessageBody(this.connection, 262144);
                String hexBody = HexConverter.toHexString(body);
                logger.warn(this.connectedHost + " - Body too big. Header: " + header + "\nBody(256KB): " + hexBody);
            }
            throw new IOException("Packet too big. Disconnecting the remote host.");
        }
        header.setArrivalTime(System.currentTimeMillis());
        return header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initHostHandshake() throws IOException {
        try {
            if (this.connectedHost.isIncomming()) {
                this.initializeIncomingWith06();
            } else {
                this.initializeOutgoingWith06();
            }
            this.configureConnectionType(this.headersSend, this.headersRead);
            this.postHandshakeConfiguration(this.headersSend, this.headersRead);
        }
        finally {
            if (this.headersRead != null) {
                this.handleXTryHeaders(this.headersRead);
                this.headersRead = null;
                this.headersSend = null;
            }
        }
        this.connectedHost.setStatus(HostStatus.CONNECTED);
        if (this.connectedHost.isIncomming()) {
            this.servent.getHostService().addIncomingHost(this.connectedHost);
        } else {
            this.servent.getHostService().addConnectedHost(this.connectedHost);
        }
        this.servent.getMessageService().sendUdpPing(this.connectedHost.getHostAddress());
        this.servent.getMessageService().pingHost(this.connectedHost, MessagePrefs.TTL.get().byteValue());
        if (this.connectedHost.isVendorMessageSupported()) {
            MessagesSupportedVMsg vMsg = MessagesSupportedVMsg.getMyMsgSupported();
            this.connectedHost.queueMessageToSend(vMsg);
            CapabilitiesVMsg capVMsg = CapabilitiesVMsg.getMyCapabilitiesVMsg();
            this.connectedHost.queueMessageToSend(capVMsg);
        }
    }

    private void initializeIncomingWith06() throws IOException {
        this.headersRead = HTTPProcessor.parseHTTPHeaders(this.connection);
        if (logger.isDebugEnabled()) {
            logger.debug("{} - Connect headers: {}", (Object)this.connectedHost, (Object)this.headersRead.buildHTTPHeaderString());
        }
        this.configureRemoteHost(this.headersRead);
        HandshakeHandler handshakeHandler = HandshakeHandler.createHandshakeHandler(this.servent, this.connectedHost);
        HandshakeStatus myResponse = handshakeHandler.createHandshakeResponse(new HandshakeStatus(this.headersRead), false);
        this.headersSend = myResponse.getResponseHeaders();
        this.sendStringToHost("GNUTELLA/0.6 " + myResponse.getStatusCode() + " " + myResponse.getStatusMessage() + "\r\n");
        String httpHeaderString = myResponse.getResponseHeaders().buildHTTPHeaderString();
        this.sendStringToHost(httpHeaderString);
        this.sendStringToHost("\r\n");
        if (myResponse.getStatusCode() != 200) {
            throw new IOException("Connection not accepted: " + myResponse.getStatusCode() + " " + myResponse.getStatusMessage());
        }
        HandshakeStatus inResponse = HandshakeStatus.parseHandshakeResponse(this.connection);
        if (logger.isDebugEnabled()) {
            logger.debug(this.connectedHost + " - Response Code: '" + inResponse.getStatusCode() + "'.");
            logger.debug(this.connectedHost + " - Response Message: '" + inResponse.getStatusMessage() + "'.");
            logger.debug(this.connectedHost + " - Response Headers: " + inResponse.getResponseHeaders().buildHTTPHeaderString());
        }
        if (inResponse.getStatusCode() != 200) {
            throw new IOException("Host rejected connection: " + inResponse.getStatusCode() + " " + inResponse.getStatusMessage());
        }
        this.headersRead.replaceHeaders(inResponse.getResponseHeaders());
    }

    private void initializeOutgoingWith06() throws IOException {
        this.connectedHost.setStatus(HostStatus.CONNECTING, Localizer.getString("Negotiate0_6Handshake"));
        String greeting = this.servent.getGnutellaNetwork().getNetworkGreeting();
        String requestLine = greeting + '/' + "0.6" + "\r\n";
        StringBuffer requestBuffer = new StringBuffer(100);
        requestBuffer.append(requestLine);
        HandshakeHandler handshakeHandler = HandshakeHandler.createHandshakeHandler(this.servent, this.connectedHost);
        HTTPHeaderGroup handshakeHeaders = handshakeHandler.createOutgoingHandshakeHeaders();
        requestBuffer.append(handshakeHeaders.buildHTTPHeaderString());
        requestBuffer.append("\r\n");
        this.headersSend = handshakeHeaders;
        String requestStr = requestBuffer.toString();
        this.sendStringToHost(requestStr);
        HandshakeStatus handshakeResponse = HandshakeStatus.parseHandshakeResponse(this.connection);
        this.headersRead = handshakeResponse.getResponseHeaders();
        if (logger.isDebugEnabled()) {
            logger.debug(this.connectedHost + " - Response Code: '" + handshakeResponse.getStatusCode() + "'.");
            logger.debug(this.connectedHost + " - Response Message: '" + handshakeResponse.getStatusMessage() + "'.");
            logger.debug(this.connectedHost + " - Response Headers: " + this.headersRead.buildHTTPHeaderString());
        }
        if (handshakeResponse.getStatusCode() != 200) {
            if (handshakeResponse.getStatusCode() == 503) {
                throw new ConnectionRejectedException(handshakeResponse.getStatusCode() + " " + handshakeResponse.getStatusMessage());
            }
            throw new ConnectionRejectedException("Gnutella 0.6 connection rejected. Status: " + handshakeResponse.getStatusCode() + " - " + handshakeResponse.getStatusMessage());
        }
        this.configureRemoteHost(this.headersRead);
        HandshakeStatus myResponse = handshakeHandler.createHandshakeResponse(handshakeResponse, true);
        HTTPHeaderGroup myResponseHeaders = myResponse.getResponseHeaders();
        this.headersSend.replaceHeaders(myResponseHeaders);
        this.sendStringToHost("GNUTELLA/0.6 " + myResponse.getStatusCode() + " " + myResponse.getStatusMessage() + "\r\n");
        String httpHeaderString = myResponseHeaders.buildHTTPHeaderString();
        this.sendStringToHost(httpHeaderString);
        this.sendStringToHost("\r\n");
        if (myResponse.getStatusCode() != 200) {
            throw new ConnectionRejectedException("Connection not accepted: " + myResponse.getStatusCode() + " " + myResponse.getStatusMessage());
        }
    }

    private void configureConnectionType(HTTPHeaderGroup myHeadersSend, HTTPHeaderGroup theirHeadersRead) {
        HTTPHeader myUPHeader = myHeadersSend.getHeader("X-Ultrapeer");
        HTTPHeader theirUPHeader = theirHeadersRead.getHeader("X-Ultrapeer");
        if (myUPHeader == null || theirUPHeader == null) {
            this.connectedHost.setConnectionType((byte)0);
        } else if (myUPHeader.booleanValue()) {
            if (theirUPHeader.booleanValue()) {
                this.connectedHost.setConnectionType((byte)2);
            } else {
                this.connectedHost.setConnectionType((byte)3);
            }
        } else if (theirUPHeader.booleanValue()) {
            this.connectedHost.setConnectionType((byte)1);
        } else {
            this.connectedHost.setConnectionType((byte)0);
        }
    }

    private void handleXTryHeaders(HTTPHeaderGroup headers) {
        HTTPHeader[] hostAddresses = headers.getHeaders("X-Try");
        if (hostAddresses != null) {
            this.handleXTryHosts(hostAddresses, true);
        }
        if ((hostAddresses = headers.getHeaders("X-Try-Ultrapeers")) != null) {
            this.handleXTryHosts(hostAddresses, false);
        }
    }

    private void handleXTryHosts(HTTPHeader[] xtryHostAdresses, boolean isUltrapeerList) {
        short priority = isUltrapeerList ? (short)2 : 1;
        CaughtHostsContainer hostContainer = this.servent.getHostService().getCaughtHostsContainer();
        for (int i = 0; i < xtryHostAdresses.length; ++i) {
            StringTokenizer tokenizer = new StringTokenizer(xtryHostAdresses[i].getValue(), ",");
            block6: while (tokenizer.hasMoreTokens()) {
                String hostAddressStr = tokenizer.nextToken().trim();
                try {
                    DestAddress address = PresentationManager.getInstance().createHostAddress(hostAddressStr, 6346);
                    AccessType access = this.securityService.controlHostAddressAccess(address);
                    switch (access) {
                        case ACCESS_DENIED: 
                        case ACCESS_STRONGLY_DENIED: {
                            continue block6;
                        }
                    }
                    IpAddress ipAddress = address.getIpAddress();
                    if (!isUltrapeerList && ipAddress != null && ipAddress.isSiteLocalIP()) {
                        priority = 0;
                    }
                    hostContainer.addCaughtHost(address, priority);
                }
                catch (MalformedDestAddressException exp) {}
            }
        }
    }

    private void configureRemoteHost(HTTPHeaderGroup headers) {
        byte[] remoteIP;
        HTTPHeader header = headers.getHeader("User-Agent");
        if (header != null) {
            this.connectedHost.setVendor(header.getValue());
        }
        if (this.connectedHost.isIncomming()) {
            header = headers.getHeader("Listen-IP");
            if (header == null) {
                header = headers.getHeader("X-My-Address");
            }
            if (header != null) {
                DestAddress addi = this.connectedHost.getHostAddress();
                int port = AddressUtils.parsePort(header.getValue());
                if (port > 0) {
                    this.connectedHost.setHostAddress(new DefaultDestAddress(addi.getIpAddress(), port));
                }
            }
        }
        if ((header = headers.getHeader("Remote-IP")) != null && (remoteIP = AddressUtils.parseIP(header.getValue())) != null) {
            IpAddress ip = new IpAddress(remoteIP);
            DestAddress address = PresentationManager.getInstance().createHostAddress(ip, -1);
            this.servent.updateLocalAddress(address);
        }
        if ((header = headers.getHeader("X-Query-Routing")) != null) {
            try {
                float version = Float.parseFloat(header.getValue());
                if (version >= 0.1f) {
                    this.connectedHost.setQueryRoutingSupported(true);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((header = headers.getHeader("X-Ultrapeer-Query-Routing")) != null) {
            try {
                float version = Float.parseFloat(header.getValue());
                if (version >= 0.1f) {
                    this.connectedHost.setUPQueryRoutingSupported(true);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((header = headers.getHeader("X-Dynamic-Querying")) != null) {
            try {
                float version = header.floatValue();
                if (version >= 0.1f) {
                    this.connectedHost.setDynamicQuerySupported(true);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        byte maxTTL = headers.getByteHeaderValue("X-Max-TTL", (byte)4);
        this.connectedHost.setMaxTTL(maxTTL);
        int degree = headers.getIntHeaderValue("X-Degree", 6);
        this.connectedHost.setUltrapeerDegree(degree);
    }

    private void postHandshakeConfiguration(HTTPHeaderGroup myHeadersSend, HTTPHeaderGroup theirHeadersRead) throws IOException {
        HTTPHeader header;
        if (myHeadersSend.isHeaderValueContaining("Accept-Encoding", "deflate") && theirHeadersRead.isHeaderValueContaining("Content-Encoding", "deflate")) {
            this.connectedHost.activateInputInflation();
        }
        if (theirHeadersRead.isHeaderValueContaining("Accept-Encoding", "deflate") && myHeadersSend.isHeaderValueContaining("Content-Encoding", "deflate")) {
            this.connectedHost.activateOutputDeflation();
        }
        if ((header = theirHeadersRead.getHeader("Vendor-Message")) != null && !header.getValue().equals("")) {
            this.connectedHost.setVendorMessageSupported(true);
        }
    }

    private void sendStringToHost(String str) throws IOException {
        logger.debug("{} - Send: {}", (Object)this.connectedHost, (Object)str);
        byte[] bytes = str.getBytes("ISO8859-1");
        this.connection.write(ByteBuffer.wrap(bytes));
        this.connection.flush();
    }
}

