/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.util.ArrayList;
import java.util.List;
import phex.common.ThreadTracking;
import phex.common.log.NLogger;
import phex.host.Host;
import phex.host.HostStatus;
import phex.host.NetworkHostsContainer;
import phex.msghandling.MessageService;
import phex.utils.Localizer;

public class ConnectionObserver
implements Runnable {
    private long SLEEP_TIME = 30000L;
    private long PING_WAIT_TIME = 20000L;
    private List<ConnectionSnapshoot> snapshootList;
    private List<Host> quiteList;
    private final NetworkHostsContainer networkHostsContainer;
    private final MessageService messageService;

    public ConnectionObserver(NetworkHostsContainer networkHostsContainer, MessageService messageService) {
        this.networkHostsContainer = networkHostsContainer;
        this.messageService = messageService;
    }

    public void start() {
        Thread thread = new Thread(ThreadTracking.rootThreadGroup, this, "ConnectionObserver-" + Integer.toHexString(this.hashCode()));
        thread.setPriority(5);
        thread.setDaemon(true);
        thread.start();
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        this.snapshootList = new ArrayList<ConnectionSnapshoot>();
        this.quiteList = new ArrayList<Host>();
        block4: while (true) {
            this.snapshootList.clear();
            this.quiteList.clear();
            hosts = this.networkHostsContainer.getUltrapeerConnections();
            this.createSnapshoots(hosts);
            hosts = this.networkHostsContainer.getLeafConnections();
            this.createSnapshoots(hosts);
            try {
                Thread.sleep(this.SLEEP_TIME);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            hosts = this.networkHostsContainer.getUltrapeerConnections();
            this.findQuiteHosts(hosts);
            hosts = this.networkHostsContainer.getLeafConnections();
            this.findQuiteHosts(hosts);
            if (this.quiteList.size() <= 0) continue;
            size = this.quiteList.size();
            for (i = 0; i < size; ++i) {
                host = this.quiteList.get(i);
                NLogger.debug(ConnectionObserver.class, host + " - Sending keep alive ping. ");
                this.messageService.pingHost(host);
            }
            try {
                Thread.sleep(this.PING_WAIT_TIME);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            i = 0;
            while (true) {
                if (i < size) ** break;
                continue block4;
                host = this.quiteList.get(i);
                shoot = this.findSnapshoot(host);
                if (shoot.hasBeenQuite()) {
                    host.setStatus(HostStatus.ERROR, Localizer.getString("HostNotResponding"));
                    NLogger.debug(ConnectionObserver.class, host + " - Host not responding, disconnecting..");
                    host.disconnect();
                }
                ++i;
            }
            break;
        }
    }

    private void findQuiteHosts(Host[] hosts) {
        for (int i = 0; i < hosts.length; ++i) {
            ConnectionSnapshoot shoot = this.findSnapshoot(hosts[i]);
            if (shoot == null || !shoot.hasBeenQuite()) continue;
            this.quiteList.add(hosts[i]);
        }
    }

    private void createSnapshoots(Host[] hosts) {
        for (int i = 0; i < hosts.length; ++i) {
            this.snapshootList.add(new ConnectionSnapshoot(hosts[i]));
        }
    }

    private ConnectionSnapshoot findSnapshoot(Host host) {
        int size = this.snapshootList.size();
        for (int i = 0; i < size; ++i) {
            ConnectionSnapshoot shoot = this.snapshootList.get(i);
            if (shoot.host != host) continue;
            return shoot;
        }
        return null;
    }

    private static class ConnectionSnapshoot {
        Host host;
        int receivedCount;
        int sentCount;
        int sendDropCount;

        ConnectionSnapshoot(Host host) {
            this.host = host;
            this.receivedCount = host.getReceivedCount();
            this.sentCount = host.getSentCount();
            this.sendDropCount = host.getSentDropCount();
        }

        public boolean hasBeenQuite() {
            int receivedDiff = this.host.getReceivedCount() - this.receivedCount;
            int sentDiff = this.host.getSentCount() - this.sentCount;
            int sendDropDiff = this.host.getSentDropCount() - this.sendDropCount;
            if (receivedDiff == 0) {
                return true;
            }
            return sentDiff == sendDropDiff && sentDiff != 0;
        }
    }
}

