/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.io.IOException;
import phex.connection.FlowControlQueue;
import phex.host.Host;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.servent.Servent;
import phex.statistic.SimpleStatisticProvider;
import phex.statistic.StatisticsManager;

public class MessageQueue {
    private static final int MAX_QUEUE_SIZE = 100;
    private static final int LONG_TIMEOUT = 10000;
    private static final int SHORT_TIMEOUT = 5000;
    private static final int PRIORITY_COUNT = 8;
    private static final int PRIORITY_URGENT = 0;
    private static final int PRIORITY_MY_QUERY = 1;
    private static final int PRIORITY_PUSH = 2;
    private static final int PRIORITY_QUERY_HIT = 3;
    private static final int PRIORITY_QUERY = 4;
    private static final int PRIORITY_PONG = 5;
    private static final int PRIORITY_PING = 6;
    private static final int PRIORITY_OTHER = 7;
    private Host host;
    private FlowControlQueue[] flowControlQueue;
    private int queuedCount;
    private int lastPriorityAdded;

    public MessageQueue(Host host) {
        this.host = host;
        this.flowControlQueue = new FlowControlQueue[8];
        this.flowControlQueue[0] = new FlowControlQueue(1, Integer.MAX_VALUE, 100, true);
        this.flowControlQueue[1] = new FlowControlQueue(10, 10000, 100, true);
        this.flowControlQueue[2] = new FlowControlQueue(6, 10000, 100, true);
        this.flowControlQueue[3] = new FlowControlQueue(6, 10000, 100, true);
        this.flowControlQueue[4] = new FlowControlQueue(3, 5000, 100, true);
        this.flowControlQueue[5] = new FlowControlQueue(1, 5000, 100, true);
        this.flowControlQueue[6] = new FlowControlQueue(1, 5000, 100, true);
        this.flowControlQueue[7] = new FlowControlQueue(1, Integer.MAX_VALUE, 100, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(Message msg) {
        int priority = this.calculatePriority(msg);
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.flowControlQueue[priority].addMessage(msg);
            int tmpDropCount = this.flowControlQueue[priority].getAndResetDropCount();
            this.host.incSentDropCount(tmpDropCount);
            StatisticsManager statMgr = Servent.getInstance().getStatisticsService();
            ((SimpleStatisticProvider)statMgr.getStatisticProvider("DropedMsgOutProvider")).increment(tmpDropCount);
            this.queuedCount += 1 - tmpDropCount;
            this.lastPriorityAdded = priority;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendQueuedMessages() throws IOException {
        int start;
        boolean isQueueEmpty = false;
        int i = start = this.lastPriorityAdded;
        block3: do {
            FlowControlQueue queue = this.flowControlQueue[i];
            queue.initNewMessageBurst();
            while (true) {
                Message msg;
                MessageQueue messageQueue = this;
                synchronized (messageQueue) {
                    msg = queue.removeMessage();
                    int tmpDropCount = queue.getAndResetDropCount();
                    this.host.incSentDropCount(tmpDropCount);
                    StatisticsManager statMgr = Servent.getInstance().getStatisticsService();
                    ((SimpleStatisticProvider)statMgr.getStatisticProvider("DropedMsgOutProvider")).increment(tmpDropCount);
                    this.queuedCount = msg == null ? (this.queuedCount -= tmpDropCount) : (this.queuedCount -= 1 + tmpDropCount);
                    if (this.queuedCount == 0) {
                        isQueueEmpty = true;
                    }
                    if (msg == null) {
                        continue block3;
                    }
                }
                this.host.sendMessage(msg);
            }
        } while (!isQueueEmpty && (i = (i + 1) % 8) != start);
        this.host.flushOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueuedMessageCount() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            return this.queuedCount;
        }
    }

    private int calculatePriority(Message msg) {
        MsgHeader header = msg.getHeader();
        byte messageCode = header.getPayload();
        switch (messageCode) {
            case 0: {
                if (header.getHopsTaken() == 0 && header.getTTL() <= 2) {
                    return 0;
                }
                return 6;
            }
            case 1: {
                if (header.getHopsTaken() == 0 && header.getTTL() <= 2) {
                    return 0;
                }
                return 5;
            }
            case 64: {
                return 2;
            }
            case -127: {
                return 3;
            }
            case -128: {
                if (header.getHopsTaken() == 0) {
                    return 1;
                }
                return 4;
            }
        }
        return 7;
    }
}

