/*
 * Decompiled with CFR 0.152.
 */
package phex.connection.handshake;

import phex.connection.ConnectionConstants;
import phex.connection.handshake.HandshakeHandler;
import phex.connection.handshake.HandshakeStatus;
import phex.host.Host;
import phex.host.NetworkHostsContainer;
import phex.http.HTTPHeader;
import phex.http.HTTPHeaderGroup;
import phex.prefs.core.ConnectionPrefs;
import phex.servent.Servent;

public class UltrapeerHandshakeHandler
extends HandshakeHandler
implements ConnectionConstants {
    public UltrapeerHandshakeHandler(Servent servent, Host connectedHost) {
        super(servent, connectedHost);
    }

    protected HTTPHeaderGroup createDefaultHandshakeHeaders() {
        HTTPHeaderGroup openHeaders = super.createDefaultHandshakeHeaders();
        openHeaders.addHeader(new HTTPHeader("X-Ultrapeer", "true"));
        openHeaders.addHeader(new HTTPHeader("X-Query-Routing", "0.1"));
        openHeaders.addHeader(new HTTPHeader("X-Ultrapeer-Query-Routing", "0.1"));
        openHeaders.addHeader(new HTTPHeader("X-Dynamic-Querying", "0.1"));
        openHeaders.addHeader(new HTTPHeader("X-Degree", ConnectionPrefs.Up2UpConnections.get().toString()));
        openHeaders.addHeader(new HTTPHeader("X-Max-TTL", String.valueOf(4)));
        return openHeaders;
    }

    public HandshakeStatus createHandshakeResponse(HandshakeStatus hostResponse, boolean isOutgoing) {
        if (isOutgoing) {
            return this.createOutgoingResponse(hostResponse);
        }
        return this.createIncomingResponse(hostResponse);
    }

    private HandshakeStatus createIncomingResponse(HandshakeStatus hostResponse) {
        HTTPHeaderGroup headers = hostResponse.getResponseHeaders();
        boolean isCrawler = this.isCrawlerConnection(headers);
        if (isCrawler) {
            return this.createCrawlerHandshakeStatus();
        }
        HTTPHeader upHeader = headers.getHeader("X-Ultrapeer");
        if (!this.isConnectionAccepted(upHeader)) {
            return new HandshakeStatus(503, "I am busy.", this.createRejectIncomingHeaders());
        }
        HTTPHeaderGroup myHeaders = this.createDefaultHandshakeHeaders();
        if (upHeader != null && Boolean.valueOf(upHeader.getValue()).booleanValue()) {
            boolean isUltrapeerNeeded = this.servent.getHostService().getNetworkHostsContainer().hasUltrapeerSlotsAvailable();
            String isUltrapeedNeededStr = isUltrapeerNeeded ? "true" : "false";
            myHeaders.addHeader(new HTTPHeader("X-Ultrapeer-Needed", isUltrapeedNeededStr));
        }
        if (hostResponse.isDeflateAccepted()) {
            myHeaders.addHeader(new HTTPHeader("Content-Encoding", "deflate"));
        }
        return new HandshakeStatus(200, "OK", myHeaders);
    }

    private HandshakeStatus createOutgoingResponse(HandshakeStatus hostResponse) {
        HTTPHeaderGroup headers = hostResponse.getResponseHeaders();
        HTTPHeader upHeader = headers.getHeader("X-Ultrapeer");
        if (!this.isConnectionAccepted(upHeader)) {
            return new HandshakeStatus(503, "I am busy.", this.createRejectOutgoingHeaders());
        }
        HTTPHeaderGroup myHeaders = new HTTPHeaderGroup(HTTPHeaderGroup.COMMON_HANDSHAKE_GROUP);
        HTTPHeader upNeededHeader = headers.getHeader("X-Ultrapeer-Needed");
        if (upNeededHeader != null && !upNeededHeader.booleanValue() && !this.isBearshare(headers) && this.servent.allowDowngradeToLeaf()) {
            myHeaders = new HTTPHeaderGroup(false);
            myHeaders.addHeader(new HTTPHeader("X-Ultrapeer", "false"));
        }
        if (hostResponse.isDeflateAccepted()) {
            myHeaders.addHeader(new HTTPHeader("Content-Encoding", "deflate"));
        }
        return new HandshakeStatus(200, "OK", myHeaders);
    }

    private boolean isConnectionAccepted(HTTPHeader upHeader) {
        if (upHeader == null) {
            return false;
        }
        NetworkHostsContainer netHostContainer = this.servent.getHostService().getNetworkHostsContainer();
        return Boolean.valueOf(upHeader.getValue()) != false ? netHostContainer.hasUltrapeerSlotsAvailable() || netHostContainer.hasLeafSlotForUltrapeerAvailable() : netHostContainer.hasLeafSlotsAvailable();
    }

    private boolean isBearshare(HTTPHeaderGroup headers) {
        HTTPHeader header = headers.getHeader("User-Agent");
        return header != null && header.getValue().startsWith("BearShare");
    }
}

