/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.io.IOException;
import java.net.SocketException;
import phex.common.address.DestAddress;
import phex.common.bandwidth.BandwidthController;
import phex.common.log.NLogger;
import phex.connection.ConnectionFailedException;
import phex.download.swarming.SWDownloadCandidate;
import phex.net.connection.Connection;
import phex.net.connection.SocketFactory;
import phex.net.repres.SocketFacade;

public class DownloadConnection
extends Connection {
    private SWDownloadCandidate candidate;

    public DownloadConnection(SWDownloadCandidate candidate) {
        this.candidate = candidate;
    }

    public DownloadConnection(SWDownloadCandidate candidate, SocketFacade socket) {
        this(candidate);
        this.socket = socket;
        BandwidthController bwCont = candidate.getDownloadFile().getBandwidthController();
        this.setBandwidthController(bwCont);
        candidate.addToCandidateLog("Connected successfully to " + candidate.getHostAddress() + ".");
        candidate.setLastConnectionTime(System.currentTimeMillis());
        NLogger.debug(DownloadConnection.class, "Download Engine @" + Integer.toHexString(this.hashCode()) + " connected successfully to " + candidate.getHostAddress() + ".");
    }

    public void connect(int timeout) throws IOException {
        assert (this.socket == null);
        DestAddress address = this.candidate.getHostAddress();
        try {
            this.candidate.addToCandidateLog("Wait for connect slot " + address.getHostName() + ":" + address.getPort());
            NLogger.debug(DownloadConnection.class, "Wait for connect slot " + address.getHostName() + ":" + address.getPort());
            Runnable acquireCallback = new Runnable(){

                public void run() {
                    DestAddress candAddress = DownloadConnection.this.candidate.getHostAddress();
                    DownloadConnection.this.candidate.addToCandidateLog("Connecting to " + candAddress.getHostName() + ":" + candAddress.getPort());
                    NLogger.debug(DownloadConnection.class, "Connecting to " + candAddress.getHostName() + ":" + candAddress.getPort());
                    DownloadConnection.this.candidate.setStatus(SWDownloadCandidate.CandidateStatus.CONNECTING);
                }
            };
            this.socket = SocketFactory.connect(address, timeout, acquireCallback);
        }
        catch (SocketException exp) {
            throw new ConnectionFailedException(exp.getMessage());
        }
        BandwidthController bwCont = this.candidate.getDownloadFile().getBandwidthController();
        this.setBandwidthController(bwCont);
        this.candidate.addToCandidateLog("Connected successfully to " + this.candidate.getHostAddress() + ".");
        this.candidate.setLastConnectionTime(System.currentTimeMillis());
        NLogger.debug(DownloadConnection.class, "Download Engine @" + Integer.toHexString(this.hashCode()) + " connected successfully to " + this.candidate.getHostAddress() + ".");
    }
}

