/*
 * Decompiled with CFR 0.152.
 */
package phex.download;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import phex.download.DownloadScope;
import phex.download.DownloadScopeList;
import phex.download.RatedDownloadScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RatedDownloadScopeList {
    private static DownloadScopeComparator DOWNLOAD_SCOPE_COMPARATOR = new DownloadScopeComparator();
    private static RatedDownloadScopeComparator RATED_DOWNLOAD_SCOPE_COMPARATOR = new RatedDownloadScopeComparator();
    private int modificationCount = 0;
    private List<RatedDownloadScope> scopeList = new ArrayList<RatedDownloadScope>();
    private List<RatedDownloadScope> ratedScopeList = new ArrayList<RatedDownloadScope>();
    private long aggregatedLengthCache = 0L;
    private int aggregatedLengthModCount = 0;

    public RatedDownloadScopeList() {
    }

    public RatedDownloadScopeList(DownloadScopeList downloadScopes) {
        this();
        for (DownloadScope scope : downloadScopes) {
            this.add(new RatedDownloadScope(scope.getStart(), scope.getEnd()));
        }
    }

    public void addAll(RatedDownloadScopeList ratedScopes) {
        Iterator<RatedDownloadScope> iterator = ratedScopes.getScopeIterator();
        while (iterator.hasNext()) {
            RatedDownloadScope scope = iterator.next();
            this.add(scope);
        }
    }

    public void addAll(DownloadScopeList downloadScopes) {
        for (DownloadScope scope : downloadScopes) {
            this.add(new RatedDownloadScope(scope.getStart(), scope.getEnd()));
        }
    }

    public void add(RatedDownloadScope newScope) {
        RatedDownloadScope scope1;
        RatedDownloadScope neighborBefore = null;
        RatedDownloadScope neighborAfter = null;
        Iterator<RatedDownloadScope> iterator = this.getScopeIterator();
        while (iterator.hasNext()) {
            RatedDownloadScope scope = iterator.next();
            if (newScope.contains(scope)) {
                iterator.remove();
                RatedDownloadScope scope12 = new RatedDownloadScope(scope.getStart(), scope.getEnd(), scope.getCountRating() + newScope.getCountRating(), scope.getSpeedRating() + newScope.getSpeedRating());
                this.addInternal(scope12);
                if (newScope.getStart() < scope.getStart()) {
                    RatedDownloadScope scope2 = new RatedDownloadScope(newScope.getStart(), scope.getStart() - 1L, newScope.getCountRating(), newScope.getSpeedRating());
                    this.add(scope2);
                }
                if (scope.getEnd() < newScope.getEnd()) {
                    RatedDownloadScope scope3 = new RatedDownloadScope(scope.getEnd() + 1L, newScope.getEnd(), newScope.getCountRating(), newScope.getSpeedRating());
                    this.add(scope3);
                }
                return;
            }
            if (scope.contains(newScope)) {
                if (newScope.getCountRating() == 0 && newScope.getSpeedRating() == 0L) {
                    return;
                }
                iterator.remove();
                if (scope.getStart() != newScope.getStart()) {
                    RatedDownloadScope scope13 = new RatedDownloadScope(scope.getStart(), newScope.getStart() - 1L, scope.getCountRating(), scope.getSpeedRating());
                    this.addInternal(scope13);
                }
                RatedDownloadScope scope2 = new RatedDownloadScope(newScope.getStart(), newScope.getEnd(), scope.getCountRating() + newScope.getCountRating(), scope.getSpeedRating() + newScope.getSpeedRating());
                this.addInternal(scope2);
                if (scope.getEnd() != newScope.getEnd()) {
                    RatedDownloadScope scope3 = new RatedDownloadScope(newScope.getEnd() + 1L, scope.getEnd(), scope.getCountRating(), scope.getSpeedRating());
                    this.addInternal(scope3);
                }
                return;
            }
            if (newScope.isNeighborBefore(scope) && newScope.isOverlapping(scope)) {
                neighborBefore = scope;
            }
            if (newScope.isNeighborAfter(scope) && scope.isOverlapping(newScope)) {
                neighborAfter = scope;
            }
            if (neighborAfter == null && scope.getStart() <= newScope.getEnd()) continue;
            break;
        }
        if (neighborBefore == null && neighborAfter == null) {
            this.addInternal(newScope);
        } else if (neighborAfter != null && neighborBefore != null && newScope.getCountRating() == 0 && newScope.getSpeedRating() == 0L && neighborAfter.getCountRating() == neighborBefore.getCountRating() && neighborAfter.getSpeedRating() == neighborBefore.getSpeedRating()) {
            this.removeInternal(neighborBefore);
            this.removeInternal(neighborAfter);
            scope1 = new RatedDownloadScope(neighborBefore.getStart(), neighborAfter.getEnd(), neighborAfter.getCountRating(), neighborAfter.getSpeedRating());
            this.addInternal(scope1);
        } else {
            RatedDownloadScope scope2;
            if (neighborAfter != null) {
                if (newScope.getCountRating() == 0 && newScope.getSpeedRating() == 0L) {
                    this.removeInternal(neighborAfter);
                    scope1 = new RatedDownloadScope(newScope.getStart(), neighborAfter.getEnd(), neighborAfter.getCountRating(), neighborAfter.getSpeedRating());
                    this.add(scope1);
                } else {
                    this.removeInternal(neighborAfter);
                    scope1 = new RatedDownloadScope(neighborAfter.getStart(), newScope.getEnd(), neighborAfter.getCountRating() + newScope.getCountRating(), neighborAfter.getSpeedRating() + newScope.getSpeedRating());
                    this.add(scope1);
                    scope2 = new RatedDownloadScope(newScope.getEnd() + 1L, neighborAfter.getEnd(), neighborAfter.getCountRating(), neighborAfter.getSpeedRating());
                    this.add(scope2);
                }
            }
            if (neighborBefore != null) {
                if (newScope.getCountRating() == 0 && newScope.getSpeedRating() == 0L) {
                    this.removeInternal(neighborBefore);
                    scope1 = new RatedDownloadScope(neighborBefore.getStart(), newScope.getEnd(), neighborBefore.getCountRating(), neighborBefore.getSpeedRating());
                    this.add(scope1);
                } else {
                    this.removeInternal(neighborBefore);
                    scope1 = new RatedDownloadScope(neighborBefore.getStart(), newScope.getStart() - 1L, neighborBefore.getCountRating(), neighborBefore.getSpeedRating());
                    this.add(scope1);
                    scope2 = new RatedDownloadScope(newScope.getStart(), neighborBefore.getEnd(), neighborBefore.getCountRating() + newScope.getCountRating(), neighborBefore.getSpeedRating() + newScope.getSpeedRating());
                    this.add(scope2);
                }
            }
        }
    }

    public void removeAll(RatedDownloadScopeList ratedScops) {
        Iterator<RatedDownloadScope> iterator = ratedScops.getScopeIterator();
        while (iterator.hasNext()) {
            RatedDownloadScope scope = iterator.next();
            this.remove(scope);
        }
    }

    public void remove(RatedDownloadScope removeScope) {
        RatedDownloadScope beforeScope = null;
        RatedDownloadScope afterScope = null;
        Iterator<RatedDownloadScope> iterator = this.scopeList.iterator();
        while (iterator.hasNext()) {
            RatedDownloadScope scope = iterator.next();
            if (scope.isOverlapping(removeScope)) {
                iterator.remove();
                if (removeScope.getEnd() >= scope.getEnd()) {
                    if (removeScope.getStart() <= scope.getStart()) continue;
                    beforeScope = new RatedDownloadScope(scope.getStart(), removeScope.getStart() - 1L, scope.getCountRating(), scope.getSpeedRating());
                    continue;
                }
                if (scope.getStart() >= removeScope.getStart()) {
                    afterScope = new RatedDownloadScope(removeScope.getEnd() + 1L, scope.getEnd(), scope.getCountRating(), scope.getSpeedRating());
                    break;
                }
                beforeScope = new RatedDownloadScope(scope.getStart(), removeScope.getStart() - 1L, scope.getCountRating(), scope.getSpeedRating());
                afterScope = new RatedDownloadScope(removeScope.getEnd() + 1L, scope.getEnd(), scope.getCountRating(), scope.getSpeedRating());
                break;
            }
            if (scope.getStart() < removeScope.getEnd()) continue;
            break;
        }
        if (beforeScope != null) {
            this.add(beforeScope);
        }
        if (afterScope != null) {
            this.add(afterScope);
        }
    }

    public void retainAll(DownloadScopeList retainList) {
        ListIterator<RatedDownloadScope> thisIterator = this.scopeList.listIterator();
        while (thisIterator.hasNext()) {
            boolean removeThis = true;
            RatedDownloadScope thisScope = thisIterator.next();
            for (DownloadScope retainScope : retainList) {
                if (thisScope.isOverlapping(retainScope)) {
                    thisIterator.remove();
                    long retainStart = Math.max(retainScope.getStart(), thisScope.getStart());
                    long retainEnd = Math.min(retainScope.getEnd(), thisScope.getEnd());
                    thisIterator.add(new RatedDownloadScope(retainStart, retainEnd, thisScope.getCountRating(), thisScope.getSpeedRating()));
                    removeThis = false;
                    break;
                }
                if (retainScope.getStart() < thisScope.getEnd()) continue;
                break;
            }
            if (!removeThis) continue;
            thisIterator.remove();
        }
    }

    public void rateDownloadScopeList(DownloadScopeList downloadScopeList, long speedRateValue) {
        for (DownloadScope scope : downloadScopeList) {
            this.rateDownloadScope(scope, speedRateValue);
        }
    }

    public void compressByRatings() {
        ListIterator<RatedDownloadScope> iterator = this.scopeList.listIterator();
        if (!iterator.hasNext()) {
            return;
        }
        RatedDownloadScope prev = iterator.next();
        while (iterator.hasNext()) {
            RatedDownloadScope current = iterator.next();
            if (current.getStart() == prev.getEnd() + 1L && this.hasCloseToleranze(prev, current, 5.0)) {
                iterator.remove();
                iterator.previous();
                iterator.remove();
                int minCount = (int)Math.round((double)(prev.getLength() * (long)prev.getCountRating() + current.getLength() * (long)current.getCountRating()) / (double)(prev.getLength() + current.getLength()));
                long minSpeed = prev.getSpeedRating() == 0L || current.getSpeedRating() == 0L ? Math.max(prev.getSpeedRating(), current.getSpeedRating()) : Math.min(prev.getSpeedRating(), current.getSpeedRating());
                RatedDownloadScope scope1 = new RatedDownloadScope(prev.getStart(), current.getEnd(), minCount, minSpeed);
                iterator.add(scope1);
                current = scope1;
            }
            prev = current;
        }
    }

    private boolean hasCloseToleranze(RatedDownloadScope scope1, RatedDownloadScope scope2, double tolerance) {
        double minCount;
        double maxCount = Math.max(scope1.getCountRating(), scope2.getCountRating());
        double threshold = maxCount - maxCount / 100.0 * tolerance;
        return threshold < (minCount = (double)Math.min(scope1.getCountRating(), scope2.getCountRating()));
    }

    private void rateDownloadScope(DownloadScope rateScope, long speedRateValue) {
        ArrayList<RatedDownloadScope> scopesToAdd = new ArrayList<RatedDownloadScope>();
        for (RatedDownloadScope scope : this.scopeList) {
            if (scope.isOverlapping(rateScope)) {
                int overlapStart = (int)Math.max(scope.getStart(), rateScope.getStart());
                int overlapEnd = (int)Math.min(scope.getEnd(), rateScope.getEnd());
                RatedDownloadScope overlapScope = new RatedDownloadScope(overlapStart, overlapEnd, 1, speedRateValue);
                scopesToAdd.add(overlapScope);
            }
            if (scope.getStart() <= rateScope.getEnd()) continue;
            break;
        }
        for (RatedDownloadScope scope : scopesToAdd) {
            this.add(scope);
        }
    }

    public void prepareRating() {
        this.compressByRatings();
        this.ratedScopeList.clear();
        this.ratedScopeList.addAll(this.scopeList);
        Collections.sort(this.ratedScopeList, RATED_DOWNLOAD_SCOPE_COMPARATOR);
        this.dumpRatings();
    }

    public RatedDownloadScope getBestRated() {
        if (this.ratedScopeList.size() > 0) {
            return this.ratedScopeList.get(0);
        }
        return null;
    }

    public RatedDownloadScope getWorstRated() {
        if (this.ratedScopeList.size() > 0) {
            return this.ratedScopeList.get(this.ratedScopeList.size() - 1);
        }
        return null;
    }

    public boolean isRatingFruitful() {
        RatedDownloadScope best = this.getBestRated();
        RatedDownloadScope worst = this.getWorstRated();
        if (best == null || worst == null) {
            return false;
        }
        return !this.hasCloseToleranze(best, worst, 15.0);
    }

    public long getAggregatedLength() {
        if (this.modificationCount == this.aggregatedLengthModCount) {
            return this.aggregatedLengthCache;
        }
        long length = 0L;
        for (DownloadScope downloadScope : this.scopeList) {
            length += downloadScope.getLength();
        }
        this.aggregatedLengthCache = length;
        this.aggregatedLengthModCount = this.modificationCount;
        return length;
    }

    public Iterator<RatedDownloadScope> getScopeIterator() {
        return this.scopeList.listIterator();
    }

    public int size() {
        return this.scopeList.size();
    }

    public void clear() {
        this.scopeList.clear();
        this.ratedScopeList.clear();
        this.aggregatedLengthCache = 0L;
        this.modificationCount = 0;
        this.aggregatedLengthModCount = 0;
    }

    protected void addInternal(RatedDownloadScope scope) {
        int index = Collections.binarySearch(this.scopeList, scope, DOWNLOAD_SCOPE_COMPARATOR);
        assert (index < 0);
        this.scopeList.add(-(index + 1), scope);
        ++this.modificationCount;
    }

    protected void removeInternal(RatedDownloadScope scope) {
        int index = Collections.binarySearch(this.scopeList, scope, DOWNLOAD_SCOPE_COMPARATOR);
        assert (index >= 0);
        this.scopeList.remove(index);
        ++this.modificationCount;
    }

    private void dumpRatings() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RatedDownloadScopeComparator
    implements Comparator<RatedDownloadScope> {
        private RatedDownloadScopeComparator() {
        }

        @Override
        public int compare(RatedDownloadScope scope1, RatedDownloadScope scope2) {
            if (scope1 == scope2 || scope1.equals(scope2)) {
                return 0;
            }
            if (scope1.getCountRating() > scope2.getCountRating()) {
                return 1;
            }
            if (scope1.getCountRating() < scope2.getCountRating()) {
                return -1;
            }
            if (scope1.getSpeedRating() > scope2.getSpeedRating()) {
                return 1;
            }
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DownloadScopeComparator
    implements Comparator<DownloadScope> {
        private DownloadScopeComparator() {
        }

        @Override
        public int compare(DownloadScope scope1, DownloadScope scope2) {
            if (scope1 == scope2 || scope1.equals(scope2)) {
                return 0;
            }
            if (scope1.getStart() > scope2.getStart()) {
                return 1;
            }
            return -1;
        }
    }
}

