/*
 * Decompiled with CFR 0.152.
 */
package phex.event;

import java.lang.reflect.Method;
import java.util.regex.Pattern;
import org.bushe.swing.event.EventService;
import org.bushe.swing.event.EventTopicSubscriber;
import org.bushe.swing.event.annotation.BaseProxySubscriber;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.bushe.swing.event.annotation.EventTopicPatternSubscriber;
import org.bushe.swing.event.annotation.ProxyTopicPatternSubscriber;
import org.bushe.swing.event.annotation.ProxyTopicSubscriber;
import org.bushe.swing.event.annotation.UseTheClassOfTheAnnotatedMethodsParameter;

public class EventAnnotationProcessor {
    private EventService subscribeToService;

    public EventAnnotationProcessor(EventService subscribeToService) {
        this.subscribeToService = subscribeToService;
    }

    public void process(Object obj) {
        if (obj == null) {
            return;
        }
        Class<?> cl = obj.getClass();
        Method[] methods = cl.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            EventTopicPatternSubscriber topicPatternAnnotation;
            org.bushe.swing.event.annotation.EventTopicSubscriber topicAnnotation;
            Method method = methods[i];
            EventSubscriber classAnnotation = method.getAnnotation(EventSubscriber.class);
            if (classAnnotation != null) {
                this.process(classAnnotation, obj, method);
            }
            if ((topicAnnotation = method.getAnnotation(org.bushe.swing.event.annotation.EventTopicSubscriber.class)) != null) {
                this.process(topicAnnotation, obj, method);
            }
            if ((topicPatternAnnotation = method.getAnnotation(EventTopicPatternSubscriber.class)) == null) continue;
            this.process(topicPatternAnnotation, obj, method);
        }
    }

    private void process(EventTopicPatternSubscriber topicPatternAnnotation, Object obj, Method method) {
        String topicPattern = topicPatternAnnotation.topicPattern();
        if (topicPattern == null) {
            throw new IllegalArgumentException("Topic pattern cannot be null for EventTopicPatternSubscriber annotation");
        }
        Pattern pattern = Pattern.compile(topicPattern);
        ProxyTopicPatternSubscriber subscriber = new ProxyTopicPatternSubscriber(obj, method, topicPatternAnnotation.referenceStrength(), this.subscribeToService, topicPattern, pattern);
        this.subscribeToService.subscribeStrongly(pattern, (EventTopicSubscriber)subscriber);
    }

    private void process(org.bushe.swing.event.annotation.EventTopicSubscriber topicAnnotation, Object obj, Method method) {
        String topic = topicAnnotation.topic();
        if (topic == null) {
            throw new IllegalArgumentException("Topic cannot be null for EventTopicSubscriber annotation");
        }
        ProxyTopicSubscriber subscriber = new ProxyTopicSubscriber(obj, method, topicAnnotation.referenceStrength(), this.subscribeToService, topic);
        this.subscribeToService.subscribeStrongly(topic, (EventTopicSubscriber)subscriber);
    }

    private void process(EventSubscriber annotation, Object obj, Method method) {
        Class<?> eventClass = annotation.eventClass();
        if (eventClass == null) {
            throw new IllegalArgumentException("Event class cannot be null for EventSubscriber annotation");
        }
        if (UseTheClassOfTheAnnotatedMethodsParameter.class.equals((Object)eventClass)) {
            Class<?>[] params = method.getParameterTypes();
            if (params.length < 1) {
                throw new RuntimeException("Expected annotated method to have one parameter.");
            }
            eventClass = params[0];
        }
        BaseProxySubscriber subscriber = new BaseProxySubscriber(obj, method, annotation.referenceStrength(), this.subscribeToService, eventClass);
        if (annotation.exact()) {
            this.subscribeToService.subscribeExactlyStrongly(eventClass, subscriber);
        } else {
            this.subscribeToService.subscribeStrongly(eventClass, subscriber);
        }
    }
}

