/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.actions;

import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.event.ChangeEvent;
import phex.gui.actions.FWAction;
import phex.gui.common.GUIRegistry;
import phex.servent.OnlineStatus;
import phex.servent.Servent;
import phex.utils.Localizer;

public class ConnectNetworkAction
extends FWAction {
    public ConnectNetworkAction() {
        super(Localizer.getString("Connect"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Network.Connect"), Localizer.getString("TTTConnect"), Integer.valueOf(Localizer.getChar("ConnectMnemonic")), KeyStroke.getKeyStroke(Localizer.getString("ConnectAccelerator")));
        Servent servent = GUIRegistry.getInstance().getServent();
        this.setEnabled(servent.getOnlineStatus() == OnlineStatus.OFFLINE);
        servent.getEventService().processAnnotations(this);
    }

    public void actionPerformed(ActionEvent e) {
        Servent servent = GUIRegistry.getInstance().getServent();
        servent.setOnlineStatus(OnlineStatus.ONLINE);
    }

    public void refreshActionState() {
    }

    @EventTopicSubscriber(topic="phex:servent/onlineStatus")
    public void onOnlineStatusEvent(String topic, ChangeEvent event) {
        OnlineStatus oldStatus = (OnlineStatus)((Object)event.getOldValue());
        OnlineStatus newStatus = (OnlineStatus)((Object)event.getNewValue());
        if (oldStatus == OnlineStatus.OFFLINE && newStatus != OnlineStatus.OFFLINE) {
            this.setEnabled(false);
        } else if (newStatus == OnlineStatus.OFFLINE && oldStatus != OnlineStatus.OFFLINE) {
            this.setEnabled(true);
        }
    }
}

