/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.actions;

import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.event.ChangeEvent;
import phex.gui.actions.FWAction;
import phex.gui.common.GUIRegistry;
import phex.servent.OnlineStatus;
import phex.servent.Servent;
import phex.utils.Localizer;

public class DisconnectNetworkAction
extends FWAction {
    public DisconnectNetworkAction() {
        super(Localizer.getString("Disconnect"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Network.Disconnect"), Localizer.getString("TTTDisconnect"), Integer.valueOf(Localizer.getChar("DisconnectMnemonic")), KeyStroke.getKeyStroke(Localizer.getString("DisconnectAccelerator")));
        Servent servent = GUIRegistry.getInstance().getServent();
        this.setEnabled(servent.getOnlineStatus() == OnlineStatus.ONLINE);
        servent.getEventService().processAnnotations(this);
    }

    public void actionPerformed(ActionEvent e) {
        Servent servent = GUIRegistry.getInstance().getServent();
        servent.setOnlineStatus(OnlineStatus.OFFLINE);
    }

    public void refreshActionState() {
    }

    @EventTopicSubscriber(topic="phex:servent/onlineStatus")
    public void onOnlineStatusEvent(String topic, ChangeEvent event) {
        OnlineStatus oldStatus = (OnlineStatus)((Object)event.getOldValue());
        OnlineStatus newStatus = (OnlineStatus)((Object)event.getNewValue());
        if (oldStatus == OnlineStatus.OFFLINE && newStatus != OnlineStatus.OFFLINE) {
            this.setEnabled(true);
        } else if (newStatus == OnlineStatus.OFFLINE && oldStatus != OnlineStatus.OFFLINE) {
            this.setEnabled(false);
        }
    }
}

