/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import phex.gui.common.GUIRegistry;
import phex.gui.common.PhexColors;

public class DialogBanner
extends JPanel {
    private String headerText;
    private String subHeaderText;
    private Icon image;
    private JLabel titleLabel;
    private static Rectangle viewRect = new Rectangle();

    public DialogBanner(String aHeaderText, String aSubHeaderText) {
        this.headerText = aHeaderText;
        this.subHeaderText = aSubHeaderText;
        this.image = GUIRegistry.getInstance().getPlafIconPack().getIcon("DialogBanner.DefaultImage");
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("4dlu, 2dlu, d:grow", "3dlu, d, 3dlu, d, 3dlu");
        PanelBuilder builder = new PanelBuilder(layout, (JPanel)this);
        this.setBackground(Color.WHITE);
        Font font = UIManager.getFont("TitledBorder.font");
        font = font.deriveFont(1, font.getSize() + 2);
        this.titleLabel = new JLabel(this.headerText);
        this.titleLabel.setFont(font);
        builder.add((Component)this.titleLabel, cc.xywh(2, 2, 2, 1));
        font = UIManager.getFont("Label.font");
        font = font.deriveFont(0, font.getSize() - 1);
        JLabel subLabel = new JLabel(this.subHeaderText);
        subLabel.setFont(font);
        builder.add((Component)subLabel, cc.xy(3, 4));
    }

    public void setHeaderText(String headerText) {
        this.titleLabel.setText(headerText);
    }

    public void setImageIcon(String imageKey) {
        this.image = imageKey != null ? GUIRegistry.getInstance().getPlafIconPack().getIcon(imageKey) : null;
    }

    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        Insets i = this.getInsets();
        DialogBanner.viewRect.x = i.left;
        DialogBanner.viewRect.y = i.top;
        DialogBanner.viewRect.width = this.getWidth() - (i.right + DialogBanner.viewRect.x);
        DialogBanner.viewRect.height = this.getHeight() - (i.bottom + DialogBanner.viewRect.y);
        Graphics2D g2 = (Graphics2D)g;
        GradientPaint gradient = new GradientPaint(0.0f, 0.0f, PhexColors.getBoxHeaderGradientTo(), (int)((float)this.getWidth() / 2.0f), 0.0f, this.getBackground());
        g2.setPaint(gradient);
        g2.fillRect(DialogBanner.viewRect.x, DialogBanner.viewRect.y, DialogBanner.viewRect.width, DialogBanner.viewRect.height);
        if (this.image != null) {
            int x = Math.max(0, this.getWidth() - 7 - this.image.getIconWidth());
            int y = 7;
            this.image.paintIcon(this, g2, x, y);
        }
    }

    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        int height = 0;
        int width = 0;
        if (this.image != null) {
            height = this.image.getIconHeight() + 14;
            width = this.image.getIconWidth() + 14;
        }
        dim.height = Math.max(dim.height, height);
        dim.width += width;
        return dim;
    }

    public Dimension getMaximumSize() {
        Dimension maxDim = super.getMaximumSize();
        Dimension prefDim = this.getPreferredSize();
        maxDim.height = prefDim.height;
        return maxDim;
    }

    public static void main(String[] args) {
        PhexColors.updateColors();
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(400, 300);
        frame.getContentPane().setLayout(new BorderLayout());
        DialogBanner banner = new DialogBanner("New Download", "Add a new download from Magnet URI or URL");
        frame.getContentPane().add((Component)banner, "North");
        frame.setVisible(true);
    }
}

