/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.util.Arrays;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageFilterUtils {
    private static Logger logger = LoggerFactory.getLogger(ImageFilterUtils.class);

    public static Icon createGrayIcon(Icon icon) {
        try {
            return new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage()));
        }
        catch (ClassCastException exp) {
            Object[] interfaces = icon.getClass().getInterfaces();
            Class<?> superclass = icon.getClass().getSuperclass();
            logger.error(exp.toString(), (Throwable)exp);
            logger.error("CCE from {}, Interfaces: {}, Super: {}", new Object[]{icon.getClass(), Arrays.toString(interfaces), superclass});
            return icon;
        }
    }

    public static Icon createGrayIcon(Icon icon, boolean brighter, int percent) {
        GrayFilter filter = new GrayFilter(brighter, percent);
        FilteredImageSource prod = new FilteredImageSource(((ImageIcon)icon).getImage().getSource(), filter);
        Image grayImage = Toolkit.getDefaultToolkit().createImage(prod);
        return new ImageIcon(grayImage);
    }
}

