/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common.progressbar;

import java.awt.Color;
import java.util.NoSuchElementException;
import phex.download.DownloadScopeList;
import phex.download.swarming.SWDownloadFile;
import phex.gui.common.PhexColors;
import phex.gui.common.progressbar.MultiScopeProvider;

public class DownloadFileScopeProvider
implements MultiScopeProvider {
    private SWDownloadFile file;

    public DownloadFileScopeProvider(SWDownloadFile file) {
        this.file = file;
    }

    public DownloadScopeList getScopeAt(int idx) {
        switch (idx) {
            case 0: {
                return this.file.getMemoryFile().getFinishedScopeList();
            }
            case 1: {
                return this.file.getMemoryFile().getUnverifiedScopeList();
            }
            case 2: {
                return this.file.getMemoryFile().getToBeVerifiedScopeList();
            }
            case 3: {
                return this.file.getMemoryFile().getBlockedScopeList();
            }
        }
        throw new NoSuchElementException("Index: " + idx);
    }

    public Color getScopeColor(int idx) {
        switch (idx) {
            case 0: {
                return PhexColors.getFinishedScopeProgressBarForeground();
            }
            case 1: {
                return PhexColors.getUnverifiedScopeProgressBarForeground();
            }
            case 2: {
                return PhexColors.getUnverifiedScopeProgressBarForeground();
            }
            case 3: {
                return PhexColors.getBlockedScopeProgressBarForeground();
            }
        }
        throw new NoSuchElementException("Index: " + idx);
    }

    public int getScopeCount() {
        return 4;
    }

    public long getFileSize() {
        return this.file.getTotalDataSize();
    }
}

