/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.common.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.EventListenerList;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import phex.gui.common.table.FWTableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FWTableColumnModel
extends DefaultTableColumnModel {
    private static final String IGNORE_EVENT = "TableColumnModelExt.ignoreEvent";
    private List<TableColumn> initialColumns = new ArrayList<TableColumn>();
    private List<TableColumn> currentColumns = new ArrayList<TableColumn>();
    private Set<FWTableColumn> invisibleColumns = new HashSet<FWTableColumn>();
    private Map<FWTableColumn, Integer> oldIndexes = new HashMap<FWTableColumn, Integer>();
    private VisibilityListener visibilityListener = new VisibilityListener();

    public List<TableColumn> getColumns(boolean includeHidden) {
        if (includeHidden) {
            return new ArrayList<TableColumn>(this.initialColumns);
        }
        return Collections.list(this.getColumns());
    }

    public int getColumnCount(boolean includeHidden) {
        if (includeHidden) {
            return this.initialColumns.size();
        }
        return this.getColumnCount();
    }

    public FWTableColumn getFWColumn(Object identifier) {
        for (TableColumn column : this.initialColumns) {
            if (!(column instanceof FWTableColumn) || !identifier.equals(column.getIdentifier())) continue;
            return (FWTableColumn)column;
        }
        return null;
    }

    public FWTableColumn getFWColumn(int columnIndex) {
        TableColumn column = this.getColumn(columnIndex);
        if (column instanceof FWTableColumn) {
            return (FWTableColumn)column;
        }
        return null;
    }

    public boolean isRemovedToInvisibleEvent(int oldIndex) {
        return this.oldIndexes.containsValue(oldIndex);
    }

    @Override
    public void removeColumn(TableColumn column) {
        if (column instanceof FWTableColumn) {
            ((FWTableColumn)column).removePropertyChangeListener(this.visibilityListener);
        }
        this.invisibleColumns.remove(column);
        this.currentColumns.remove(column);
        this.initialColumns.remove(column);
        this.oldIndexes.remove(column);
        super.removeColumn(column);
    }

    @Override
    public void addColumn(TableColumn aColumn) {
        boolean oldVisible = true;
        if (aColumn instanceof FWTableColumn) {
            FWTableColumn xColumn = (FWTableColumn)aColumn;
            oldVisible = xColumn.isVisible();
            xColumn.setVisible(true);
            xColumn.addPropertyChangeListener(this.visibilityListener);
        }
        this.currentColumns.add(aColumn);
        this.initialColumns.add(aColumn);
        super.addColumn(aColumn);
        if (aColumn instanceof FWTableColumn) {
            ((FWTableColumn)aColumn).setVisible(oldVisible);
        }
    }

    @Override
    public void moveColumn(int columnIndex, int newIndex) {
        if (columnIndex != newIndex) {
            this.updateCurrentColumns(columnIndex, newIndex);
        }
        super.moveColumn(columnIndex, newIndex);
    }

    private void updateCurrentColumns(int oldIndex, int newIndex) {
        TableColumn movedColumn = (TableColumn)this.tableColumns.elementAt(oldIndex);
        int oldPosition = this.currentColumns.indexOf(movedColumn);
        TableColumn targetColumn = (TableColumn)this.tableColumns.elementAt(newIndex);
        int newPosition = this.currentColumns.indexOf(targetColumn);
        this.currentColumns.remove(oldPosition);
        this.currentColumns.add(newPosition, movedColumn);
    }

    protected void moveToInvisible(FWTableColumn col) {
        this.invisibleColumns.add(col);
        this.oldIndexes.put(col, this.tableColumns.indexOf(col));
        super.removeColumn(col);
    }

    protected void moveToVisible(FWTableColumn col) {
        this.invisibleColumns.remove(col);
        this.oldIndexes.remove(col);
        super.addColumn(col);
        Integer addIndex = this.currentColumns.indexOf(col);
        for (int i = 0; i < this.getColumnCount() - 1; ++i) {
            TableColumn tableCol = this.getColumn(i);
            int actualPosition = this.currentColumns.indexOf(tableCol);
            if (actualPosition <= addIndex) continue;
            super.moveColumn(this.getColumnCount() - 1, i);
            break;
        }
    }

    protected EventListenerList getEventListenerList() {
        return this.listenerList;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
    }

    private final class VisibilityListener
    implements PropertyChangeListener,
    Serializable {
        private VisibilityListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("visible")) {
                boolean oldValue = (Boolean)evt.getOldValue();
                boolean newValue = (Boolean)evt.getNewValue();
                FWTableColumn col = (FWTableColumn)evt.getSource();
                if (oldValue && !newValue) {
                    FWTableColumnModel.this.moveToInvisible(col);
                } else if (!oldValue && newValue) {
                    FWTableColumnModel.this.moveToVisible(col);
                }
            }
        }
    }
}

