/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import phex.gui.common.GUIUtils;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.prefs.core.DownloadPrefs;
import phex.utils.DirectoryOnlyFileFilter;
import phex.utils.FileUtils;
import phex.utils.Localizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoriesPane
extends OptionsSettingsPane {
    private static final String DIRECTORY_ERROR_KEY = "DirectoryErrorKey";
    private static final String DOWNLOAD_DIRECTORY_KEY = "DownloadDirectory";
    private static final String INCOMPLETE_DIRECTORY_KEY = "IncompleteDirectory";
    private static final String INCOMPLETE_DIR_SHARED = "IncompleteDirShared";
    private static final String NO_DIRECTORY_SHARED = "NoDirectoryShared";
    private static final String CANT_CREATE_DOWNLOAD_DIR = "CantCreateDownloadDir";
    private static final String CANT_CREATE_INCOMPLETE_DIR = "CantCreateIncompleteDir";
    private JTextField incompleteDirectoryTF;
    private JTextField downloadDirectoryTF;

    public DirectoriesPane() {
        super("Directories");
    }

    @Override
    protected void prepareComponent() {
        FormLayout layout = new FormLayout("10dlu, right:d, 2dlu, d:grow, 2dlu, d, 2dlu", "p, 3dlu, p, 3dlu, p, 9dlu, p, 3dlu, p, 3dlu, p, 15dlu:grow, 3dlu, p, 3dlu, p, 3dlu, p");
        layout.setRowGroups((int[][])new int[][]{{3, 5, 9, 11, 14, 16, 18}});
        PanelBuilder builder = new PanelBuilder(layout, (JPanel)this);
        CellConstraints cc = new CellConstraints();
        builder.addSeparator(Localizer.getString("DirSettings_DownloadFolders"), cc.xywh(1, 1, 7, 1));
        builder.addLabel(Localizer.getString("DirSettings_Incomplete") + ": ", cc.xy(2, 3));
        this.incompleteDirectoryTF = new JTextField(DownloadPrefs.IncompleteDirectory.get(), 30);
        builder.add((Component)this.incompleteDirectoryTF, cc.xy(4, 3));
        JButton button = new JButton(Localizer.getString("DirSettings_SetFolder"));
        button.addActionListener(new SetIncompleteDirectoryListener());
        builder.add((Component)button, cc.xy(6, 3));
        builder.addLabel(Localizer.getString("DirSettings_Completed") + ": ", cc.xy(2, 5));
        this.downloadDirectoryTF = new JTextField(DownloadPrefs.DestinationDirectory.get(), 30);
        builder.add((Component)this.downloadDirectoryTF, cc.xy(4, 5));
        button = new JButton(Localizer.getString("DirSettings_SetFolder"));
        button.addActionListener(new SetDownloadDirectoryListener());
        builder.add((Component)button, cc.xy(6, 5));
    }

    @Override
    public void checkInput(HashMap<String, Object> inputDic) {
        File downloadDir = null;
        String downloadDirPath = this.downloadDirectoryTF.getText();
        downloadDir = new File(downloadDirPath);
        String incompleteDirPath = this.incompleteDirectoryTF.getText();
        File incompleteDir = new File(incompleteDirPath);
        if (!downloadDir.exists() || !downloadDir.isDirectory()) {
            try {
                FileUtils.forceMkdir(downloadDir);
            }
            catch (IOException exp) {
                inputDic.put(DIRECTORY_ERROR_KEY, CANT_CREATE_DOWNLOAD_DIR);
                this.setInputValid(inputDic, false);
                return;
            }
        }
        if (!incompleteDir.exists() || !incompleteDir.isDirectory()) {
            try {
                FileUtils.forceMkdir(incompleteDir);
            }
            catch (IOException exp) {
                inputDic.put(DIRECTORY_ERROR_KEY, CANT_CREATE_INCOMPLETE_DIR);
                this.setInputValid(inputDic, false);
                return;
            }
        }
        inputDic.put(DOWNLOAD_DIRECTORY_KEY, downloadDir);
        inputDic.put(INCOMPLETE_DIRECTORY_KEY, incompleteDir);
        this.setInputValid(inputDic, true);
    }

    public void displayErrorMessage(HashMap inputDic) {
        Object error = inputDic.get(DIRECTORY_ERROR_KEY);
        if (error == null) {
            return;
        }
        if (error.equals(INCOMPLETE_DIR_SHARED)) {
            this.incompleteDirectoryTF.requestFocus();
            this.incompleteDirectoryTF.selectAll();
            GUIUtils.showErrorMessage(Localizer.getString(INCOMPLETE_DIR_SHARED), Localizer.getString("DirectoryError"));
        } else if (error.equals(NO_DIRECTORY_SHARED)) {
            GUIUtils.showErrorMessage(Localizer.getString(NO_DIRECTORY_SHARED), Localizer.getString("DirectoryError"));
        } else if (error.equals(CANT_CREATE_DOWNLOAD_DIR)) {
            this.downloadDirectoryTF.requestFocus();
            this.downloadDirectoryTF.selectAll();
            GUIUtils.showErrorMessage(Localizer.getFormatedString(CANT_CREATE_DOWNLOAD_DIR, this.downloadDirectoryTF.getText()), Localizer.getString("DirectoryError"));
        } else if (error.equals(CANT_CREATE_INCOMPLETE_DIR)) {
            this.incompleteDirectoryTF.requestFocus();
            this.incompleteDirectoryTF.selectAll();
            GUIUtils.showErrorMessage(Localizer.getFormatedString(CANT_CREATE_INCOMPLETE_DIR, this.incompleteDirectoryTF.getText()), Localizer.getString("DirectoryError"));
        }
    }

    public void saveAndApplyChanges(HashMap inputDic) {
        File downloadDir = (File)inputDic.get(DOWNLOAD_DIRECTORY_KEY);
        String downloadDirPath = downloadDir.getAbsolutePath();
        DownloadPrefs.DestinationDirectory.set(downloadDirPath);
        File incompleteDir = (File)inputDic.get(INCOMPLETE_DIRECTORY_KEY);
        String incompleteDirPath = incompleteDir.getAbsolutePath();
        DownloadPrefs.IncompleteDirectory.set(incompleteDirPath);
    }

    private class SetIncompleteDirectoryListener
    implements ActionListener {
        private SetIncompleteDirectoryListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            chooser.setSelectedFile(new File(DirectoriesPane.this.incompleteDirectoryTF.getText()));
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setFileFilter(new DirectoryOnlyFileFilter());
            chooser.setFileSelectionMode(1);
            chooser.setMultiSelectionEnabled(false);
            chooser.setDialogTitle(Localizer.getString("SelectIncompleteDirectory"));
            chooser.setApproveButtonText(Localizer.getString("Select"));
            chooser.setApproveButtonMnemonic(Localizer.getChar("SelectMnemonic"));
            int returnVal = chooser.showDialog(DirectoriesPane.this, null);
            if (returnVal == 0) {
                String directory = chooser.getSelectedFile().getAbsolutePath();
                DirectoriesPane.this.incompleteDirectoryTF.setText(directory);
            }
        }
    }

    private class SetDownloadDirectoryListener
    implements ActionListener {
        private SetDownloadDirectoryListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            chooser.setSelectedFile(new File(DirectoriesPane.this.downloadDirectoryTF.getText()));
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setFileFilter(new DirectoryOnlyFileFilter());
            chooser.setFileSelectionMode(1);
            chooser.setMultiSelectionEnabled(false);
            chooser.setDialogTitle(Localizer.getString("SelectDownloadDirectory"));
            chooser.setApproveButtonText(Localizer.getString("Select"));
            chooser.setApproveButtonMnemonic(Localizer.getChar("SelectMnemonic"));
            int returnVal = chooser.showDialog(DirectoriesPane.this, null);
            if (returnVal == 0) {
                String directory = chooser.getSelectedFile().getAbsolutePath();
                DirectoriesPane.this.downloadDirectoryTF.setText(directory);
            }
        }
    }
}

