/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import phex.gui.common.IntegerTextField;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.prefs.core.ConnectionPrefs;
import phex.prefs.core.DownloadPrefs;
import phex.prefs.core.SubscriptionPrefs;
import phex.utils.Localizer;

public class DownloadPane
extends OptionsSettingsPane {
    private static final String WORKER_PER_DOWNLOAD_KEY = "WorkerPerDownload";
    private static final String MAX_TOTAL_WORKER_KEY = "TotalWorker";
    private static final String PUSH_TIMEOUT_KEY = "PushTimeout";
    private static final String INITIAL_SEGMENT_SIZE_KEY = "InitialSegmentSize";
    private static final String SEGMENT_TRANSFER_TIME_KEY = "SegmentTransferTime";
    private IntegerTextField totalWorkersTF;
    private IntegerTextField workerPerDownloadTF;
    private IntegerTextField pushTimeoutTF;
    private IntegerTextField initialSegmentSizeTF;
    private IntegerTextField segmentTransferTimeTF;
    private JCheckBox readoutMagmaChkbx;
    private JCheckBox readoutMetalinkChkbx;
    private JCheckBox readoutRSSChkbx;
    private JCheckBox silentSubscriptionsChkbx;
    private JCheckBox removeCompletedDownloadsChkbx;
    private JCheckBox enableHitSnoopingChkbx;

    public DownloadPane() {
        super("Download");
    }

    protected void prepareComponent() {
        FormLayout layout = new FormLayout("10dlu, right:d, 2dlu, d, 2dlu:grow", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        layout.setRowGroups((int[][])new int[][]{{3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23}});
        this.setLayout((LayoutManager)layout);
        PanelBuilder builder = new PanelBuilder(layout, (JPanel)this);
        CellConstraints cc = new CellConstraints();
        builder.addSeparator(Localizer.getString("GeneralDownloadSettings"), cc.xywh(1, 1, 5, 1));
        JLabel label = builder.addLabel(Localizer.getString("DownloadSettings_TotalParallelDownloads") + ": ", cc.xy(2, 3));
        label.setToolTipText(Localizer.getString("DownloadSettings_TTTTotalParallelDownloads"));
        this.totalWorkersTF = new IntegerTextField(DownloadPrefs.MaxTotalDownloadWorker.get().toString(), 6, 2);
        this.totalWorkersTF.setToolTipText(Localizer.getString("DownloadSettings_TTTTotalParallelDownloads"));
        builder.add((Component)this.totalWorkersTF, cc.xy(4, 3));
        label = builder.addLabel(Localizer.getString("DownloadSettings_ParallelDownloadsPerFile") + ": ", cc.xy(2, 5));
        label.setToolTipText(Localizer.getString("DownloadSettings_TTTParallelDownloadsPerFile"));
        this.workerPerDownloadTF = new IntegerTextField(DownloadPrefs.MaxWorkerPerDownload.get().toString(), 6, 2);
        this.workerPerDownloadTF.setToolTipText(Localizer.getString("DownloadSettings_TTTParallelDownloadsPerFile"));
        builder.add((Component)this.workerPerDownloadTF, cc.xy(4, 5));
        label = builder.addLabel(Localizer.getString("DownloadSettings_InitialSegmentSizeKb") + ": ", cc.xy(2, 7));
        label.setToolTipText(Localizer.getString("DownloadSettings_TTTInitialSegmentSizeKb"));
        this.initialSegmentSizeTF = new IntegerTextField(String.valueOf(DownloadPrefs.SegmentInitialSize.get() / 1024), 6, 4);
        this.initialSegmentSizeTF.setToolTipText(Localizer.getString("DownloadSettings_TTTInitialSegmentSizeKb"));
        builder.add((Component)this.initialSegmentSizeTF, cc.xy(4, 7));
        label = builder.addLabel(Localizer.getString("DownloadSettings_SegmentTransferTimeSec") + ": ", cc.xy(2, 9));
        label.setToolTipText(Localizer.getString("DownloadSettings_TTTSegmentTransferTimeSec"));
        this.segmentTransferTimeTF = new IntegerTextField(DownloadPrefs.SegmentTransferTargetTime.get().toString(), 6, 3);
        this.segmentTransferTimeTF.setToolTipText(Localizer.getString("DownloadSettings_TTTSegmentTransferTimeSec"));
        builder.add((Component)this.segmentTransferTimeTF, cc.xy(4, 9));
        builder.addLabel(Localizer.getString(PUSH_TIMEOUT_KEY) + ": ", cc.xy(2, 11));
        this.pushTimeoutTF = new IntegerTextField(String.valueOf(DownloadPrefs.PushRequestTimeout.get() / 1000), 6, 3);
        builder.add((Component)this.pushTimeoutTF, cc.xy(4, 11));
        this.readoutMagmaChkbx = new JCheckBox(Localizer.getString("DownloadSettings_ReadoutDownloadedMagmas"), (boolean)DownloadPrefs.AutoReadoutMagmaFiles.get());
        this.readoutMagmaChkbx.setToolTipText(Localizer.getString("DownloadSettings_TTTReadoutDownloadedMagmas"));
        builder.add((Component)this.readoutMagmaChkbx, cc.xywh(2, 13, 4, 1));
        this.readoutMetalinkChkbx = new JCheckBox(Localizer.getString("DownloadSettings_ReadoutDownloadedMetalink"), (boolean)DownloadPrefs.AutoReadoutMetalinkFiles.get());
        this.readoutMetalinkChkbx.setToolTipText(Localizer.getString("DownloadSettings_TTTReadoutDownloadedMetalink"));
        builder.add((Component)this.readoutMetalinkChkbx, cc.xywh(2, 15, 4, 1));
        this.readoutRSSChkbx = new JCheckBox(Localizer.getString("DownloadSettings_ReadoutDownloadedRSS"), (boolean)DownloadPrefs.AutoReadoutRSSFiles.get());
        this.readoutRSSChkbx.setToolTipText(Localizer.getString("DownloadSettings_TTTReadoutDownloadedRSS"));
        builder.add((Component)this.readoutRSSChkbx, cc.xywh(2, 17, 4, 1));
        this.silentSubscriptionsChkbx = new JCheckBox(Localizer.getString("DownloadSettings_DownloadSubscriptionsSilently"), (boolean)SubscriptionPrefs.DownloadSilently.get());
        this.silentSubscriptionsChkbx.setToolTipText(Localizer.getString("DownloadSettings_TTTDownloadSubscriptionsSilently"));
        builder.add((Component)this.silentSubscriptionsChkbx, cc.xywh(2, 19, 4, 1));
        this.removeCompletedDownloadsChkbx = new JCheckBox(Localizer.getString("DownloadSettings_AutoRemoveCompletedDownloads"), (boolean)DownloadPrefs.AutoRemoveCompleted.get());
        this.removeCompletedDownloadsChkbx.setToolTipText(Localizer.getString("DownloadSettings_TTTAutoRemoveCompletedDownloads"));
        builder.add((Component)this.removeCompletedDownloadsChkbx, cc.xywh(2, 21, 4, 1));
        this.enableHitSnoopingChkbx = new JCheckBox(Localizer.getString("DownloadSettings_EnableHitSnooping"), (boolean)ConnectionPrefs.EnableQueryHitSnooping.get());
        this.enableHitSnoopingChkbx.setToolTipText(Localizer.getString("DownloadSettings_TTTEnableHitSnooping"));
        builder.add((Component)this.enableHitSnoopingChkbx, cc.xywh(2, 23, 4, 1));
        this.initConfigValues();
        this.refreshEnableState();
    }

    public void checkInput(HashMap inputDic) {
        try {
            String workerPerDownloadStr = this.workerPerDownloadTF.getText();
            Integer workerPerDownload = Integer.valueOf(workerPerDownloadStr);
            inputDic.put(WORKER_PER_DOWNLOAD_KEY, workerPerDownload);
        }
        catch (NumberFormatException exp) {
            inputDic.put("NumberFormatError", this.workerPerDownloadTF);
            this.setInputValid(inputDic, false);
            return;
        }
        try {
            String totalWorkersStr = this.totalWorkersTF.getText();
            Integer totalWorkers = Integer.valueOf(totalWorkersStr);
            inputDic.put(MAX_TOTAL_WORKER_KEY, totalWorkers);
        }
        catch (NumberFormatException exp) {
            inputDic.put("NumberFormatError", this.totalWorkersTF);
            this.setInputValid(inputDic, false);
            return;
        }
        try {
            String initialSegmentSizeStr = this.initialSegmentSizeTF.getText();
            Integer initialSegmentSize = Integer.valueOf(initialSegmentSizeStr);
            inputDic.put(INITIAL_SEGMENT_SIZE_KEY, initialSegmentSize);
        }
        catch (NumberFormatException exp) {
            inputDic.put("NumberFormatError", this.initialSegmentSizeTF);
            this.setInputValid(inputDic, false);
            return;
        }
        try {
            String segmentTransferTimeStr = this.segmentTransferTimeTF.getText();
            Integer segmentTransferTime = Integer.valueOf(segmentTransferTimeStr);
            inputDic.put(SEGMENT_TRANSFER_TIME_KEY, segmentTransferTime);
        }
        catch (NumberFormatException exp) {
            inputDic.put("NumberFormatError", this.segmentTransferTimeTF);
            this.setInputValid(inputDic, false);
            return;
        }
        try {
            String pushTimeoutStr = this.pushTimeoutTF.getText();
            Integer pushTimeout = Integer.valueOf(pushTimeoutStr);
            inputDic.put(PUSH_TIMEOUT_KEY, pushTimeout);
        }
        catch (NumberFormatException exp) {
            inputDic.put("NumberFormatError", this.pushTimeoutTF);
            this.setInputValid(inputDic, false);
            return;
        }
        this.setInputValid(inputDic, true);
    }

    public void displayErrorMessage(HashMap inputDic) {
        if (inputDic.containsKey("NumberFormatError")) {
            this.displayNumberFormatError(inputDic);
        }
    }

    public void saveAndApplyChanges(HashMap inputDic) {
        Integer totalWorkerInt = (Integer)inputDic.get(MAX_TOTAL_WORKER_KEY);
        DownloadPrefs.MaxTotalDownloadWorker.set(totalWorkerInt);
        Integer initialSegmentSizeInt = (Integer)inputDic.get(INITIAL_SEGMENT_SIZE_KEY);
        DownloadPrefs.SegmentInitialSize.set(initialSegmentSizeInt * 1024);
        Integer segmentTransferTimeInt = (Integer)inputDic.get(SEGMENT_TRANSFER_TIME_KEY);
        DownloadPrefs.SegmentTransferTargetTime.set(segmentTransferTimeInt);
        Integer maxWorkerPerDownloadInt = (Integer)inputDic.get(WORKER_PER_DOWNLOAD_KEY);
        DownloadPrefs.MaxWorkerPerDownload.set(maxWorkerPerDownloadInt);
        Integer pushTimeoutInt = (Integer)inputDic.get(PUSH_TIMEOUT_KEY);
        int pushTimeout = pushTimeoutInt;
        DownloadPrefs.PushRequestTimeout.set(pushTimeout * 1000);
        boolean readoutMagmas = this.readoutMagmaChkbx.isSelected();
        DownloadPrefs.AutoReadoutMagmaFiles.set(readoutMagmas);
        boolean readoutMetalinks = this.readoutMetalinkChkbx.isSelected();
        DownloadPrefs.AutoReadoutMetalinkFiles.set(readoutMetalinks);
        boolean readoutRSS = this.readoutRSSChkbx.isSelected();
        DownloadPrefs.AutoReadoutRSSFiles.set(readoutRSS);
        boolean silentSubscriptions = this.silentSubscriptionsChkbx.isSelected();
        SubscriptionPrefs.DownloadSilently.set(silentSubscriptions);
        boolean removeCompletedDownloads = this.removeCompletedDownloadsChkbx.isSelected();
        DownloadPrefs.AutoRemoveCompleted.set(removeCompletedDownloads);
        boolean enableHitSnooping = this.enableHitSnoopingChkbx.isSelected();
        ConnectionPrefs.EnableQueryHitSnooping.set(enableHitSnooping);
    }

    private void refreshEnableState() {
    }

    private void initConfigValues() {
    }
}

