/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import phex.common.bandwidth.BandwidthManager;
import phex.common.log.NLogger;
import phex.gui.actions.GUIActionPerformer;
import phex.gui.common.GUIRegistry;
import phex.gui.dialogs.options.BandwidthPane;
import phex.gui.dialogs.options.DirectoriesPane;
import phex.gui.dialogs.options.DisplayPromptsPane;
import phex.gui.dialogs.options.DownloadPane;
import phex.gui.dialogs.options.GeneralTextPane;
import phex.gui.dialogs.options.GeneralUIPane;
import phex.gui.dialogs.options.LanguagePane;
import phex.gui.dialogs.options.MainTextPane;
import phex.gui.dialogs.options.NetworkPane;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.gui.dialogs.options.OptionsTreeCellRenderer;
import phex.gui.dialogs.options.ProxyPane;
import phex.gui.dialogs.options.SharingPane;
import phex.gui.prefs.PhexGuiPrefs;
import phex.prefs.core.PhexCorePrefs;
import phex.utils.Localizer;

public class OptionsDialog
extends JDialog {
    private JPanel contentPanel;
    private PanelBuilder optionViewBuilder;
    private JPanel optionViewPane;
    private JTree optionTree;
    private List<OptionsSettingsPane> settingsPaneList = null;
    private HashMap inputDictionary = new HashMap();

    public OptionsDialog() {
        super(GUIRegistry.getInstance().getMainFrame(), Localizer.getString("PhexOptions"), false);
        this.prepareComponent();
    }

    public void setOptionView(OptionsSettingsPane pane) {
        pane.prepareForDisplay();
        this.optionViewPane.removeAll();
        CellConstraints cc = new CellConstraints();
        this.optionViewBuilder.add((Component)pane, cc.xy(1, 1));
        this.getContentPane().validate();
        pane.doLayout();
        pane.revalidate();
        Dimension prefSize = this.getPreferredSize();
        Dimension currSize = this.getSize();
        if (prefSize.width > currSize.width || prefSize.height > currSize.height) {
            currSize.setSize(Math.max(prefSize.width, currSize.width), Math.max(prefSize.height, currSize.height));
            this.setSize(currSize);
            this.doLayout();
        }
        this.contentPanel.repaint();
    }

    private void prepareComponent() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                OptionsDialog.this.closeDialog();
            }
        });
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.contentPanel = new JPanel();
        contentPane.add((Component)this.contentPanel, "Center");
        FormLayout layout = new FormLayout("3dlu, fill:p, 6dlu, fill:d:grow, 3dlu", "6dlu, fill:d:grow, 3dlu, d, 3dlu, d, 6dlu");
        this.contentPanel.setLayout((LayoutManager)layout);
        PanelBuilder builder = new PanelBuilder(layout, this.contentPanel);
        CellConstraints cc = new CellConstraints();
        SpecialLAFPanel pane = new SpecialLAFPanel();
        builder.add((Component)pane, cc.xy(1, 1));
        this.optionTree = new JTree(this.createOptionTreeModel());
        this.optionTree.setCellRenderer(new OptionsTreeCellRenderer());
        this.optionTree.setRootVisible(false);
        this.optionTree.expandRow(2);
        this.optionTree.expandRow(1);
        this.optionTree.expandRow(0);
        this.optionTree.getSelectionModel().setSelectionMode(1);
        this.optionTree.putClientProperty("JTree.lineStyle", "Angled");
        this.optionTree.addTreeSelectionListener(new OptionSelectionListener());
        builder.add((Component)this.optionTree, cc.xy(2, 2));
        this.optionViewPane = new JPanel();
        FormLayout optionViewLayout = new FormLayout("fill:d:grow", "fill:d:grow");
        this.optionViewBuilder = new PanelBuilder(optionViewLayout, this.optionViewPane);
        builder.add((Component)this.optionViewPane, cc.xy(4, 2));
        JSeparator sep = new JSeparator();
        builder.add((Component)sep, cc.xywh(2, 4, 3, 1));
        JButton okBtn = new JButton(Localizer.getString("OK"));
        okBtn.setDefaultCapable(true);
        okBtn.addActionListener(new OkButtonListener());
        JButton applyBtn = new JButton(Localizer.getString("Apply"));
        applyBtn.addActionListener(new ApplyButtonListener());
        JButton cancelBtn = new JButton(Localizer.getString("Cancel"));
        cancelBtn.addActionListener(new CancelButtonListener());
        JPanel btnPanel = ButtonBarFactory.buildOKCancelApplyBar((JButton)okBtn, (JButton)cancelBtn, (JButton)applyBtn);
        builder.add((Component)btnPanel, cc.xywh(2, 6, 3, 1));
        this.getRootPane().setDefaultButton(okBtn);
        this.setDefaultCloseOperation(2);
        this.optionTree.setSelectionRow(0);
        this.pack();
        this.setLocationRelativeTo(GUIRegistry.getInstance().getMainFrame());
    }

    private boolean isAllInputValid() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.optionTree.getModel().getRoot();
        for (OptionsSettingsPane pane : this.settingsPaneList) {
            if (!pane.isSettingsPaneDisplayed()) continue;
            pane.checkInput(this.inputDictionary);
            if (pane.isInputValid(this.inputDictionary)) continue;
            Enumeration<TreeNode> enumr = root.depthFirstEnumeration();
            while (enumr.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumr.nextElement();
                Object obj = node.getUserObject();
                if (!(obj instanceof OptionsSettingsPane) || obj != pane) continue;
                this.optionTree.setSelectionPath(new TreePath(node.getPath()));
                break;
            }
            this.setOptionView(pane);
            pane.displayErrorMessage(this.inputDictionary);
            return false;
        }
        return true;
    }

    private void saveAndApplyAllChanges() {
        for (OptionsSettingsPane pane : this.settingsPaneList) {
            if (!pane.isSettingsPaneDisplayed()) continue;
            pane.saveAndApplyChanges(this.inputDictionary);
        }
        PhexGuiPrefs.save(false);
        PhexCorePrefs.save(false);
        if (OptionsSettingsPane.isSharedFilesRescanTriggered(this.inputDictionary)) {
            GUIActionPerformer.rescanSharedFiles();
        }
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private TreeModel createOptionTreeModel() {
        BandwidthManager bandwidthService = GUIRegistry.getInstance().getServent().getBandwidthService();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        this.settingsPaneList = new ArrayList<OptionsSettingsPane>();
        OptionsSettingsPane pane = new MainTextPane();
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(pane);
        root.add(parent);
        this.settingsPaneList.add(pane);
        pane = new NetworkPane();
        parent.add(new DefaultMutableTreeNode(pane));
        this.settingsPaneList.add(pane);
        pane = new ProxyPane();
        parent.add(new DefaultMutableTreeNode(pane));
        this.settingsPaneList.add(pane);
        pane = new BandwidthPane(bandwidthService);
        parent.add(new DefaultMutableTreeNode(pane));
        this.settingsPaneList.add(pane);
        pane = new GeneralTextPane("DownloadSharingSettings", "DownloadSharingSettingsText", "DownloadSharingSettings");
        parent = new DefaultMutableTreeNode(pane);
        root.add(parent);
        this.settingsPaneList.add(pane);
        pane = new DownloadPane();
        parent.add(new DefaultMutableTreeNode(pane));
        this.settingsPaneList.add(pane);
        pane = new SharingPane();
        parent.add(new DefaultMutableTreeNode(pane));
        this.settingsPaneList.add(pane);
        pane = new DirectoriesPane();
        parent.add(new DefaultMutableTreeNode(pane));
        this.settingsPaneList.add(pane);
        pane = new GeneralTextPane("UserInterface", "UserInterfaceText", "UserInterface");
        parent = new DefaultMutableTreeNode(pane);
        root.add(parent);
        this.settingsPaneList.add(pane);
        pane = new GeneralUIPane();
        parent.add(new DefaultMutableTreeNode(pane));
        this.settingsPaneList.add(pane);
        pane = new LanguagePane();
        parent.add(new DefaultMutableTreeNode(pane));
        this.settingsPaneList.add(pane);
        pane = new DisplayPromptsPane();
        parent.add(new DefaultMutableTreeNode(pane));
        this.settingsPaneList.add(pane);
        return new DefaultTreeModel(root);
    }

    class SpecialLAFPanel
    extends JPanel {
        private boolean inited = true;

        public void updateUI() {
            if (this.inited && OptionsDialog.this.settingsPaneList != null) {
                for (OptionsSettingsPane pane : OptionsDialog.this.settingsPaneList) {
                    if (pane == null || !pane.isSettingsPaneDisplayed()) continue;
                    SwingUtilities.updateComponentTreeUI(pane);
                }
            }
            super.updateUI();
        }
    }

    class OptionSelectionListener
    implements TreeSelectionListener {
        OptionSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            try {
                TreePath path = e.getPath();
                DefaultMutableTreeNode selectionNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object obj = selectionNode.getUserObject();
                if (obj instanceof OptionsSettingsPane) {
                    OptionsDialog.this.setOptionView((OptionsSettingsPane)obj);
                }
            }
            catch (Throwable th) {
                NLogger.error(OptionSelectionListener.class, th, th);
            }
        }
    }

    private final class OkButtonListener
    implements ActionListener {
        private OkButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (OptionsDialog.this.isAllInputValid()) {
                    OptionsDialog.this.saveAndApplyAllChanges();
                    OptionsDialog.this.closeDialog();
                }
            }
            catch (Throwable th) {
                NLogger.error(OkButtonListener.class, th, th);
            }
        }
    }

    private final class ApplyButtonListener
    implements ActionListener {
        private ApplyButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (OptionsDialog.this.isAllInputValid()) {
                    OptionsDialog.this.saveAndApplyAllChanges();
                }
            }
            catch (Throwable th) {
                NLogger.error(ApplyButtonListener.class, th, th);
            }
        }
    }

    private final class CancelButtonListener
    implements ActionListener {
        private CancelButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                OptionsDialog.this.closeDialog();
            }
            catch (Throwable th) {
                NLogger.error(CancelButtonListener.class, th, th);
            }
        }
    }
}

