/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.macosx;

import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import net.roydesign.event.ApplicationEvent;
import net.roydesign.mac.MRJAdapter;
import net.roydesign.ui.FolderDialog;
import phex.common.log.NLogger;
import phex.event.PhexEventService;
import phex.gui.actions.ExitPhexAction;
import phex.gui.common.GUIRegistry;
import phex.gui.dialogs.AboutDialog;
import phex.gui.dialogs.options.OptionsDialog;

public class MacOsxGUIUtils {
    public static final void installEventHandlers() {
        MRJAdapter.addQuitApplicationListener((ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    NLogger.debug(MacOsxGUIUtils.class, "Called MacOsX quit handler.");
                    ExitPhexAction.performCloseGUIAction();
                }
                catch (Throwable th) {
                    NLogger.error(MacOsxGUIUtils.class, th, th);
                }
            }
        });
        MRJAdapter.setPreferencesEnabled((boolean)true);
        MRJAdapter.addPreferencesListener((ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    NLogger.debug(MacOsxGUIUtils.class, "Called MacOsX preferences handler.");
                    OptionsDialog dialog = new OptionsDialog();
                    dialog.setVisible(true);
                }
                catch (Throwable th) {
                    NLogger.error(MacOsxGUIUtils.class, th, th);
                }
            }
        });
        MRJAdapter.addAboutListener((ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    AboutDialog dialog = new AboutDialog();
                    dialog.setVisible(true);
                }
                catch (Throwable th) {
                    NLogger.error(MacOsxGUIUtils.class, th, th);
                }
            }
        });
        MRJAdapter.addOpenDocumentListener((ActionListener)new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    File file = ((ApplicationEvent)evt).getFile();
                    NLogger.debug(MacOsxGUIUtils.class, "Called MacOsX open file handler: " + file);
                    PhexEventService eventService = GUIRegistry.getInstance().getServent().getEventService();
                    String absFileName = file.getAbsolutePath();
                    if (absFileName.endsWith(".magma")) {
                        eventService.publish("phex:incoming/magma", absFileName);
                    }
                    if (absFileName.endsWith(".xml")) {
                        eventService.publish("phex:incoming/rss", absFileName);
                    }
                }
                catch (Throwable th) {
                    NLogger.error(MacOsxGUIUtils.class, th, th);
                }
            }
        });
    }

    public static final FileDialog createFolderDialog() {
        return new FolderDialog((Frame)GUIRegistry.getInstance().getMainFrame());
    }
}

