/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.library;

import java.awt.EventQueue;
import java.io.File;
import java.io.FileFilter;
import java.util.Comparator;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.gui.common.GUIRegistry;
import phex.gui.common.table.FWSortableTableModel;
import phex.gui.renderer.FileSizeCellRenderer;
import phex.gui.tabs.library.FileSystemTableCellRenderer;
import phex.servent.Servent;
import phex.share.ShareFile;
import phex.share.SharedFilesService;
import phex.thex.ShareFileThexData;
import phex.utils.FilesOnlyFileFilter;
import phex.utils.Localizer;

public class SharedFilesTableModel
extends FWSortableTableModel {
    public static final int FILE_MODEL_INDEX = 0;
    public static final int DIRECTORY_MODEL_INDEX = 1;
    public static final int SIZE_MODEL_INDEX = 2;
    public static final int SEARCH_COUNT_MODEL_INDEX = 3;
    public static final int UPLOAD_COUNT_MODEL_INDEX = 4;
    public static final int ALT_LOC_COUNT_MODEL_INDEX = 5;
    public static final int SHA1_MODEL_INDEX = 6;
    public static final int THEX_MODEL_INDEX = 7;
    public static final int FILE_COLUMN_ID = 1001;
    public static final int DIRECTORY_COLUMN_ID = 1002;
    public static final int SIZE_COLUMN_ID = 1003;
    public static final int SEARCH_COUNT_COLUMN_ID = 1004;
    public static final int UPLOAD_COUNT_COLUMN_ID = 1005;
    public static final int SHA1_COLUMN_ID = 1006;
    public static final int THEX_COLUMN_ID = 1007;
    public static final int ALT_LOC_COUNT_COLUMN_ID = 1008;
    private static final Integer[] COLUMN_IDS = new Integer[]{1001, 1002, 1003, 1004, 1005, 1008, 1006, 1007};
    private static String[] tableColumns = new String[]{Localizer.getString("File"), Localizer.getString("Directory"), Localizer.getString("Size"), Localizer.getString("SearchCount"), Localizer.getString("UploadCount"), Localizer.getString("SharedFilesTable_AltLocCount"), Localizer.getString("SHA1"), Localizer.getString("SharedFilesTable_TigerTree")};
    private static Class[] tableClasses = new Class[]{FileSystemTableCellRenderer.class, String.class, FileSizeCellRenderer.class, Integer.class, Integer.class, Integer.class, String.class, String.class};
    private FileFilter fileFilter = new FilesOnlyFileFilter();
    private File displayDirectory;
    private File[] displayDirectryFiles;
    private SharedFilesService sharedFilesService;

    public SharedFilesTableModel() {
        super(COLUMN_IDS, tableColumns, tableClasses);
        Servent servent = GUIRegistry.getInstance().getServent();
        this.sharedFilesService = servent.getSharedFilesService();
        servent.getEventService().processAnnotations(this);
    }

    public void setDisplayDirectory(File displayDirectory) {
        this.displayDirectory = displayDirectory;
        if (displayDirectory != null) {
            this.displayDirectryFiles = displayDirectory.listFiles(this.fileFilter);
        }
        this.fireTableDataChanged();
    }

    public int getRowCount() {
        if (this.displayDirectory == null) {
            return 0;
        }
        if (this.displayDirectryFiles == null) {
            return 0;
        }
        return this.displayDirectryFiles.length;
    }

    public Object getValueAt(int row, int col) {
        if (this.displayDirectory == null) {
            return "";
        }
        if (row >= this.displayDirectryFiles.length) {
            this.fireTableRowsDeleted(row, row);
            return "";
        }
        ShareFile shareFile = this.sharedFilesService.getShareFileByFile(this.displayDirectryFiles[row]);
        if (shareFile == null) {
            switch (col) {
                case 0: {
                    return this.displayDirectryFiles[row];
                }
                case 1: {
                    return this.displayDirectryFiles[row].getParent();
                }
                case 2: {
                    return this.displayDirectryFiles[row].length();
                }
                case 3: 
                case 4: 
                case 5: {
                    return null;
                }
                case 6: 
                case 7: {
                    return "";
                }
            }
        } else {
            switch (col) {
                case 0: {
                    return shareFile;
                }
                case 1: {
                    return shareFile.getSystemFile().getParent();
                }
                case 2: {
                    return shareFile.getFileSize();
                }
                case 3: {
                    return shareFile.getSearchCount();
                }
                case 4: {
                    return shareFile.getUploadCount();
                }
                case 5: {
                    return shareFile.getAltLocCount();
                }
                case 6: {
                    return shareFile.getSha1();
                }
                case 7: {
                    ShareFileThexData thexData = shareFile.getThexData(null);
                    return thexData != null ? thexData.getRootHash() : "";
                }
            }
        }
        return "";
    }

    public Object getComparableValueAt(int row, int column) {
        if (this.displayDirectory == null) {
            return this.getValueAt(row, column);
        }
        if (row >= this.displayDirectryFiles.length) {
            return this.getValueAt(row, column);
        }
        switch (column) {
            case 0: {
                ShareFile shareFile = this.sharedFilesService.getShareFileByFile(this.displayDirectryFiles[row]);
                if (shareFile == null) {
                    return this.displayDirectryFiles[row].getName();
                }
                return shareFile.getFileName();
            }
        }
        return this.getValueAt(row, column);
    }

    public Comparator getColumnComparator(int column) {
        switch (column) {
            case 2: {
                return ComparableComparator.getInstance();
            }
        }
        return null;
    }

    public boolean isColumnHideable(int columnIndex) {
        return columnIndex != 0;
    }

    public boolean isColumnDefaultVisible(int columnIndex) {
        return columnIndex != 6 && columnIndex != 7 && columnIndex != 3 && columnIndex != 5;
    }

    @EventTopicSubscriber(topic="phex:share/update")
    public void onShareUpdateEvent(String topic, Object event) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                SharedFilesTableModel.this.fireTableDataChanged();
            }
        });
    }
}

