/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.network;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.text.Keymap;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import phex.common.address.DestAddress;
import phex.common.address.MalformedDestAddressException;
import phex.connection.OutgoingConnectionDispatcher;
import phex.event.ChangeEvent;
import phex.gui.actions.BanHostActionUtils;
import phex.gui.actions.FWAction;
import phex.gui.actions.GUIActionPerformer;
import phex.gui.common.FWElegantPanel;
import phex.gui.common.FWPopupMenu;
import phex.gui.common.GUIRegistry;
import phex.gui.common.GUIUtils;
import phex.gui.common.IconPack;
import phex.gui.common.table.FWSortedTableModel;
import phex.gui.common.table.FWTable;
import phex.gui.prefs.NetworkTabPrefs;
import phex.gui.prefs.PhexGuiPrefs;
import phex.gui.tabs.FWTab;
import phex.gui.tabs.network.NetFavoritesPanel;
import phex.gui.tabs.network.NetworkRowRenderer;
import phex.gui.tabs.network.NetworkTableModel;
import phex.host.Host;
import phex.host.HostManager;
import phex.host.HostStatus;
import phex.host.NetworkHostsContainer;
import phex.net.repres.PresentationManager;
import phex.prefs.core.NetworkPrefs;
import phex.servent.Servent;
import phex.utils.Localizer;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTable;

public class NetworkTab
extends FWTab {
    private static final Logger logger = LoggerFactory.getLogger(NetworkTab.class);
    private static final String NETWORK_TABLE_IDENTIFIER = "NetworkTable";
    private static final Host[] EMPTY_HOST_ARRAY = new Host[0];
    private HostManager hostMgr;
    private NetworkHostsContainer hostsContainer;
    private FWTable networkTable;
    private NetworkRowRenderer networkRowRenderer;
    private JScrollPane networkTableScrollPane;
    private NetworkTableModel networkModel;
    private FWPopupMenu networkPopup;
    private JLabel myIPLabel;
    private DefaultComboBoxModel connectToComboModel;
    private JComboBox connectToComboBox;
    private JLabel catcherStatLabel;
    private UpdateAction updateAction;
    private static final String DISCONNECT_HOST_ACTION_KEY = "DisconnectHostAction";
    private static final String CHAT_TO_HOST_ACTION_KEY = "ChatToHostAction";
    private static final String BROWSE_HOST_ACTION_KEY = "BrowseHostAction";
    private static final String ADD_TO_FAVORITES_ACTION_KEY = "AddToFavoritesAction";

    public NetworkTab() {
        super(1000, Localizer.getString("GnutellaNet"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Network.Tab"), Localizer.getString("TTTGnutellaNet"), Localizer.getChar("GnutellaNetMnemonic"), KeyStroke.getKeyStroke(Localizer.getString("GnutellaNetAccelerator")), 0);
        Servent servent = GUIRegistry.getInstance().getServent();
        this.hostMgr = servent.getHostService();
        this.hostsContainer = this.hostMgr.getNetworkHostsContainer();
        servent.getEventService().processAnnotations(this);
    }

    public void initComponent(DGuiSettings guiSettings) {
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("2dlu, fill:d:grow, 2dlu", "2dlu, fill:d:grow, 4dlu, d, 2dlu");
        PanelBuilder contentBuilder = new PanelBuilder(layout, (JPanel)this);
        JPanel upperPanel = new JPanel();
        FWElegantPanel upperElegantPanel = new FWElegantPanel(Localizer.getString("Connections"), upperPanel);
        layout = new FormLayout("0dlu, d, 2dlu, d, 10dlu:grow, d, 2dlu, d, 2dlu, d, 0dlu", "fill:d:grow, 3dlu, p");
        PanelBuilder upperBuilder = new PanelBuilder(layout, upperPanel);
        this.networkModel = new NetworkTableModel(this.hostMgr.getNetworkHostsContainer());
        this.networkTable = new FWTable(new FWSortedTableModel(this.networkModel));
        GUIUtils.updateTableFromDGuiSettings(guiSettings, this.networkTable, NETWORK_TABLE_IDENTIFIER);
        this.networkTable.activateAllHeaderActions();
        this.networkTable.setAutoResizeMode(0);
        this.networkTable.getSelectionModel().addListSelectionListener(new SelectionHandler());
        MouseHandler mouseHandler = new MouseHandler();
        this.networkTable.addMouseListener(mouseHandler);
        GUIRegistry.getInstance().getGuiUpdateTimer().addTable(this.networkTable);
        this.networkTableScrollPane = FWTable.createFWTableScrollPane(this.networkTable);
        this.networkTableScrollPane.addMouseListener(mouseHandler);
        upperBuilder.add((Component)this.networkTableScrollPane, cc.xywh(2, 1, 9, 1));
        JLabel label = new JLabel(Localizer.getString("NetworkTab_MyAddress"));
        upperBuilder.add((Component)label, cc.xy(2, 3));
        this.myIPLabel = new JLabel("");
        this.myIPLabel.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
                }
            }

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
                }
            }

            private void popupMenu(Component source, int x, int y) {
                JPopupMenu menu = new JPopupMenu();
                menu.add(new CopyMyIpAction());
                menu.show(source, x, y);
            }
        });
        upperBuilder.add((Component)this.myIPLabel, cc.xy(4, 3));
        label = new JLabel(Localizer.getString("ConnectTo") + Localizer.getChar("ColonSign"));
        upperBuilder.add((Component)label, cc.xy(6, 3));
        ConnectToHostHandler connectToHostHandler = new ConnectToHostHandler();
        this.connectToComboModel = new DefaultComboBoxModel<Object>(NetworkTabPrefs.ConnectToHistory.get().toArray());
        this.connectToComboBox = new JComboBox(this.connectToComboModel);
        this.connectToComboBox.setEditable(true);
        JTextField editor = (JTextField)this.connectToComboBox.getEditor().getEditorComponent();
        Keymap keymap = JTextField.addKeymap("ConnectToEditor", editor.getKeymap());
        editor.setKeymap(keymap);
        keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(10, 0), connectToHostHandler);
        GUIUtils.assignKeymapToComboBoxEditor(keymap, this.connectToComboBox);
        this.connectToComboBox.setSelectedItem("");
        this.connectToComboBox.setPrototypeDisplayValue("123.123.123.123:12345");
        upperBuilder.add((Component)this.connectToComboBox, cc.xy(8, 3));
        JButton connectHostButton = new JButton(Localizer.getString("Connect"));
        connectHostButton.addActionListener(connectToHostHandler);
        upperBuilder.add((Component)connectHostButton, cc.xy(10, 3));
        JPanel lowerPanel = new JPanel();
        layout = new FormLayout("d, fill:10dlu:grow, d", "top:p");
        layout.setColumnGroups((int[][])new int[][]{{1, 3}});
        PanelBuilder lowerBuilder = new PanelBuilder(layout, lowerPanel);
        NetFavoritesPanel favoritesPanel = new NetFavoritesPanel(this.hostMgr.getFavoritesContainer());
        lowerBuilder.add((Component)favoritesPanel, cc.xy(1, 1));
        JPanel cacheStatusPanel = new JPanel();
        layout = new FormLayout("8dlu, right:d, 2dlu, right:d, 2dlu, d, 2dlu:grow, 8dlu", "p, 3dlu, p, 3dlu, p, 3dlu, bottom:p:grow");
        PanelBuilder cacheStatusBuilder = new PanelBuilder(layout, cacheStatusPanel);
        lowerBuilder.add((Component)cacheStatusPanel, cc.xy(3, 1));
        cacheStatusBuilder.addSeparator(Localizer.getString("NetworkTab_ConnectionInfo"), cc.xywh(1, 1, 8, 1));
        cacheStatusBuilder.addLabel(Localizer.getString("NetworkTab_HostCacheContains"), cc.xy(2, 3));
        this.catcherStatLabel = new JLabel();
        cacheStatusBuilder.add((Component)this.catcherStatLabel, cc.xy(4, 3));
        cacheStatusBuilder.addLabel(Localizer.getString("NetworkTab_Hosts"), cc.xy(6, 3));
        contentBuilder.add((Component)upperElegantPanel, cc.xy(2, 2));
        contentBuilder.add((Component)lowerPanel, cc.xy(2, 4));
        this.networkRowRenderer = new NetworkRowRenderer(this.hostMgr.getNetworkHostsContainer());
        List<TableColumn> colList = this.networkTable.getColumns(true);
        for (TableColumn column : colList) {
            column.setCellRenderer(this.networkRowRenderer);
        }
        this.networkPopup = new FWPopupMenu();
        FWAction action = new DisconnectHostAction();
        this.addTabAction(DISCONNECT_HOST_ACTION_KEY, action);
        this.networkTable.getActionMap().put(DISCONNECT_HOST_ACTION_KEY, action);
        this.networkTable.getInputMap(1).put((KeyStroke)action.getValue("AcceleratorKey"), DISCONNECT_HOST_ACTION_KEY);
        this.networkPopup.addAction(action);
        this.networkPopup.addSeparator();
        action = new AddToFavoritesAction();
        this.addTabAction(ADD_TO_FAVORITES_ACTION_KEY, action);
        this.networkPopup.addAction(action);
        action = new BrowseHostAction();
        this.addTabAction(BROWSE_HOST_ACTION_KEY, action);
        this.networkPopup.addAction(action);
        action = new ChatToHostAction();
        this.addTabAction(CHAT_TO_HOST_ACTION_KEY, action);
        this.networkPopup.addAction(action);
        BanHostActionProvider banHostActionProvider = new BanHostActionProvider();
        BanHostActionUtils.BanHostActionMenu bhActionMenu = BanHostActionUtils.createActionMenu(banHostActionProvider);
        this.networkPopup.add(bhActionMenu.menu);
        this.addTabActions(bhActionMenu.actions);
        this.networkPopup.addSeparator();
        JMenu netMenu = new JMenu(Localizer.getString("Network"));
        netMenu.add(GUIRegistry.getInstance().getGlobalAction("ConnectNetworkAction"));
        netMenu.add(GUIRegistry.getInstance().getGlobalAction("DisconnectNetworkAction"));
        this.networkPopup.add(netMenu);
        this.updateAction = new UpdateAction();
        this.updateIpLabel(GUIRegistry.getInstance().getServent().getLocalAddress());
    }

    public void updateUI() {
        super.updateUI();
        if (this.connectToComboBox != null) {
            GUIUtils.adjustComboBoxHeight(this.connectToComboBox);
            ListCellRenderer renderer = this.connectToComboBox.getRenderer();
            if (renderer != null) {
                FontMetrics fm = this.connectToComboBox.getFontMetrics(this.connectToComboBox.getFont());
                int width = fm.getMaxAdvance() * 15;
                Dimension dim = this.connectToComboBox.getMaximumSize();
                dim.width = Math.min(width, dim.width);
                dim = this.connectToComboBox.getPreferredSize();
                dim.width = Math.min(width, dim.width);
            }
        }
        if (this.networkTableScrollPane != null) {
            FWTable.updateFWTableScrollPane(this.networkTableScrollPane);
        }
        if (this.networkRowRenderer != null) {
            this.networkRowRenderer.updateUI();
        }
    }

    public void appendDGuiSettings(DGuiSettings dSettings) {
        super.appendDGuiSettings(dSettings);
        DTable dTable = GUIUtils.createDTable(this.networkTable, NETWORK_TABLE_IDENTIFIER);
        dSettings.getTableList().getTableList().add(dTable);
    }

    public void removeNotify() {
        super.removeNotify();
        GUIRegistry.getInstance().getGuiUpdateTimer().removeActionListener(this.updateAction);
    }

    public void addNotify() {
        super.addNotify();
        GUIRegistry.getInstance().getGuiUpdateTimer().addActionListener(this.updateAction);
    }

    private Host[] getSelectedHosts() {
        int[] viewRows = this.networkTable.getSelectedRows();
        if (viewRows.length == 0) {
            return EMPTY_HOST_ARRAY;
        }
        int[] modelRows = this.networkTable.convertRowIndicesToModel(viewRows);
        Host[] hosts = this.hostsContainer.getNetworkHostsAt(modelRows);
        return hosts;
    }

    private Host getSelectedHost() {
        int viewRow = this.networkTable.getSelectedRow();
        int modelRow = this.networkTable.translateRowIndexToModel(viewRow);
        if (modelRow < 0) {
            return null;
        }
        Host hosts = this.hostsContainer.getNetworkHostAt(modelRow);
        return hosts;
    }

    private void updateIpLabel(DestAddress localAddress) {
        if (this.myIPLabel == null) {
            return;
        }
        this.myIPLabel.setText(localAddress.getFullHostName());
        String countryCode = localAddress.getCountryCode();
        Icon icon = null;
        if (countryCode != null && countryCode.length() > 0) {
            icon = GUIRegistry.getInstance().getCountryIconPack().getIcon(countryCode);
        }
        this.myIPLabel.setIcon(icon);
    }

    @EventTopicSubscriber(topic="phex:servent/localAddress")
    public void onLocaleAddressEvent(String topic, ChangeEvent event) {
        final DestAddress localAddress = (DestAddress)event.getNewValue();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                NetworkTab.this.updateIpLabel(localAddress);
            }
        });
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popupMenu((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        private void popupMenu(Component source, int x, int y) {
            if (source == NetworkTab.this.networkTable || source == NetworkTab.this.networkTableScrollPane) {
                NetworkTab.this.networkPopup.show(source, x, y);
            }
        }
    }

    private class ConnectToHostHandler
    extends AbstractAction {
        private ConnectToHostHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            String str = (String)NetworkTab.this.connectToComboBox.getEditor().getItem();
            NetworkTab.this.connectToComboModel.setSelectedItem(str);
            str = str.trim();
            if (str.length() == 0) {
                return;
            }
            int idx = NetworkTab.this.connectToComboModel.getIndexOf(str);
            if (idx < 0) {
                NetworkTab.this.connectToComboModel.insertElementAt(str, 0);
                if (NetworkTab.this.connectToComboModel.getSize() > NetworkTabPrefs.MaxConnectToHistorySize.get()) {
                    NetworkTab.this.connectToComboModel.removeElementAt(NetworkTab.this.connectToComboModel.getSize() - 1);
                }
                this.saveConnectToHostList();
            } else if (idx > 0) {
                NetworkTab.this.connectToComboModel.removeElementAt(idx);
                NetworkTab.this.connectToComboModel.insertElementAt(str, 0);
                this.saveConnectToHostList();
            }
            this.connectToHost(str);
            NetworkTab.this.connectToComboBox.setSelectedItem("");
        }

        private void connectToHost(String hostAddr) {
            if (hostAddr.length() == 0) {
                return;
            }
            StringTokenizer tokens = new StringTokenizer(hostAddr, ";");
            String firstHost = tokens.nextToken();
            try {
                DestAddress address = PresentationManager.getInstance().createHostAddress(firstHost, 6346);
                OutgoingConnectionDispatcher.dispatchConnectToHost(address, GUIRegistry.getInstance().getServent());
            }
            catch (MalformedDestAddressException exp) {
                // empty catch block
            }
            NetworkTab.this.networkModel.fireTableDataChanged();
            while (tokens.hasMoreTokens()) {
                String hostString = tokens.nextToken();
                try {
                    DestAddress address = PresentationManager.getInstance().createHostAddress(hostString, 6346);
                    NetworkTab.this.hostMgr.getCaughtHostsContainer().addCaughtHost(address, (short)2);
                }
                catch (MalformedDestAddressException exp) {}
            }
        }

        private void saveConnectToHostList() {
            int length = NetworkTab.this.connectToComboModel.getSize();
            ArrayList<String> ipList = new ArrayList<String>(length);
            for (int i = 0; i < length; ++i) {
                ipList.add((String)NetworkTab.this.connectToComboModel.getElementAt(i));
            }
            NetworkTabPrefs.ConnectToHistory.get().clear();
            NetworkTabPrefs.ConnectToHistory.get().addAll(ipList);
            NetworkTabPrefs.ConnectToHistory.changed();
            PhexGuiPrefs.save(false);
        }
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                NetworkTab.this.refreshTabActions();
            }
        }
    }

    private final class UpdateAction
    implements ActionListener {
        private UpdateAction() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                NetworkTab.this.catcherStatLabel.setText(String.valueOf(NetworkTab.this.hostMgr.getCaughtHostsContainer().getCaughtHostsCount()));
                if (NetworkPrefs.AutoRemoveBadHosts.get().booleanValue()) {
                    Host[] hosts;
                    long now = System.currentTimeMillis();
                    for (Host host : hosts = NetworkTab.this.hostMgr.getNetworkHostsContainer().getNetworkHosts()) {
                        HostStatus status = host.getStatus();
                        if (status == HostStatus.CONNECTED || status == HostStatus.CONNECTING || status == HostStatus.ACCEPTING || !host.isErrorStatusExpired(now, NetworkTabPrefs.HostErrorDisplayTime.get().intValue())) continue;
                        NetworkTab.this.hostMgr.removeNetworkHost(host);
                    }
                }
            }
            catch (Throwable th) {
                logger.error(th.toString(), th);
            }
        }
    }

    private static class CopyMyIpAction
    extends FWAction {
        CopyMyIpAction() {
            super(Localizer.getString("Copy"), (Icon)IconPack.EMPTY_IMAGE_16, Localizer.getString("TTTCopyMyIP"));
        }

        public void actionPerformed(ActionEvent e) {
            DestAddress address = GUIRegistry.getInstance().getServent().getLocalAddress();
            StringSelection data = new StringSelection(address.getFullHostName());
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(data, data);
        }

        public void refreshActionState() {
        }
    }

    private class BrowseHostAction
    extends FWAction {
        public BrowseHostAction() {
            super(Localizer.getString("BrowseHost"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Network.BrowseHost"), Localizer.getString("TTTBrowseHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            Host host = NetworkTab.this.getSelectedHost();
            if (host == null) {
                return;
            }
            GUIActionPerformer.browseHost(host.getHostAddress());
        }

        public void refreshActionState() {
            Host host;
            if (NetworkTab.this.networkTable.getSelectedRowCount() == 1 && (host = NetworkTab.this.getSelectedHost()) != null) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private class ChatToHostAction
    extends FWAction {
        public ChatToHostAction() {
            super(Localizer.getString("ChatToHost"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Network.Chat"), Localizer.getString("TTTChatToHost"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            Host host = NetworkTab.this.getSelectedHost();
            if (host == null) {
                return;
            }
            GUIActionPerformer.chatToHost(host.getHostAddress());
        }

        public void refreshActionState() {
            Host host;
            if (NetworkTab.this.networkTable.getSelectedRowCount() == 1 && (host = NetworkTab.this.getSelectedHost()) != null) {
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private class AddToFavoritesAction
    extends FWAction {
        public AddToFavoritesAction() {
            super(Localizer.getString("AddToFavorites"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Network.FavoriteHost"), Localizer.getString("TTTAddToFavorites"));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            Host[] hosts = NetworkTab.this.getSelectedHosts();
            DestAddress[] addresses = new DestAddress[hosts.length];
            for (int i = 0; i < hosts.length; ++i) {
                addresses[i] = hosts[i].getHostAddress();
            }
            GUIActionPerformer.addHostsToFavorites(addresses);
        }

        public void refreshActionState() {
            if (NetworkTab.this.networkTable.getSelectedRowCount() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    private final class BanHostActionProvider
    implements BanHostActionUtils.BanHostActionProvider {
        private BanHostActionProvider() {
        }

        public DestAddress[] getBanHostAddresses() {
            Host[] hosts = NetworkTab.this.getSelectedHosts();
            NetworkTab.this.hostMgr.removeNetworkHosts(hosts);
            DestAddress[] addresses = new DestAddress[hosts.length];
            for (int i = 0; i < hosts.length; ++i) {
                addresses[i] = hosts[i].getHostAddress();
            }
            return addresses;
        }

        public boolean isBanHostActionEnabled(boolean allowMultipleAddresses) {
            return NetworkTab.this.networkTable.getSelectedRow() >= 0 && (allowMultipleAddresses || NetworkTab.this.networkTable.getSelectedRowCount() <= 1);
        }
    }

    private class DisconnectHostAction
    extends FWAction {
        public DisconnectHostAction() {
            super(Localizer.getString("DisconnectHost"), GUIRegistry.getInstance().getPlafIconPack().getIcon("Network.DisconnectHost"), Localizer.getString("TTTDisconnectHost"), null, KeyStroke.getKeyStroke(127, 0));
            this.refreshActionState();
        }

        public void actionPerformed(ActionEvent e) {
            Host[] hosts = NetworkTab.this.getSelectedHosts();
            NetworkTab.this.hostMgr.removeNetworkHosts(hosts);
        }

        public void refreshActionState() {
            if (NetworkTab.this.networkTable.getSelectedRowCount() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }
}

