/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search;

import java.util.Comparator;
import phex.gui.comparator.DestAddressComparator;
import phex.gui.tabs.search.SearchResultElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResultElementComparator
implements Comparator<SearchResultElement> {
    public static final int UNSORTED = 0;
    public static final int SORT_BY_SIZE = 1;
    public static final int SORT_BY_FILE = 2;
    public static final int SORT_BY_EXTENSION = 3;
    public static final int SORT_BY_BITZI_RATING = 4;
    public static final int SORT_BY_SHA1 = 5;
    public static final int SORT_BY_HOST = 6;
    public static final int SORT_BY_META_DATA = 7;
    public static final int SORT_BY_VENDOR = 8;
    public static final int SORT_BY_SPEED = 9;
    public static final int SORT_BY_RATING = 10;
    public static final int SORT_BY_SCORE = 11;
    private int sortField;
    private boolean isSortedAscending;
    private DestAddressComparator destAddressComparator;

    public void setSortField(int sortField, boolean isSortedAscending) {
        this.sortField = sortField;
        this.isSortedAscending = isSortedAscending;
        this.destAddressComparator = new DestAddressComparator();
    }

    @Override
    public int compare(SearchResultElement sr1, SearchResultElement sr2) {
        long diff;
        if (sr1 == sr2 || sr1.equals(sr2)) {
            return 0;
        }
        switch (this.sortField) {
            case 1: {
                diff = sr1.getSingleRemoteFile().getFileSize() - sr2.getSingleRemoteFile().getFileSize();
                break;
            }
            case 2: {
                diff = sr1.getSingleRemoteFile().getFilename().compareTo(sr2.getSingleRemoteFile().getFilename());
                break;
            }
            case 3: {
                diff = sr1.getSingleRemoteFile().getFileExt().compareTo(sr2.getSingleRemoteFile().getFileExt());
                break;
            }
            case 4: {
                diff = Float.valueOf(sr1.getSingleRemoteFile().getBitzRating()).compareTo(Float.valueOf(sr2.getSingleRemoteFile().getBitzRating()));
                break;
            }
            case 5: {
                diff = sr1.getSingleRemoteFile().getSHA1().compareTo(sr2.getSingleRemoteFile().getSHA1());
                break;
            }
            case 6: {
                if (sr1.getRemoteFileListCount() == 0 && sr2.getRemoteFileListCount() == 0) {
                    diff = this.destAddressComparator.compare(sr1.getSingleRemoteFile().getHostAddress(), sr2.getSingleRemoteFile().getHostAddress());
                    break;
                }
                diff = sr1.getRemoteFileListCount() - sr2.getRemoteFileListCount();
                break;
            }
            case 7: {
                if (sr1.getRemoteFileListCount() == 0 && sr2.getRemoteFileListCount() == 0) {
                    String meta1 = sr1.getSingleRemoteFile().getMetaData();
                    String meta2 = sr2.getSingleRemoteFile().getMetaData();
                    diff = meta1 == null || meta2 == null ? -1L : (long)meta1.compareTo(meta2);
                    break;
                }
                diff = sr1.getRemoteFileListCount() - sr2.getRemoteFileListCount();
                break;
            }
            case 8: {
                if (sr1.getRemoteFileListCount() == 0 && sr2.getRemoteFileListCount() == 0) {
                    String v1 = sr1.getSingleRemoteFile().getQueryHitHost().getVendor();
                    String v2 = sr2.getSingleRemoteFile().getQueryHitHost().getVendor();
                    diff = v1 == null || v2 == null ? -1L : (long)v1.compareTo(v2);
                    break;
                }
                diff = sr1.getRemoteFileListCount() - sr2.getRemoteFileListCount();
                break;
            }
            case 9: {
                if (sr1.getRemoteFileListCount() == 0 && sr2.getRemoteFileListCount() == 0) {
                    diff = sr1.getSingleRemoteFile().getSpeed() - sr2.getSingleRemoteFile().getSpeed();
                    break;
                }
                diff = sr1.getRemoteFileListCount() - sr2.getRemoteFileListCount();
                break;
            }
            case 10: {
                if (sr1.getRemoteFileListCount() == 0 && sr2.getRemoteFileListCount() == 0) {
                    diff = sr1.getSingleRemoteFile().getQueryHitHost().getHostRating() - sr2.getSingleRemoteFile().getQueryHitHost().getHostRating();
                    break;
                }
                diff = sr1.getRemoteFileListCount() - sr2.getRemoteFileListCount();
                break;
            }
            case 11: {
                if (sr1.getRemoteFileListCount() == 0 && sr2.getRemoteFileListCount() == 0) {
                    diff = sr1.getSingleRemoteFile().getScore() - sr2.getSingleRemoteFile().getScore();
                    break;
                }
                diff = sr1.getRemoteFileListCount() - sr2.getRemoteFileListCount();
                break;
            }
            default: {
                diff = 1L;
            }
        }
        if (diff == 0L) {
            diff = sr1.hashCode() - sr2.hashCode();
        }
        long l = diff = this.isSortedAscending ? diff : -diff;
        if (diff < 0L) {
            return -1;
        }
        if (diff > 0L) {
            return 1;
        }
        return 1;
    }
}

