/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.tabs.search.monitor;

import java.awt.EventQueue;
import javax.swing.table.AbstractTableModel;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.gui.common.GUIRegistry;
import phex.host.Host;
import phex.msg.MsgHeader;
import phex.query.QueryHistoryMonitor;
import phex.utils.Localizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryHistoryMonitorTableModel
extends AbstractTableModel {
    private static final int numColRoutedFrom = 0;
    private static final int numColSearchText = 1;
    private static final int numColHopsTtl = 2;
    private static final String[] tableColumns = new String[]{Localizer.getString("SearchMonitorTab_RoutedFrom"), Localizer.getString("SearchMonitorTab_SearchText"), Localizer.getString("SearchMonitorTab_HopsTtl")};
    private QueryHistoryMonitor history;

    public QueryHistoryMonitorTableModel(QueryHistoryMonitor history) {
        this.history = history;
        GUIRegistry.getInstance().getServent().getEventService().processAnnotations(this);
    }

    @Override
    public String getColumnName(int col) {
        return tableColumns[col];
    }

    @Override
    public int getColumnCount() {
        return tableColumns.length;
    }

    @Override
    public int getRowCount() {
        return this.history.getHistorySize();
    }

    @Override
    public Object getValueAt(int row, int col) {
        QueryHistoryMonitor.HistoryEntry histEntry = this.history.getSearchQueryAt(row);
        if (histEntry == null) {
            this.fireTableRowsDeleted(row, row);
            return null;
        }
        MsgHeader header = histEntry.getQueryMsg().getHeader();
        switch (col) {
            case 0: {
                Host fromHost = histEntry.getSourceHost();
                if (fromHost == null) {
                    return "<Unknown>";
                }
                return fromHost.getHostAddress().getFullHostName();
            }
            case 1: {
                return histEntry.getQueryMsg().getSearchString();
            }
            case 2: {
                byte hops = header.getHopsTaken();
                int ttl = hops + header.getTTL();
                return hops + " / " + ttl;
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return String.class;
    }

    @EventTopicSubscriber(topic="phex:query/monitor")
    public void onQueryMonitorEvent(String topic, Object event) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                QueryHistoryMonitorTableModel.this.fireTableDataChanged();
            }
        });
    }
}

