/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.util.concurrent.atomic.AtomicInteger;
import phex.common.address.DestAddress;
import phex.utils.StringUtils;

public class CaughtHost {
    private static AtomicInteger UNIQUE_ID_PROVIDER = new AtomicInteger(0);
    private final int uniqueId = UNIQUE_ID_PROVIDER.incrementAndGet();
    private final DestAddress hostAddress;
    private long lastFailedConnection;
    private long lastSuccessfulConnection;
    private int avgDailyUptime;
    private String vendor;
    private int vendorVersionMajor;
    private int vendorVersionMinor;
    private boolean isUltrapeer;

    public CaughtHost(DestAddress address) {
        this.hostAddress = address;
        this.lastFailedConnection = -1L;
        this.lastSuccessfulConnection = -1L;
    }

    public DestAddress getHostAddress() {
        return this.hostAddress;
    }

    public void setVendor(String vendor, int vendorVersionMajor, int vendorVersionMinor) {
        this.vendor = vendor;
        this.vendorVersionMajor = vendorVersionMajor;
        this.vendorVersionMinor = vendorVersionMinor;
    }

    public String getVendor() {
        return this.vendor;
    }

    public int getVendorVersionMajor() {
        return this.vendorVersionMajor;
    }

    public int getVendorVersionMinor() {
        return this.vendorVersionMinor;
    }

    public void setDailyUptime(int dailyUptime) {
        this.avgDailyUptime = dailyUptime;
    }

    public int getDailyUptime() {
        return this.avgDailyUptime;
    }

    public boolean isUltrapeer() {
        return this.isUltrapeer;
    }

    public void setUltrapeer(boolean isUltrapeer) {
        this.isUltrapeer = isUltrapeer;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CaughtHost)) {
            return false;
        }
        return this.hostAddress.equals(((CaughtHost)o).hostAddress);
    }

    public int hashCode() {
        return ((Object)this.hostAddress).hashCode();
    }

    public boolean isDecentPhexHost() {
        if (!StringUtils.equals(this.vendor, "PHEX")) {
            return false;
        }
        if (this.avgDailyUptime < 3600) {
            return false;
        }
        return this.isUltrapeer;
    }

    public int getConnectionTimeRating() {
        if (this.lastSuccessfulConnection == -1L && this.lastFailedConnection == -1L) {
            return 0;
        }
        if (this.lastFailedConnection > this.lastSuccessfulConnection) {
            return -1;
        }
        return 1;
    }

    public void setLastFailedConnection(long l) {
        this.lastFailedConnection = l;
    }

    public void setLastSuccessfulConnection(long l) {
        this.lastSuccessfulConnection = l;
    }

    public long getLastFailedConnection() {
        return this.lastFailedConnection;
    }

    public long getLastSuccessfulConnection() {
        return this.lastSuccessfulConnection;
    }

    public String toString() {
        return "CaughtHost[" + this.hostAddress.toString() + ",Failed=" + this.lastFailedConnection + ",Successful=" + this.lastSuccessfulConnection + ",Uptime=" + this.avgDailyUptime + "]";
    }

    public int getUniqueId() {
        return this.uniqueId;
    }
}

