/*
 * Decompiled with CFR 0.152.
 */
package phex.http;

import phex.http.HTTPHeader;
import phex.http.HTTPHeaderGroup;

public class HTTPResponse {
    public static final String CRLF = "\r\n";
    private static final char SP = ' ';
    private String httpVersion;
    private short statusCode;
    private String statusReason;
    private HTTPHeaderGroup httpHeaders;

    public HTTPResponse(short aStatusCode, String aStatusReason, boolean isOutgoing) {
        this("HTTP/1.1", aStatusCode, aStatusReason, isOutgoing);
    }

    public HTTPResponse(String aHTTPVersion, short aStatusCode, String aStatusReason, boolean isOutgoing) {
        this.httpVersion = aHTTPVersion;
        this.statusCode = aStatusCode;
        this.statusReason = aStatusReason;
        this.httpHeaders = isOutgoing ? HTTPHeaderGroup.createDefaultResponseHeaders() : new HTTPHeaderGroup(false);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public String getHTTPVersion() {
        return this.httpVersion;
    }

    public void addHeader(HTTPHeader header) {
        this.httpHeaders.addHeader(header);
    }

    public void addHeaders(HTTPHeader[] headers) {
        this.httpHeaders.addHeaders(headers);
    }

    public HTTPHeader getHeader(String name) {
        return this.httpHeaders.getHeader(name);
    }

    public HTTPHeader[] getHeaders(String name) {
        return this.httpHeaders.getHeaders(name);
    }

    public String buildHTTPResponseString() {
        return this.httpVersion + ' ' + this.statusCode + ' ' + this.statusReason + CRLF + this.httpHeaders.buildHTTPHeaderString() + CRLF;
    }
}

