/*
 * Decompiled with CFR 0.152.
 */
package phex.http;

public class Range {
    public static final int NOT_SET = -1;
    private long suffixLength;
    private long startOffset;
    private long endOffset;

    public Range(long suffixLength) {
        this.startOffset = -1L;
        this.endOffset = -1L;
        this.suffixLength = suffixLength;
    }

    public Range(long startOffset, long endOffset) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.suffixLength = -1L;
    }

    public void update(long suffix) {
        this.startOffset = -1L;
        this.endOffset = -1L;
        this.suffixLength = suffix;
    }

    public void update(long startOffset, long endOffset) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.suffixLength = -1L;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[Range: " + this.startOffset + "-" + this.endOffset + "]");
        return buf.toString();
    }

    public long getStartOffset(long fileSize) {
        if (this.suffixLength == -1L) {
            return Math.min(this.startOffset, fileSize - 1L);
        }
        return fileSize - this.suffixLength;
    }

    public long getEndOffset(long fileSize) {
        if (this.suffixLength == -1L && this.endOffset != -1L) {
            return Math.min(this.endOffset, fileSize - 1L);
        }
        return fileSize - 1L;
    }

    public boolean isRangeSatisfiable(Range range, long fileSize) {
        long rangeStart = range.getStartOffset(fileSize);
        return this.getStartOffset(fileSize) <= rangeStart && rangeStart <= this.getEndOffset(fileSize);
    }

    public String buildHTTPRangeString() {
        if (this.suffixLength == -1L) {
            return String.valueOf(this.startOffset) + '-' + String.valueOf(this.endOffset);
        }
        return '-' + String.valueOf(this.suffixLength);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RangeAvailability {
        RANGE_AVAILABLE,
        RANGE_NOT_AVAILABLE,
        RANGE_NOT_SATISFIABLE;

    }
}

