/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import phex.common.log.NLogger;
import phex.io.buffer.ByteBuffer;
import phex.msg.GGEPBlock;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.utils.HexConverter;
import phex.utils.IOUtil;

public class PingMsg
extends Message {
    private byte[] body;
    private GGEPBlock ggepBlock;
    public static final byte UDP_SCP_MASK = 1;
    public static final byte UDP_SCP_LEAF = 0;
    public static final byte UDP_SCP_ULTRAPEER = 1;

    public PingMsg(byte ttl) {
        super(new MsgHeader(0, ttl, 0));
        this.body = IOUtil.EMPTY_BYTE_ARRAY;
    }

    public PingMsg(MsgHeader aHeader, byte[] aBody) {
        super(aHeader);
        this.getHeader().setPayloadType((byte)0);
        this.body = aBody;
        this.getHeader().setDataLength(this.body.length);
    }

    public static PingMsg createUdpPingMsg(boolean isUltrapeer) {
        byte[] udpScpByteArr = new byte[]{isUltrapeer ? (byte)1 : 0};
        GGEPBlock scpExtension = new GGEPBlock(false);
        scpExtension.addExtension("SCP", udpScpByteArr);
        byte[] body = scpExtension.getBytes();
        PingMsg udpPingMsg = new PingMsg(1);
        udpPingMsg.getHeader().setDataLength(body.length);
        udpPingMsg.body = body;
        udpPingMsg.ggepBlock = scpExtension;
        NLogger.debug(PingMsg.class, "Created UDP Ping " + udpPingMsg.toString());
        return udpPingMsg;
    }

    public ByteBuffer createMessageBuffer() {
        return ByteBuffer.wrap(this.body);
    }

    public byte[] getBytes() {
        byte[] data = new byte[23 + this.body.length];
        byte[] hdr = this.getHeader().getBytes();
        System.arraycopy(hdr, 0, data, 0, 23);
        System.arraycopy(this.body, 0, data, 23, this.body.length);
        return data;
    }

    private void parseGGEPBlocks() {
        if (this.ggepBlock == null) {
            this.ggepBlock = GGEPBlock.mergeGGEPBlocks(GGEPBlock.parseGGEPBlocks(this.body, 0));
        }
    }

    public byte[] getScpByte() {
        this.parseGGEPBlocks();
        if (this.ggepBlock != null && this.ggepBlock.isExtensionAvailable("SCP")) {
            return this.ggepBlock.getExtensionData("SCP");
        }
        return null;
    }

    public String toString() {
        return "Ping[ HEX=[" + HexConverter.toHexString(this.body) + "] ]";
    }
}

