/*
 * Decompiled with CFR 0.152.
 */
package phex.msg.vendor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import phex.msg.GGEPBlock;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.MsgHeader;
import phex.msg.vendor.VendorMsg;
import phex.utils.IOUtil;

public class MessageAcknowledgementVMsg
extends VendorMsg {
    private static final Logger logger = LoggerFactory.getLogger(MessageAcknowledgementVMsg.class);
    public static final int VERSION = 3;

    public MessageAcknowledgementVMsg(MsgHeader header, byte[] vendorId, int subSelector, int version, byte[] data) throws InvalidMessageException {
        super(header, vendorId, subSelector, version, data);
        if (version != 3) {
            throw new InvalidMessageException("Vendor Message 'MessageACKVMsg' with invalid version: " + version);
        }
    }

    public MessageAcknowledgementVMsg(GUID guid, int resultCount, byte[] securityToken) {
        super(VENDORID_LIME, 11, 3, MessageAcknowledgementVMsg.buildDataBody(resultCount, securityToken));
        this.getHeader().setMsgID(guid);
    }

    private static byte[] buildDataBody(int resultCount, byte[] securityToken) {
        if (resultCount <= 0 || resultCount > 255) {
            throw new IllegalArgumentException("Invalid number of results: " + resultCount);
        }
        byte[] countBytes = new byte[2];
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtil.serializeShortLE((short)resultCount, countBytes, 0);
            out.write(countBytes[0]);
            GGEPBlock ggepBlock = new GGEPBlock(true);
            ggepBlock.addExtension("SO", securityToken);
            out.write(ggepBlock.getBytes());
            return out.toByteArray();
        }
        catch (IOException exp) {
            logger.error(exp.toString(), (Throwable)exp);
            throw new RuntimeException(exp);
        }
    }
}

