/*
 * Decompiled with CFR 0.152.
 */
package phex.msghandling;

import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import phex.bootstrap.UdpHostCacheContainer;
import phex.common.AbstractLifeCycle;
import phex.common.Environment;
import phex.common.PongCache;
import phex.common.QueryRoutingTable;
import phex.common.address.DestAddress;
import phex.host.CaughtHostsContainer;
import phex.host.Host;
import phex.host.NetworkHostsContainer;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.msg.PingMsg;
import phex.msg.PongFactory;
import phex.msg.PongMsg;
import phex.msg.PushRequestMsg;
import phex.msg.QueryMsg;
import phex.msg.QueryResponseMsg;
import phex.msg.RouteTableUpdateMsg;
import phex.msg.vendor.HopsFlowVMsg;
import phex.msg.vendor.MessageAcknowledgementVMsg;
import phex.msg.vendor.TCPConnectBackVMsg;
import phex.msg.vendor.VendorMsg;
import phex.msghandling.MessageDispatcher;
import phex.msghandling.MessageRouting;
import phex.msghandling.MessageSubscriber;
import phex.msghandling.QueryMsgRoutingHandler;
import phex.msghandling.UdpMessageDataHandler;
import phex.msghandling.UdpMessageSubscriber;
import phex.security.PhexSecurityManager;
import phex.servent.Servent;
import phex.share.SharedFilesService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageService
extends AbstractLifeCycle {
    private static final Logger logger = LoggerFactory.getLogger(MessageService.class);
    private final Servent servent;
    private final MessageRouting messageRouting;
    private final MessageDispatcher messageDispatcher;
    private final QueryMsgRoutingHandler queryMsgRoutingHandler;
    private final PongFactory pongFactory;
    private UdpMessageDataHandler udpHandler;
    private PongCache pongCache;
    private QRPUpdateTimer qrpUpdateTimer;
    private QueryRoutingTable lastSentQueryRoutingTable;
    private int numberOfTCPRedirectsSent;
    public static final int UDP_PING_PERIOD = 30000;

    public MessageService(NetworkHostsContainer netHostsContainer, CaughtHostsContainer caughtHostsContainer, UdpHostCacheContainer uhcContainer, PhexSecurityManager securityService, Servent servent) {
        if (servent == null) {
            throw new NullPointerException("Servent missing.");
        }
        this.servent = servent;
        this.pongCache = new PongCache(servent);
        this.messageRouting = new MessageRouting();
        this.pongFactory = new PongFactory(netHostsContainer, caughtHostsContainer, securityService);
        this.messageDispatcher = new MessageDispatcher(servent, this.messageRouting, this.pongFactory);
        this.queryMsgRoutingHandler = new QueryMsgRoutingHandler(servent, this.messageRouting);
        this.messageDispatcher.addMessageSubscriber(QueryMsg.class, this.queryMsgRoutingHandler);
    }

    @Override
    public void doStart() {
        this.messageDispatcher.initStats(this.servent.getStatisticsService());
        this.udpHandler = new UdpMessageDataHandler(this.servent, this.servent.getStatisticsService(), this.servent.getSharedFilesService(), this.pongFactory, this.servent.getSecurityService(), this.servent.getHostService(), this, this.servent.getUdpService());
        this.servent.getUdpService().setUdpDataHandler(this.udpHandler);
        this.qrpUpdateTimer = new QRPUpdateTimer(this.servent.getSharedFilesService());
        Environment.getInstance().scheduleTimerTask(this.qrpUpdateTimer, 10000L, 10000L);
        Environment.getInstance().scheduleTimerTask(new ResetTCPRedirectCounter(), 900000L, 900000L);
        Environment.getInstance().scheduleTimerTask(new HopsFlowTimer(), 120000L, 15000L);
    }

    public void removeRoutings(Host host) {
        this.messageRouting.removeRoutings(host);
    }

    public <T extends Message> void addMessageSubscriber(Class<T> clazz, MessageSubscriber<T> subscriber) {
        this.messageDispatcher.addMessageSubscriber(clazz, subscriber);
    }

    public <T extends Message> void removeMessageSubscriber(Class<T> clazz, MessageSubscriber<T> subscriber) {
        this.messageDispatcher.removeMessageSubscriber(clazz, subscriber);
    }

    public <T extends Message> void addUdpMessageSubscriber(Class<? extends Message> clazz, UdpMessageSubscriber<T> subscriber) {
        this.messageDispatcher.addUdpMessageSubscriber(clazz, subscriber);
    }

    public <T extends Message> void removeUdpMessageSubscriber(Class<T> clazz, UdpMessageSubscriber<T> subscriber) {
        this.messageDispatcher.removeUdpMessageSubscriber(clazz, subscriber);
    }

    protected void dispatchToUdpSubscribers(Message message, DestAddress sourceAddress) throws InvalidMessageException {
        this.messageDispatcher.dispatchToUdpSubscribers(message, sourceAddress);
    }

    public void dispatchMessage(Message message, Host sourceHost) {
        MsgHeader header = message.getHeader();
        switch (header.getPayload()) {
            case 0: {
                this.messageDispatcher.handlePing((PingMsg)message, sourceHost);
                break;
            }
            case 1: {
                this.messageDispatcher.handlePong((PongMsg)message, sourceHost);
                break;
            }
            case 64: {
                this.messageDispatcher.handlePushRequest((PushRequestMsg)message, sourceHost);
                break;
            }
            case -128: {
                this.messageDispatcher.handleQuery((QueryMsg)message, sourceHost);
                break;
            }
            case -127: {
                this.messageDispatcher.handleQueryResponse((QueryResponseMsg)message, sourceHost);
                break;
            }
            case 48: {
                this.messageDispatcher.handleRouteTableUpdate((RouteTableUpdateMsg)message, sourceHost);
                break;
            }
            case 49: 
            case 50: {
                this.messageDispatcher.handleVendorMessage((VendorMsg)message, sourceHost);
            }
        }
    }

    public void dropMessage(MsgHeader header, byte[] body, String reason, Host sourceHost) {
        this.messageDispatcher.dropMessage(header, body, reason, sourceHost);
    }

    public void updateMyQueryRouting(QueryMsg queryMsg) {
        this.messageRouting.checkAndAddToQueryRoutingTable(queryMsg.getHeader().getMsgID(), Host.LOCAL_HOST);
    }

    public void forwardMyQueryToUltrapeers(QueryMsg msg) {
        this.queryMsgRoutingHandler.forwardQueryToUltrapeers(msg, null);
    }

    public void forwardQueryToLeaves(QueryMsg msg, Host fromHost) {
        this.queryMsgRoutingHandler.forwardQueryToLeaves(msg, fromHost);
    }

    public boolean routePushMessage(PushRequestMsg message) {
        GUID clientGUID = message.getClientGUID();
        Host host = this.messageRouting.getPushRouting(clientGUID);
        if (host == null) {
            logger.debug("No PUSH route for {}.", (Object)clientGUID);
            return false;
        }
        logger.debug("Push route for {} is {}", (Object)clientGUID, (Object)host);
        host.queueMessageToSend(message);
        return true;
    }

    public void pingHost(Host host) {
        this.pingHost(host, (byte)1);
    }

    public void pingHost(Host host, byte ttl) {
        PingMsg pingMsg = new PingMsg(ttl);
        this.messageRouting.checkAndAddToPingRoutingTable(pingMsg.getHeader().getMsgID(), Host.LOCAL_HOST);
        if (logger.isDebugEnabled()) {
            logger.debug("Queueing Ping: " + pingMsg.toString() + " - " + pingMsg.getHeader().toString() + " - Host: " + host.toString());
        }
        host.queueMessageToSend(pingMsg);
    }

    public void pingHosts(byte ttl, Host[] hosts) {
        PingMsg pingMsg = new PingMsg(ttl);
        this.messageRouting.checkAndAddToPingRoutingTable(pingMsg.getHeader().getMsgID(), Host.LOCAL_HOST);
        this.forwardPing(pingMsg, Host.LOCAL_HOST, hosts);
    }

    private void forwardPing(PingMsg msg, Host fromHost, Host[] hosts) {
        for (int i = 0; i < hosts.length; ++i) {
            if (hosts[i] == fromHost) continue;
            hosts[i].queueMessageToSend(msg);
        }
    }

    public void addPongToCache(PongMsg pong) {
        this.pongCache.addPong(pong);
    }

    public List<PongMsg> getCachedPongs() {
        return this.pongCache.getPongs();
    }

    public boolean requestTCPConnectBack() {
        DestAddress localAddress = this.servent.getLocalAddress();
        TCPConnectBackVMsg tcpConnectBack = new TCPConnectBackVMsg(localAddress.getPort());
        Host[] hosts = this.servent.getHostService().getUltrapeerConnections();
        int sentCount = 0;
        for (int i = 0; sentCount <= 5 && i < hosts.length; ++i) {
            if (!hosts[i].isTCPConnectBackSupported()) continue;
            hosts[i].queueMessageToSend(tcpConnectBack);
            ++sentCount;
        }
        return sentCount > 0;
    }

    public boolean isTCPRedirectAllowed() {
        return this.numberOfTCPRedirectsSent <= 3;
    }

    public void incNumberOfTCPRedirectsSent() {
        ++this.numberOfTCPRedirectsSent;
    }

    public QueryRoutingTable getLastSentQueryRoutingTable() {
        return this.lastSentQueryRoutingTable;
    }

    public void triggerQueryRoutingTableUpdate() {
        Environment.getInstance().executeOnThreadPool(this.qrpUpdateTimer, "TriggerQueryRoutingTableUpdate");
    }

    public void sendUdpPing(DestAddress address) {
        PingMsg udpPing = PingMsg.createUdpPingMsg(this.servent.isUltrapeer());
        this.udpHandler.sendUdpPing(udpPing, address);
        logger.debug("Sent Udp Ping to" + address + " : " + udpPing + " with Scp Byte : " + udpPing.getScpByte() != null ? String.valueOf(udpPing.getScpByte()[0]) : "null");
    }

    public void sendUdpMessageAcknowledgementVMsg(GUID id, int resultCount, byte[] securityToken, DestAddress destination) {
        MessageAcknowledgementVMsg respMsg = new MessageAcknowledgementVMsg(id, resultCount, securityToken);
        this.udpHandler.sendMessageAcknowledgementVMsg(respMsg, destination);
    }

    private class QRPUpdateTimer
    extends TimerTask {
        private static final long TIMER_PERIOD = 10000L;
        private final SharedFilesService sharedFilesService;

        public QRPUpdateTimer(SharedFilesService sharedFilesService) {
            this.sharedFilesService = sharedFilesService;
        }

        public void run() {
            this.sendQueryRoutingTable();
        }

        private void sendQueryRoutingTable() {
            boolean isUltrapeer = MessageService.this.servent.isUltrapeer();
            if (!MessageService.this.servent.isShieldedLeafNode() && !isUltrapeer) {
                return;
            }
            Host[] hosts = MessageService.this.servent.getHostService().getUltrapeerConnections();
            QueryRoutingTable shareQRT = this.sharedFilesService.getLocalRoutingTable();
            QueryRoutingTable currentTable = null;
            for (int i = 0; i < hosts.length; ++i) {
                if ((!isUltrapeer ? !hosts[i].isQueryRoutingSupported() : !hosts[i].isUPQueryRoutingSupported()) || !hosts[i].isQRTableUpdateRequired()) continue;
                logger.debug("Updating QRTable for: {}", (Object)hosts[i]);
                if (currentTable == null) {
                    currentTable = new QueryRoutingTable(shareQRT.getTableSize());
                    currentTable.aggregateToRouteTable(shareQRT);
                    QueryRoutingTable.fillQRTWithLeaves(currentTable, MessageService.this.servent);
                    MessageService.this.lastSentQueryRoutingTable = currentTable;
                }
                QueryRoutingTable lastSentTable = hosts[i].getLastSentRoutingTable();
                Iterator<RouteTableUpdateMsg> msgIterator = QueryRoutingTable.buildRouteTableUpdateMsgIterator(currentTable, lastSentTable);
                while (msgIterator.hasNext()) {
                    RouteTableUpdateMsg msg = msgIterator.next();
                    hosts[i].queueMessageToSend(msg);
                }
                hosts[i].setLastSentRoutingTable(currentTable);
            }
        }
    }

    private class HopsFlowTimer
    extends TimerTask {
        private static final long TIMER_DELAY = 120000L;
        private static final long TIMER_PERIOD = 15000L;
        private boolean lastBusyState = false;

        private HopsFlowTimer() {
        }

        public void run() {
            if (!MessageService.this.servent.getHostService().isShieldedLeafNode()) {
                return;
            }
            Host[] ultrapeers = MessageService.this.servent.getHostService().getUltrapeerConnections();
            boolean isHostBusy = MessageService.this.servent.isUploadLimitReached();
            int hopsFlowLimit = isHostBusy ? 0 : 5;
            HopsFlowVMsg msg = new HopsFlowVMsg(hopsFlowLimit);
            for (int i = 0; i < ultrapeers.length; ++i) {
                if (!ultrapeers[i].isHopsFlowSupported() || isHostBusy == this.lastBusyState && !((double)ultrapeers[i].getConnectionUpTime() < 16500.0)) continue;
                ultrapeers[i].queueMessageToSend(msg);
            }
            this.lastBusyState = isHostBusy;
        }
    }

    private class ResetTCPRedirectCounter
    extends TimerTask {
        private static final long TIMER_PERIOD = 900000L;

        private ResetTCPRedirectCounter() {
        }

        public void run() {
            MessageService.this.numberOfTCPRedirectsSent = 0;
        }
    }
}

