/*
 * Decompiled with CFR 0.152.
 */
package phex.msghandling;

import phex.common.QueryRoutingTable;
import phex.host.Host;
import phex.host.NetworkHostsContainer;
import phex.msg.QueryMsg;
import phex.msghandling.MessageRouting;
import phex.msghandling.MessageSubscriber;
import phex.query.LeafGuidedSearchProgress;
import phex.servent.Servent;
import phex.utils.QueryGUIDRoutingPair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QueryMsgRoutingHandler
implements MessageSubscriber<QueryMsg> {
    private final Servent servent;
    private final MessageRouting msgRouting;
    private final NetworkHostsContainer hostsContainer;

    public QueryMsgRoutingHandler(Servent servent, MessageRouting msgRouting) {
        this.servent = servent;
        this.msgRouting = msgRouting;
        this.hostsContainer = servent.getHostService().getNetworkHostsContainer();
    }

    @Override
    public void onMessage(QueryMsg queryMsg, Host sourceHost) {
        if (this.servent.isShieldedLeafNode()) {
            return;
        }
        if (sourceHost.isUltrapeerLeafConnection()) {
            QueryGUIDRoutingPair routingPair = this.msgRouting.getQueryRouting(queryMsg.getHeader().getMsgID(), 0);
            LeafGuidedSearchProgress searchProgress = new LeafGuidedSearchProgress(routingPair, queryMsg.hasQueryURNs());
            this.servent.getQueryService().sendDynamicQuery(queryMsg, sourceHost, searchProgress);
        } else {
            if (queryMsg.getHeader().getTTL() > 0) {
                this.forwardQueryToUltrapeers(queryMsg, sourceHost);
            }
            this.forwardQueryToLeaves(queryMsg, sourceHost);
        }
    }

    public void forwardQueryToLeaves(QueryMsg msg, Host fromHost) {
        Host[] hosts = this.hostsContainer.getLeafConnections();
        for (int i = 0; i < hosts.length; ++i) {
            QueryRoutingTable qrt;
            if (hosts[i] == fromHost || (qrt = hosts[i].getLastReceivedRoutingTable()) != null && !qrt.containsQuery(msg)) continue;
            hosts[i].queueMessageToSend(msg);
        }
    }

    public void forwardQueryToUltrapeers(QueryMsg msg, Host fromHost) {
        Host[] ultrapeers = this.hostsContainer.getUltrapeerConnections();
        boolean lastHop = msg.getHeader().getTTL() == 1;
        for (int i = 0; i < ultrapeers.length; ++i) {
            QueryRoutingTable qrt;
            if (ultrapeers[i] == fromHost || lastHop && ultrapeers[i].isUPQueryRoutingSupported() && (qrt = ultrapeers[i].getLastReceivedRoutingTable()) != null && !qrt.containsQuery(msg)) continue;
            ultrapeers[i].queueMessageToSend(msg);
        }
    }
}

