/*
 * Decompiled with CFR 0.152.
 */
package phex.msghandling;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import phex.common.address.DestAddress;
import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msghandling.UdpMessageSubscriber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UdpMessageSubscriberList<E extends Message>
implements UdpMessageSubscriber<E> {
    private List<UdpMessageSubscriber<E>> subscriberList = new CopyOnWriteArrayList<UdpMessageSubscriber<E>>();

    UdpMessageSubscriberList() {
    }

    UdpMessageSubscriberList(UdpMessageSubscriber<E> subscriber1, UdpMessageSubscriber<E> subscriber2) {
        this();
        this.addSubscribers(subscriber1, subscriber2);
    }

    @Override
    public void onUdpMessage(E message, DestAddress sourceAddress) throws InvalidMessageException {
        for (UdpMessageSubscriber<E> messageSubscriber : this.subscriberList) {
            messageSubscriber.onUdpMessage(message, sourceAddress);
        }
    }

    public void addSubscriber(UdpMessageSubscriber<E> subscriber) {
        this.subscriberList.add(subscriber);
    }

    public void addSubscribers(UdpMessageSubscriber<E> ... subscriberArr) {
        this.subscriberList.addAll(Arrays.asList(subscriberArr));
    }

    public void removeSubscriber(UdpMessageSubscriber<E> subscriber) {
        this.subscriberList.remove(subscriber);
    }
}

