/*
 * Decompiled with CFR 0.152.
 */
package phex.net.server;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import phex.common.Environment;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.common.log.NLogger;
import phex.connection.IncomingConnectionDispatcher;
import phex.host.NetworkHostsContainer;
import phex.net.repres.PresentationManager;
import phex.net.repres.SocketFacade;
import phex.net.repres.def.DefaultSocketFacade;
import phex.net.server.Server;
import phex.prefs.core.NetworkPrefs;
import phex.security.AccessType;
import phex.security.PhexSecurityException;
import phex.servent.Servent;

public class OIOServer
extends Server {
    public OIOServer(Servent servent) {
        super(servent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (NLogger.isDebugEnabled(OIOServer.class)) {
            NLogger.debug(OIOServer.class, "Listener started. Listening on: " + this.serverSocket.getInetAddress().getHostAddress() + ':' + this.serverSocket.getLocalPort());
        }
        try {
            while (this.serverSocket != null && !this.serverSocket.isClosed()) {
                try {
                    Socket incoming = this.serverSocket.accept();
                    DefaultSocketFacade incomingFacade = new DefaultSocketFacade(incoming);
                    this.handleIncomingSocket(incomingFacade);
                }
                catch (SocketException exp) {
                    NLogger.debug(OIOServer.class, exp);
                }
                catch (PhexSecurityException exp) {
                    NLogger.debug(OIOServer.class, exp);
                }
                catch (IOException exp) {
                    NLogger.error(OIOServer.class, exp, exp);
                }
            }
        }
        catch (Exception exp) {
            NLogger.error(OIOServer.class, exp, exp);
        }
        this.isRunning = false;
        NLogger.debug(OIOServer.class, "Listener stopped.");
        DestAddress newAddress = PresentationManager.getInstance().createHostAddress(IpAddress.LOCAL_HOST_IP, 6346);
        this.localAddress.updateLocalAddress(newAddress);
        OIOServer oIOServer = this;
        synchronized (oIOServer) {
            this.notifyAll();
        }
    }

    private void handleIncomingSocket(SocketFacade clientSocket) throws IOException, PhexSecurityException {
        clientSocket.setSoTimeout(NetworkPrefs.TcpRWTimeout.get());
        DestAddress address = clientSocket.getRemoteAddress();
        NetworkHostsContainer netHostsContainer = this.servent.getHostService().getNetworkHostsContainer();
        IpAddress remoteIp = address.getIpAddress();
        assert (remoteIp != null);
        if (!netHostsContainer.isConnectedToHost(address) && !remoteIp.isSiteLocalIP()) {
            this.hasConnectedIncomming = true;
            this.lastInConnectionTime = System.currentTimeMillis();
        }
        AccessType access = this.servent.getSecurityService().controlHostAddressAccess(address);
        switch (access) {
            case ACCESS_DENIED: 
            case ACCESS_STRONGLY_DENIED: {
                throw new PhexSecurityException("Host access denied: " + address);
            }
        }
        NLogger.debug(OIOServer.class, "Accepted incoming connection from: " + address.getFullHostName());
        IncomingConnectionDispatcher dispatcher = new IncomingConnectionDispatcher(clientSocket, this.servent);
        Environment.getInstance().executeOnThreadPool(dispatcher, "IncomingConnectionDispatcher-" + Integer.toHexString(this.hashCode()));
    }

    protected synchronized void bind(int initialPort) throws IOException {
        boolean error;
        assert (this.serverSocket == null);
        this.serverSocket = new ServerSocket();
        int tries = 0;
        int tryingPort = initialPort;
        do {
            error = false;
            try {
                NLogger.debug(OIOServer.class, "Binding to port " + tryingPort);
                this.serverSocket.bind(new InetSocketAddress(tryingPort));
            }
            catch (SocketException exp) {
                NLogger.debug(OIOServer.class, "Binding failed to port " + tryingPort);
                if (tries > 50) {
                    throw new BindException("Failed to bind to port (" + initialPort + " - " + tryingPort + "). Last reason was: " + exp.getMessage());
                }
                error = true;
                ++tryingPort;
                ++tries;
            }
        } while (error);
        IpAddress hostIP = this.resolveLocalHostIP();
        tryingPort = this.serverSocket.getLocalPort();
        DestAddress newAddress = PresentationManager.getInstance().createHostAddress(hostIP, tryingPort);
        this.localAddress.updateLocalAddress(newAddress);
    }

    protected synchronized void closeServer() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.serverSocket = null;
        }
    }
}

