/*
 * Decompiled with CFR 0.152.
 */
package phex.prefs;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.Security;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.SystemUtils;
import phex.common.Environment;
import phex.common.PhexVersion;
import phex.common.collections.SortedProperties;
import phex.common.log.NLogger;
import phex.msg.GUID;
import phex.utils.VersionUtils;

@Deprecated
@SuppressWarnings(justification="Obsolete class will be dropped in the future.")
public class OldCfg {
    public static final String GENERAL_GNUTELLA_NETWORK = "<General Gnutella Network>";
    public static final String PRIVATE_NETWORK = null;
    public static final String PRIVATE_BUILD_ID = "";
    public static final String DEFAULT_NETWORK_TO_USE = PRIVATE_NETWORK == null ? "<General Gnutella Network>" : PRIVATE_NETWORK;
    public static final boolean DEFAULT_FORCE_TOBE_ULTRAPEER = false;
    private static final String BACKUP_CONFIG_FILENAME = "phex.bk";
    public static final int DEFAULT_SOCKS5_PORT = 1080;
    public static final int DEFAULT_HTTP_PORT = 80;
    public static final int DEFAULT_MAX_MESSAGE_LENGTH = 65536;
    public static final short DEFAULT_LOGGER_VERBOSE_LEVEL = 6;
    public static final boolean DEFAULT_ENABLE_HIT_SNOOPING = true;
    public static final boolean DEFAULT_IS_CHAT_ENABLED = true;
    public static final boolean DEFAULT_ALLOW_TO_BECOME_LEAF = true;
    public static final boolean DEFAULT_ALLOW_TO_BECOME_ULTRAPEER = true;
    public static final boolean DEFAULT_FORCE_UP_CONNECTIONS = true;
    public static final boolean DEFAULT_IS_NOVENDOR_NODE_DISCONNECTED = false;
    public static final int DEFAULT_FREELOADER_FILES = 0;
    public static final int DEFAULT_FREELOADER_SHARE_SIZE = 0;
    public static final int DEFAULT_HOST_ERROR_DISPLAY_TIME = 1000;
    public static final int DEFAULT_TTL = 7;
    public static final int DEFAULT_MAX_NETWORK_TTL = 7;
    public static final int DEFAULT_UP_2_UP_CONNECTIONS = 32;
    public static final int DEFAULT_UP_2_LEAF_CONNECTIONS = 31;
    public static final int DEFAULT_UP_2_PEER_CONNECTIONS = 0;
    public static final int DEFAULT_LEAF_2_UP_CONNECTIONS = 5;
    public static final int MAX_LEAF_2_UP_CONNECTIONS = 5;
    public static final int DEFAULT_LEAF_2_PEER_CONNECTIONS = 0;
    public static final int DEFAULT_PEER_CONNECTIONS = 4;
    public static final int DEFAULT_MAX_CONNECTTO_HISTORY_SIZE = 10;
    public static final int DEFAULT_MAX_SEARCHTERM_HISTORY_SIZE = 10;
    public static final boolean DEFAULT_ARE_PARTIAL_FILES_SHARED = true;
    private static final char LIST_PREFIX = '_';
    public static final short DEFAULT_URN_CALCUATION_MODE = 2;
    public static final short DEFAULT_THEX_CALCUATION_MODE = 2;
    public static final int DEFAULT_DYNAMIC_QUERY_MAX_TTL = 4;
    public static final int DEFAULT_MAX_DOWNLOADS_PER_IP = 1;
    public static final boolean DEFAULT_ALLOW_UPLOAD_QUEUING = true;
    public static final int DEFAULT_MAX_UPLOAD_QUEUE_SIZE = 10;
    public static final int DEFAULT_MIN_UPLOAD_QUEUE_POLL_TIME = 45;
    public static final int DEFAULT_MAX_UPLOAD_QUEUE_POLL_TIME = 120;
    public static final boolean DEFAULT_IS_DEFLATE_CONNECTION_ACCEPTED = true;
    public static final int DEFAULT_SOCKET_CONNECT_TIMEOUT = 60000;
    public static final int DEFAULT_SOCKET_RW_TIMEOUT = 60000;
    public static final int DEFAULT_MAX_CONCURRENT_CONNECT_ATTEMPTS_XP = 8;
    public static final int DEFAULT_MAX_CONCURRENT_CONNECT_ATTEMPTS_OTHERS = 50;
    public static final int DEFAULT_OFFLINE_CONNECTION_FAILURE_COUNT = 100;
    public static final int DEFAULT_LAST_SHOWN_UPDATE_INFO_ID = 0;
    public static final short DEFAULT_MAX_WORKER_PER_DOWNLOAD = 9;
    public static final short DEFAULT_MAX_TOTAL_DOWNLOAD_WORKER = 27;
    public static final int DEFAULT_MAX_WRITE_BUFFER_PER_DOWNLOAD = 131072;
    public static final int DEFAULT_MAX_TOTAL_DOWNLOAD_WRITE_BUFFER = 0x100000;
    public static final boolean DEFAULT_AUTO_READOUT_DOWNLOADED_MAGMA = true;
    public static final boolean DEFAULT_AUTO_READOUT_DOWNLOADED_METALINK = true;
    public static final boolean DEFAULT_AUTO_READOUT_DOWNLOADED_RSS = true;
    public static final short DEFAULT_OPEN_FILES_LIMIT = 0;
    public static final String DEFAULT_OTHER_OS_VIDEO_COMMAND = "xterm -e mplayer %filepath%";
    public static final String DEFAULT_OTHER_OS_IMAGE_COMMAND = "ee %filepath%";
    public static final String DEFAULT_OTHER_OS_AUDIO_COMMAND = "xterm -e mplayer %filepath%";
    public static final String DEFAULT_OTHER_OS_BROWSER_COMMAND = "mozilla -remote openURL(%filepath%,new-window)";
    public static final int UNLIMITED_BANDWIDTH = Integer.MAX_VALUE;
    public static int MIN_SEARCH_TERM_LENGTH = 2;
    public static final int INITIAL_SEGMENT_SIZE = 16384;
    public static final short SEGMENT_TRANSFER_TIME = 90;
    public static final int MINIMUM_ALLOWED_TRANSFER_RATE = 1;
    public static final int MAXIMUM_SEGMENT_SIZE = 0xA00000;
    public int initialSegmentSize;
    public int segmentTransferTime;
    public int minimumAllowedTransferRate;
    public int maximumSegmentSize;
    public GUID mProgramClientID = new GUID();
    public String mMyIP = "";
    public int mListeningPort = -1;
    public int mMaxUpload = 4;
    public int mMaxUploadPerIP = 1;
    public int mUploadMaxBandwidth = 102400;
    public int mNetMaxHostToCatch = 1000;
    public int mNetMaxSendQueue = 500;
    public int mSearchMaxConcurrent = 10;
    public int mNetMaxRate = 50000;
    public int mDownloadMaxBandwidth = 102400;
    public boolean mDownloadAutoRemoveCompleted = false;
    public boolean autoReadoutDownloadedMagma = true;
    public boolean autoReadoutDownloadedMetalink = true;
    public boolean autoReadoutDownloadedRSS = true;
    public boolean downloadSubscriptionsSilently = false;
    public String mDownloadDir = ".";
    public boolean mAutoConnect = true;
    public static final String UPDATE_URI_MAC_OSX = "magnet:?xs=http://draketo.de/magma/phex-update/phex_osx.magma&dn=phex_osx.magma";
    public static final String UPDATE_URI_WINDOWS = "magnet:?xs=http://draketo.de/magma/phex-update/phex_win.magma&dn=phex_win.magma";
    public static final String UPDATE_URI_OTHER = "magnet:?xs=http://draketo.de/magma/phex-update/phex_other.magma&dn=phex_other.magma";
    public ArrayList subscriptionMagnets;
    public static final String default_subscriptionMagnets = null;
    public boolean mAutoCleanup = true;
    public int mUploadMaxSearch = 64;
    public boolean mShareBrowseDir = true;
    public int mPushTransferTimeout = 30000;
    public String mCurrentNetwork = DEFAULT_NETWORK_TO_USE;
    public ArrayList mNetNetworkHistory = new ArrayList();
    public boolean mAutoJoin = true;
    public boolean mDisconnectApplyPolicy = false;
    public int mDisconnectDropRatio = 70;
    public boolean mProxyUse = false;
    public String mProxyHost = "";
    public int mProxyPort = 1080;
    public boolean useProxyAuthentication = false;
    public String mProxyUserName = "";
    public String mProxyPassword = "";
    @Deprecated
    public String mUploadDir = "";
    @Deprecated
    public String mUploadFileExclusions = "";
    @Deprecated
    public String mUploadFileInclusions = "*";
    public boolean mUploadAutoRemoveCompleted = false;
    public HashSet sharedDirectoriesSet;
    public ArrayList libraryExclusionRegExList;
    public short urnCalculationMode;
    public short thexCalculationMode;
    public boolean monitorSearchHistory = false;
    public String searchMonitorFile = "";
    public int searchHistoryLength = 10;
    public boolean connectedToLAN = true;
    public boolean minimizeToBackground = true;
    public boolean showCloseOptionsDialog = true;
    public String incompleteDir = ".";
    public ArrayList filteredCatcherPorts = new ArrayList();
    public short maxWorkerPerDownload;
    public short maxTotalDownloadWorker;
    public int maxWriteBufferPerDownload;
    public int maxTotalDownloadWriteBuffer;
    public boolean allowUploadQueuing;
    public int maxUploadQueueSize;
    public int minUploadQueuePollTime;
    public int maxUploadQueuePollTime;
    public int maxDownloadsPerIP;
    public int networkSpeedKbps = 256;
    public int maxTotalBandwidth = 16384;
    public String runningPhexVersion = "";
    public String runningBuildNumber = "";
    public boolean isHttpProxyUsed = false;
    public String httpProxyHost = "";
    public int httpProxyPort = 80;
    public String lastUpdateCheckVersion = "0";
    public String lastBetaUpdateCheckVersion = "0";
    public long lastUpdateCheckTime = 0L;
    public boolean showBetaUpdateNotification = false;
    public int socketConnectTimeout;
    public int socketRWTimeout;
    public int maxConcurrentConnectAttempts;
    public int mNetConnectionTimeout = 8000;
    public int searchRetryTimeout = 30000;
    public long downloadCandidateLogBufferSize = 0L;
    public long uploadStateLogBufferSize = 0L;
    public boolean enableHitSnooping;
    public int maxMessageLength;
    public boolean isChatEnabled;
    public boolean allowToBecomeLeaf;
    public boolean forceUPConnections;
    public boolean allowToBecomeUP;
    public boolean forceToBeUltrapeer;
    public int up2upConnections;
    public int up2leafConnections;
    public int up2peerConnections;
    public int leaf2upConnections;
    public int leaf2peerConnections;
    public int peerConnections;
    public boolean hasConnectedIncomming;
    public int offlineConnectionFailureCount;
    public boolean isNoVendorNodeDisconnected;
    public int freeloaderFiles;
    public int freeloaderShareSize;
    public int hostErrorDisplayTime;
    public int ttl;
    public int maxNetworkTTL;
    public ArrayList connectToHistory;
    public int maxConnectToHistorySize;
    public ArrayList searchTermHistory;
    public ArrayList browseHostHistory;
    public int openFilesLimit;
    public String otherOsVideoCommand;
    public String otherOsImageCommand;
    public String otherOsAudioCommand;
    public String otherOsBrowserCommand;
    public boolean copyBeforePreviewing;
    public static final boolean DEFAULT_COPY_BEFORE_PREVIEWING = true;
    public HashMap previewMethod;
    public String fallbackPreviewMethod;
    public static final String DEFAULT_FALLBACK_PREVIEW_METHOD = "";
    public String completionNotifyMethod;
    public long segmentMultiple;
    public static final long DEFAULT_SEGMENT_MULTIPLE = 4096L;
    public int maxSearchTermHistorySize;
    public boolean arePartialFilesShared;
    public long movingTotalUptime;
    public int movingTotalUptimeCount;
    public long maximalUptime;
    public long lastShutdownTime;
    public float fractionalUptime;
    public int totalStartupCounter;
    public boolean isDeflateConnectionAccepted;
    public int lastShownUpdateInfoId;
    public int totalDownloadCount;
    public int totalUploadCount;
    public String usedLocale;
    private File configFile;
    private Properties mSetting;

    public OldCfg(File cfgFile) {
        this.configFile = cfgFile;
        this.mSetting = new SortedProperties();
    }

    public void load() {
        this.loadDefaultValues();
        try {
            FileInputStream is = new FileInputStream(this.configFile);
            this.mSetting.load(is);
            is.close();
        }
        catch (FileNotFoundException exp) {
            try {
                FileInputStream is2 = new FileInputStream(new File(this.configFile.getParentFile(), BACKUP_CONFIG_FILENAME));
                this.mSetting.load(is2);
                is2.close();
                NLogger.error(OldCfg.class, "Loading configuration from backup file");
            }
            catch (FileNotFoundException exp2) {
            }
            catch (Exception exp2) {
                NLogger.error(OldCfg.class, exp2, exp2);
            }
        }
        catch (Exception exp) {
            NLogger.error(OldCfg.class, exp, exp);
        }
        this.deserializeSimpleFields();
        this.deserializeComplexFields();
        this.handlePhexVersionAdjustments();
        if (this.mListeningPort == -1 || this.mListeningPort > 65500) {
            Random random = new Random(System.currentTimeMillis());
            this.mListeningPort = random.nextInt(60000);
            this.mListeningPort += 4000;
        }
        this.updateSystemSettings();
        ++this.totalStartupCounter;
        File dir = new File(this.mDownloadDir);
        dir.mkdirs();
        dir = new File(this.incompleteDir);
        dir.mkdirs();
    }

    private void loadDefaultValues() {
        this.maxDownloadsPerIP = 1;
        this.enableHitSnooping = true;
        this.maxMessageLength = 65536;
        this.isChatEnabled = true;
        this.allowToBecomeLeaf = true;
        this.forceUPConnections = true;
        this.forceToBeUltrapeer = false;
        this.allowToBecomeUP = true;
        this.isNoVendorNodeDisconnected = false;
        this.freeloaderFiles = 0;
        this.freeloaderShareSize = 0;
        this.hostErrorDisplayTime = 1000;
        this.ttl = 7;
        this.maxNetworkTTL = 7;
        this.up2upConnections = 32;
        this.up2leafConnections = 31;
        this.up2peerConnections = 0;
        this.leaf2upConnections = 5;
        this.leaf2peerConnections = 0;
        this.peerConnections = 4;
        this.arePartialFilesShared = true;
        this.allowUploadQueuing = true;
        this.maxUploadQueueSize = 10;
        this.minUploadQueuePollTime = 45;
        this.maxUploadQueuePollTime = 120;
        this.isDeflateConnectionAccepted = true;
        this.lastShownUpdateInfoId = 0;
        this.initialSegmentSize = 16384;
        this.segmentTransferTime = 90;
        this.minimumAllowedTransferRate = 1;
        this.maximumSegmentSize = 0xA00000;
        this.urnCalculationMode = (short)2;
        this.thexCalculationMode = (short)2;
        this.fallbackPreviewMethod = "";
        this.otherOsAudioCommand = "xterm -e mplayer %filepath%";
        this.otherOsImageCommand = DEFAULT_OTHER_OS_IMAGE_COMMAND;
        this.otherOsBrowserCommand = DEFAULT_OTHER_OS_BROWSER_COMMAND;
        this.otherOsVideoCommand = "xterm -e mplayer %filepath%";
        this.completionNotifyMethod = null;
        this.copyBeforePreviewing = true;
        this.segmentMultiple = 4096L;
        this.socketConnectTimeout = 60000;
        this.socketRWTimeout = 60000;
        this.offlineConnectionFailureCount = 100;
        this.maxWorkerPerDownload = (short)9;
        this.maxTotalDownloadWorker = (short)27;
        this.maxWriteBufferPerDownload = 131072;
        this.maxTotalDownloadWriteBuffer = 0x100000;
        this.autoReadoutDownloadedMagma = true;
        this.autoReadoutDownloadedMetalink = true;
        this.autoReadoutDownloadedRSS = true;
        this.maxConnectToHistorySize = 10;
        this.maxSearchTermHistorySize = 10;
        this.maxConcurrentConnectAttempts = SystemUtils.IS_OS_WINDOWS_XP ? 8 : 50;
        this.totalStartupCounter = 0;
    }

    private String get(String key) {
        String value = (String)this.mSetting.get(key);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    private void deserializeSimpleFields() {
        Field[] fields = this.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            String name = fields[i].getName();
            int modifiers = fields[i].getModifiers();
            Class<?> type = fields[i].getType();
            String value = "";
            if (!Modifier.isPublic(modifiers) || Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers)) continue;
            try {
                if (this.deserialiseMap(fields[i])) {
                    continue;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                if (this.deserialiseList(fields[i])) {
                    continue;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                if (this.deserialiseSet(fields[i])) {
                    continue;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                value = this.get(name);
                if (value == null) {
                    try {
                        value = (String)this.getClass().getDeclaredField("default_" + fields[i].getName()).get(this);
                    }
                    catch (NoSuchFieldException exp) {
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (value == null) continue;
                if (type.getName().equals("int")) {
                    fields[i].setInt(this, Integer.parseInt(value));
                    continue;
                }
                if (type.getName().equals("short")) {
                    fields[i].setShort(this, Short.parseShort(value));
                    continue;
                }
                if (type.getName().equals("long")) {
                    fields[i].setLong(this, Long.parseLong(value));
                    continue;
                }
                if (type.getName().equals("float")) {
                    fields[i].setFloat(this, Float.parseFloat(value));
                    continue;
                }
                if (type.getName().equals("boolean")) {
                    fields[i].setBoolean(this, value.equals("true"));
                    continue;
                }
                if (!type.getName().equals("java.lang.String")) continue;
                fields[i].set(this, value);
                continue;
            }
            catch (Exception exp) {
                NLogger.error(OldCfg.class, "Error in field: " + name + ", value: " + value, exp);
            }
        }
    }

    private boolean deserialiseMap(Field myField) {
        boolean isMap = false;
        try {
            if (myField.getType().getName().equals("java.util.HashMap")) {
                myField.set(this, new HashMap());
                Map myMap = (Map)myField.get(this);
                String prefix = myField.getName() + '_';
                Enumeration<?> e = this.mSetting.propertyNames();
                while (e.hasMoreElements()) {
                    String key;
                    String foundName = (String)e.nextElement();
                    if (!foundName.startsWith(prefix) || (key = foundName.substring(prefix.length())).length() <= 0 || this.mSetting.getProperty(foundName).length() <= 0) continue;
                    myMap.put(key, this.mSetting.getProperty(foundName));
                }
                isMap = true;
            }
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            isMap = false;
        }
        return isMap;
    }

    private boolean deserialiseList(Field myField) {
        boolean isList;
        block7: {
            isList = false;
            try {
                String value;
                if (!myField.getType().getName().equals("java.util.ArrayList")) break block7;
                myField.set(this, new ArrayList());
                List myList = (List)myField.get(this);
                int index = 1;
                while ((value = this.get(myField.getName() + '_' + index)) != null && value.length() > 0) {
                    myList.add(value);
                    ++index;
                }
                if (index == 1) {
                    try {
                        Object defaultValue = this.getClass().getDeclaredField("default_" + myField.getName()).get(this);
                        String buffer = (String)defaultValue;
                        StringTokenizer tokens = new StringTokenizer(buffer, "|");
                        while (tokens.hasMoreTokens()) {
                            myList.add(tokens.nextToken());
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                isList = true;
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
                isList = false;
            }
        }
        return isList;
    }

    private boolean deserialiseSet(Field myField) {
        boolean isSet = false;
        try {
            if (myField.getType().getName().equals("java.util.HashSet")) {
                myField.set(this, new HashSet());
                Set mySet = (Set)myField.get(this);
                String prefix = new String(myField.getName() + '_' + "SET");
                Enumeration<?> e = this.mSetting.propertyNames();
                while (e.hasMoreElements()) {
                    String foundName = (String)e.nextElement();
                    if (!foundName.startsWith(prefix) || this.mSetting.getProperty(foundName).length() <= 0) continue;
                    mySet.add(this.mSetting.getProperty(foundName));
                }
                isSet = true;
            }
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
            isSet = false;
        }
        return isSet;
    }

    private void deserializeComplexFields() {
        try {
            try {
                this.mProgramClientID.fromHexString(this.get("mProgramClientID"));
            }
            catch (Exception e) {}
        }
        catch (Exception exp) {
            NLogger.error(OldCfg.class, exp, exp);
        }
    }

    public void updateSystemSettings() {
        System.setProperty("http.agent", Environment.getInstance().getPhexVendor());
        if (this.isHttpProxyUsed) {
            System.setProperty("http.proxyHost", this.httpProxyHost);
            System.setProperty("http.proxyPort", String.valueOf(this.httpProxyPort));
        } else {
            System.setProperty("http.proxyHost", "");
            System.setProperty("http.proxyPort", "");
        }
        System.setProperty("networkaddress.cache.ttl", "1800");
        Security.setProperty("networkaddress.cache.ttl", "1800");
    }

    private void handlePhexVersionAdjustments() {
        if (!(this.runningPhexVersion != null && this.runningPhexVersion.length() != 0 || this.runningBuildNumber != null && this.runningBuildNumber.length() != 0)) {
            this.updatesForBuild78();
        } else {
            if (this.runningBuildNumber == null || this.runningBuildNumber.length() == 0) {
                this.runningBuildNumber = "35";
            }
            if (VersionUtils.compare("78", this.runningBuildNumber) > 0) {
                this.updatesForBuild78();
            }
            if (VersionUtils.compare("81", this.runningBuildNumber) > 0) {
                this.updatesForBuild81();
            }
            if (VersionUtils.compare("87", this.runningBuildNumber) > 0) {
                this.updatesForBuild87();
            }
            if (VersionUtils.compare("88", this.runningBuildNumber) > 0) {
                this.updatesForBuild88();
            }
            if (VersionUtils.compare("92", this.runningBuildNumber) > 0) {
                this.updatesForBuild92();
            }
        }
        this.runningBuildNumber = PhexVersion.getBuild();
        this.runningPhexVersion = PhexVersion.getVersion();
    }

    private void updatesForBuild78() {
        this.runningBuildNumber = "78";
        this.u78("mNetNetworkHistory", " ");
        this.u78("filteredCatcherPorts", " ");
        this.u78("connectToHistory", " ");
        this.u78("searchTermHistory", ",");
    }

    private void u78(String variable, String delim) {
        String buffer = this.get(variable);
        try {
            if (buffer != null) {
                List myList = (List)this.getClass().getDeclaredField(variable).get(this);
                StringTokenizer tokens = new StringTokenizer(buffer, delim);
                while (tokens.hasMoreTokens()) {
                    myList.add(tokens.nextToken());
                }
            }
        }
        catch (NoSuchFieldException ex) {
            throw new Error("No such field: " + variable + "!");
        }
        catch (IllegalAccessException ex) {
            throw new Error("Cannot convert " + variable + " to a list!!");
        }
    }

    private void updatesForBuild81() {
        this.runningBuildNumber = "81";
        StringTokenizer tokens = new StringTokenizer(this.mUploadDir, ";");
        while (tokens.hasMoreTokens()) {
            File dir = new File(tokens.nextToken().trim());
            if (this.sharedDirectoriesSet.contains(dir.getAbsolutePath())) continue;
            this.sharedDirectoriesSet.add(dir.getAbsolutePath());
        }
    }

    private void updatesForBuild87() {
        this.runningBuildNumber = "87";
        if (this.leaf2upConnections > 5) {
            this.leaf2upConnections = 5;
        }
    }

    private void updatesForBuild88() {
        this.runningBuildNumber = "88";
        if (this.totalStartupCounter < this.movingTotalUptimeCount) {
            this.totalStartupCounter = this.movingTotalUptimeCount;
        }
    }

    private void updatesForBuild92() {
        this.runningBuildNumber = "92";
        this.allowToBecomeLeaf = true;
        this.forceUPConnections = true;
        this.up2peerConnections = 0;
        this.leaf2peerConnections = 0;
    }
}

