/*
 * Decompiled with CFR 0.152.
 */
package phex.prefs.core;

import phex.common.Environment;
import phex.common.PhexVersion;
import phex.prefs.OldCfg;
import phex.prefs.api.Preferences;
import phex.prefs.core.BandwidthPrefs;
import phex.prefs.core.ConnectionPrefs;
import phex.prefs.core.DownloadPrefs;
import phex.prefs.core.FilePrefs;
import phex.prefs.core.LibraryPrefs;
import phex.prefs.core.MessagePrefs;
import phex.prefs.core.NetworkPrefs;
import phex.prefs.core.ProxyPrefs;
import phex.prefs.core.SecurityPrefs;
import phex.prefs.core.StatisticPrefs;
import phex.prefs.core.SubscriptionPrefs;
import phex.prefs.core.UpdatePrefs;
import phex.prefs.core.UploadPrefs;
import phex.utils.StringUtils;

public class PhexCorePrefs
extends Preferences {
    protected static final PhexCorePrefs instance = new PhexCorePrefs();

    protected PhexCorePrefs() {
        super(Environment.getInstance().getPhexConfigFile("phexCorePrefs.properties"));
    }

    public static void init() {
        instance.load();
        instance.updatePreferences();
        StatisticPrefs.TotalStartupCounter.set(StatisticPrefs.TotalStartupCounter.get() + 1);
    }

    public static void save(boolean force) {
        if (force) {
            instance.saveRequiredNotify();
        }
        instance.save();
    }

    public void updatePreferences() {
        if (StringUtils.isEmpty(UpdatePrefs.RunningBuildNumber.get())) {
            // empty if block
        }
        UpdatePrefs.RunningBuildNumber.set(PhexVersion.getBuild());
        UpdatePrefs.RunningPhexVersion.set(PhexVersion.getVersion());
    }

    public static void updatePreV30Config(OldCfg cfg) {
        NetworkPrefs.ServentGuid.set(cfg.mProgramClientID.toHexString());
        NetworkPrefs.ListeningPort.set(cfg.mListeningPort);
        NetworkPrefs.CurrentNetwork.set(cfg.mCurrentNetwork);
        NetworkPrefs.NetworkHistory.set(cfg.mNetNetworkHistory);
        NetworkPrefs.ConnectedToLAN.set(cfg.connectedToLAN);
        NetworkPrefs.TcpConnectTimeout.set(cfg.socketConnectTimeout);
        NetworkPrefs.TcpRWTimeout.set(cfg.socketRWTimeout);
        NetworkPrefs.MaxConcurrentConnectAttempts.set(cfg.maxConcurrentConnectAttempts);
        NetworkPrefs.MaxHostInHostCache.set(cfg.mNetMaxHostToCatch);
        NetworkPrefs.AllowChatConnection.set(cfg.isChatEnabled);
        ConnectionPrefs.AutoConnectOnStartup.set(cfg.mAutoConnect);
        ConnectionPrefs.AllowToBecomeUP.set(cfg.allowToBecomeUP);
        ConnectionPrefs.ForceToBeUltrapeer.set(cfg.forceToBeUltrapeer);
        ConnectionPrefs.Up2UpConnections.set(cfg.up2upConnections);
        ConnectionPrefs.Up2LeafConnections.set(cfg.up2leafConnections);
        ConnectionPrefs.Leaf2UpConnections.set(cfg.leaf2upConnections);
        ConnectionPrefs.HasConnectedIncomming.set(cfg.hasConnectedIncomming);
        ConnectionPrefs.OfflineConnectionFailureCount.set(cfg.offlineConnectionFailureCount);
        ConnectionPrefs.EnableQueryHitSnooping.set(cfg.enableHitSnooping);
        ConnectionPrefs.AcceptDeflateConnection.set(cfg.isDeflateConnectionAccepted);
        MessagePrefs.MaxLength.set(cfg.maxMessageLength);
        MessagePrefs.MaxNetworkTTL.set(cfg.maxNetworkTTL);
        MessagePrefs.TTL.set(cfg.ttl);
        DownloadPrefs.DestinationDirectory.set(cfg.mDownloadDir);
        DownloadPrefs.IncompleteDirectory.set(cfg.incompleteDir);
        DownloadPrefs.MaxWorkerPerDownload.set(Integer.valueOf(cfg.maxWorkerPerDownload));
        DownloadPrefs.MaxTotalDownloadWorker.set(Integer.valueOf(cfg.maxTotalDownloadWorker));
        DownloadPrefs.MaxWriteBufferPerDownload.set(cfg.maxWriteBufferPerDownload);
        DownloadPrefs.MaxTotalDownloadWriteBuffer.set(cfg.maxTotalDownloadWriteBuffer);
        DownloadPrefs.MaxDownloadsPerIP.set(cfg.maxDownloadsPerIP);
        DownloadPrefs.SegmentInitialSize.set(cfg.initialSegmentSize);
        DownloadPrefs.SegmentTransferTargetTime.set(cfg.segmentTransferTime);
        DownloadPrefs.SegmentMaximumSize.set(cfg.maximumSegmentSize);
        DownloadPrefs.SegmentMultiple.set((int)cfg.segmentMultiple);
        DownloadPrefs.CandidateMinAllowedTransferRate.set(cfg.minimumAllowedTransferRate);
        DownloadPrefs.CandidateLogBufferSize.set((int)cfg.downloadCandidateLogBufferSize);
        DownloadPrefs.PushRequestTimeout.set(cfg.mPushTransferTimeout);
        DownloadPrefs.AutoReadoutMagmaFiles.set(cfg.autoReadoutDownloadedMagma);
        DownloadPrefs.AutoReadoutMetalinkFiles.set(cfg.autoReadoutDownloadedMetalink);
        DownloadPrefs.AutoReadoutRSSFiles.set(cfg.autoReadoutDownloadedRSS);
        DownloadPrefs.AutoRemoveCompleted.set(cfg.mDownloadAutoRemoveCompleted);
        UploadPrefs.MaxParallelUploads.set(cfg.mMaxUpload);
        UploadPrefs.MaxUploadsPerIP.set(cfg.mMaxUploadPerIP);
        UploadPrefs.AutoRemoveCompleted.set(cfg.mUploadAutoRemoveCompleted);
        UploadPrefs.SharePartialFiles.set(cfg.arePartialFilesShared);
        UploadPrefs.AllowQueuing.set(cfg.allowUploadQueuing);
        UploadPrefs.MaxQueueSize.set(cfg.maxUploadQueueSize);
        UploadPrefs.MinQueuePollTime.set(cfg.minUploadQueuePollTime);
        UploadPrefs.MaxQueuePollTime.set(cfg.maxUploadQueuePollTime);
        UploadPrefs.UploadStateLogBufferSize.set((int)cfg.uploadStateLogBufferSize);
        BandwidthPrefs.NetworkSpeedKbps.set(cfg.networkSpeedKbps);
        BandwidthPrefs.MaxTotalBandwidth.set(cfg.maxTotalBandwidth);
        BandwidthPrefs.MaxNetworkBandwidth.set(cfg.mNetMaxRate);
        BandwidthPrefs.MaxDownloadBandwidth.set(cfg.mDownloadMaxBandwidth);
        BandwidthPrefs.MaxUploadBandwidth.set(cfg.mUploadMaxBandwidth);
        LibraryPrefs.SharedDirectoriesSet.set(cfg.sharedDirectoriesSet);
        LibraryPrefs.LibraryExclusionRegExList.set(cfg.libraryExclusionRegExList);
        LibraryPrefs.UrnCalculationMode.set(Integer.valueOf(cfg.urnCalculationMode));
        LibraryPrefs.ThexCalculationMode.set(Integer.valueOf(cfg.thexCalculationMode));
        LibraryPrefs.AllowBrowsing.set(cfg.mShareBrowseDir);
        SecurityPrefs.FilteredPorts.set(cfg.filteredCatcherPorts);
        ProxyPrefs.ForcedIp.set(cfg.mMyIP);
        ProxyPrefs.UseSocks5.set(cfg.mProxyUse);
        ProxyPrefs.Socks5Host.set(cfg.mProxyHost);
        ProxyPrefs.Socks5Port.set(cfg.mProxyPort);
        ProxyPrefs.Socks5Authentication.set(cfg.useProxyAuthentication);
        ProxyPrefs.Socks5User.set(cfg.mProxyUserName);
        ProxyPrefs.Socks5Password.set(cfg.mProxyPassword);
        ProxyPrefs.UseHttp.set(cfg.isHttpProxyUsed);
        ProxyPrefs.HttpHost.set(cfg.httpProxyHost);
        ProxyPrefs.HttpPort.set(cfg.httpProxyPort);
        StatisticPrefs.FractionalUptime.set(Float.valueOf(cfg.fractionalUptime));
        StatisticPrefs.LastShutdownTime.set(cfg.lastShutdownTime);
        StatisticPrefs.MaximalUptime.set(cfg.maximalUptime);
        StatisticPrefs.MovingTotalUptime.set(cfg.movingTotalUptime);
        StatisticPrefs.MovingTotalUptimeCount.set(cfg.movingTotalUptimeCount);
        StatisticPrefs.TotalDownloadCount.set(cfg.totalDownloadCount);
        StatisticPrefs.TotalStartupCounter.set(cfg.totalStartupCounter);
        StatisticPrefs.TotalUploadCount.set(cfg.totalUploadCount);
        UpdatePrefs.LastUpdateCheckVersion.set(cfg.lastUpdateCheckVersion);
        UpdatePrefs.LastBetaUpdateCheckVersion.set(cfg.lastBetaUpdateCheckVersion);
        UpdatePrefs.LastUpdateCheckTime.set(cfg.lastUpdateCheckTime);
        UpdatePrefs.LastShownUpdateInfoId.set(cfg.lastShownUpdateInfoId);
        FilePrefs.OpenFilesLimit.set(cfg.openFilesLimit);
        SubscriptionPrefs.DownloadSilently.set(cfg.downloadSubscriptionsSilently);
        SubscriptionPrefs.SubscriptionMagnets.set(cfg.subscriptionMagnets);
    }
}

