/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bushe.swing.event.annotation.EventTopicSubscriber;
import phex.common.address.DestAddress;
import phex.event.ChangeEvent;
import phex.event.ContainerEvent;
import phex.host.Host;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msg.QueryFactory;
import phex.msg.QueryResponseMsg;
import phex.msg.vendor.OOBReplyCountVMsg;
import phex.msghandling.MessageSubscriber;
import phex.msghandling.UdpMessageSubscriber;
import phex.query.BrowseHostResults;
import phex.query.KeywordSearch;
import phex.query.QuerySearch;
import phex.query.Search;
import phex.query.WhatsNewSearch;
import phex.servent.OnlineStatus;
import phex.servent.Servent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchContainer
implements MessageSubscriber<QueryResponseMsg>,
UdpMessageSubscriber<Message> {
    protected final Servent servent;
    protected final QueryFactory queryFactory;
    protected final List<Search> searchList;
    protected final HashMap<GUID, Search> idSearchMap;

    public SearchContainer(QueryFactory queryFactory, Servent servent) {
        this.servent = servent;
        this.queryFactory = queryFactory;
        this.searchList = new ArrayList<Search>();
        this.idSearchMap = new HashMap();
        servent.getEventService().processAnnotations(this);
    }

    public synchronized Search createSearch(String queryStr) {
        KeywordSearch search = new KeywordSearch(queryStr, this.queryFactory, this.servent);
        this.insertToSearchList(search, 0);
        return search;
    }

    public synchronized Search createWhatsNewSearch() {
        WhatsNewSearch search = new WhatsNewSearch(this.queryFactory, this.servent);
        this.insertToSearchList(search, 0);
        return search;
    }

    public synchronized BrowseHostResults createBrowseHostSearch(DestAddress hostAddress, GUID hostGUID) {
        BrowseHostResults search = new BrowseHostResults(this.servent, hostAddress, hostGUID);
        this.insertToSearchList(search, 0);
        return search;
    }

    protected synchronized void insertToSearchList(Search search, int position) {
        this.searchList.add(position, search);
        this.fireSearchAdded(search, position);
    }

    protected synchronized void removeFromSearchList(int index) {
        Search search = this.getSearchAt(index);
        search.stopSearching();
        this.searchList.remove(index);
        this.fireSearchRemoved(search, index);
    }

    public synchronized Search getRunningKeywordSearch(String searchString) {
        for (Search search : this.searchList) {
            if (search.isSearchFinished() || !(search instanceof KeywordSearch) || !((KeywordSearch)search).getSearchString().equals(searchString)) continue;
            return search;
        }
        return null;
    }

    public synchronized Search getRunningBrowseHost(DestAddress hostAddress, GUID hostId) {
        for (Search search : this.searchList) {
            if (search.isSearchFinished() || !(search instanceof BrowseHostResults)) continue;
            BrowseHostResults browseHost = (BrowseHostResults)search;
            DestAddress destAddress = browseHost.getDestAddress();
            GUID hostGUID = browseHost.getHostGUID();
            if ((destAddress == null || !destAddress.equals(hostAddress)) && (hostGUID == null || !hostGUID.equals(hostId))) continue;
            return search;
        }
        return null;
    }

    public synchronized int getSearchCount() {
        return this.searchList.size();
    }

    public synchronized int getIndexOfSearch(Search search) {
        int size = this.searchList.size();
        for (int i = 0; i < size; ++i) {
            if (search != this.searchList.get(i)) continue;
            return i;
        }
        return -1;
    }

    public synchronized Search getSearchAt(int index) {
        if (index < 0 || index >= this.getSearchCount()) {
            return null;
        }
        return this.searchList.get(index);
    }

    public synchronized void removeSearch(Search search) {
        int index = this.searchList.indexOf(search);
        if (index >= 0) {
            this.removeFromSearchList(index);
        }
    }

    public synchronized void removeSearch(int index) {
        this.removeFromSearchList(index);
    }

    public synchronized void stopExpiredSearches(long currentTime) {
        for (int i = 0; i < this.searchList.size(); ++i) {
            this.searchList.get(i).isSearchFinished();
        }
    }

    private synchronized void stopAllSearches() {
        for (int i = 0; i < this.searchList.size(); ++i) {
            this.searchList.get(i).stopSearching();
        }
    }

    public synchronized void removeAllSearches() {
        for (int i = this.searchList.size() - 1; i >= 0; --i) {
            this.removeFromSearchList(i);
        }
    }

    @Override
    public void onMessage(QueryResponseMsg message, Host sourceHost) throws InvalidMessageException {
        for (int i = 0; i < this.searchList.size(); ++i) {
            Search search = this.searchList.get(i);
            if (search instanceof BrowseHostResults) continue;
            search.processResponse(message);
        }
    }

    @Override
    public void onUdpMessage(Message message, DestAddress sourceAddress) throws InvalidMessageException {
        block3: {
            block2: {
                if (!(message instanceof OOBReplyCountVMsg)) break block2;
                for (int i = 0; i < this.searchList.size(); ++i) {
                    Search search = this.searchList.get(i);
                    if (!(search instanceof QuerySearch)) continue;
                    ((QuerySearch)search).processOOBReplyCountResponse((OOBReplyCountVMsg)message, sourceAddress);
                }
                break block3;
            }
            if (!(message instanceof QueryResponseMsg)) break block3;
            for (int i = 0; i < this.searchList.size(); ++i) {
                Search search = this.searchList.get(i);
                if (!(search instanceof QuerySearch)) continue;
                ((QuerySearch)search).processOOBResponse((QueryResponseMsg)message, sourceAddress);
            }
        }
    }

    protected void fireSearchAdded(Search search, int position) {
        this.servent.getEventService().publish("phex:search/update", new ContainerEvent(ContainerEvent.Type.ADDED, search, this, position));
    }

    protected void fireSearchRemoved(Search search, int position) {
        this.servent.getEventService().publish("phex:search/update", new ContainerEvent(ContainerEvent.Type.REMOVED, search, this, position));
    }

    @EventTopicSubscriber(topic="phex:servent/onlineStatus")
    public void onOnlineStatusEvent(String topic, ChangeEvent event) {
        OnlineStatus oldStatus = (OnlineStatus)((Object)event.getOldValue());
        OnlineStatus newStatus = (OnlineStatus)((Object)event.getNewValue());
        if (newStatus == OnlineStatus.OFFLINE && oldStatus != OnlineStatus.OFFLINE) {
            this.stopAllSearches();
        }
    }
}

