/*
 * Decompiled with CFR 0.152.
 */
package phex.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import phex.download.RemoteFile;
import phex.query.Search;
import phex.rules.condition.AndConcatCondition;
import phex.rules.condition.Condition;
import phex.rules.consequence.Consequence;
import phex.servent.Servent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rule
implements Cloneable {
    private String name;
    private String description;
    private String id;
    private boolean isPermanentlyEnabled;
    private boolean isDefaultRule;
    private AndConcatCondition ruleCondition = new AndConcatCondition();
    private List<Consequence> consequences = new ArrayList<Consequence>();

    public boolean isDefaultRule() {
        return this.isDefaultRule;
    }

    public void setDefaultRule(boolean isDefaultRule) {
        this.isDefaultRule = isDefaultRule;
    }

    public boolean isPermanentlyEnabled() {
        return this.isPermanentlyEnabled;
    }

    public void setPermanentlyEnabled(boolean isPermanentlyEnabled) {
        this.isPermanentlyEnabled = isPermanentlyEnabled;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<Condition> getConditions() {
        return this.ruleCondition.getConditions();
    }

    public void clearConditions() {
        this.ruleCondition.clearConditions();
    }

    public Rule addCondition(Condition condition) {
        this.ruleCondition.addCondition(condition);
        return this;
    }

    public Rule removeCondition(Condition condition) {
        this.ruleCondition.removeCondition(condition);
        return this;
    }

    public List<Consequence> getConsequences() {
        return Collections.unmodifiableList(this.consequences);
    }

    public void addConsequence(Consequence consequence) {
        this.consequences.add(consequence);
    }

    public Rule removeConsequence(Consequence consequence) {
        this.consequences.remove(consequence);
        return this;
    }

    public void process(Search search, RemoteFile[] remoteFiles, Servent servent) {
        for (int i = 0; i < remoteFiles.length; ++i) {
            boolean isMatched;
            if (remoteFiles[i].isFilteredRemoved() || !(isMatched = this.ruleCondition.isMatched(search, remoteFiles[i]))) continue;
            for (Consequence conseq : this.consequences) {
                conseq.invoke(search, remoteFiles[i], servent);
            }
        }
    }

    public Object clone() {
        try {
            Rule clone = (Rule)super.clone();
            clone.ruleCondition = (AndConcatCondition)this.ruleCondition.clone();
            clone.consequences = new ArrayList<Consequence>();
            for (Consequence conseq : this.consequences) {
                clone.consequences.add((Consequence)conseq.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException exp) {
            throw new InternalError();
        }
    }

    public String toString() {
        return super.toString() + "[Condition: " + this.ruleCondition.toString() + "]";
    }
}

