/*
 * Decompiled with CFR 0.152.
 */
package phex.rules.condition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.set.ListOrderedSet;
import phex.common.URN;
import phex.download.RemoteFile;
import phex.query.Search;
import phex.rules.condition.Condition;
import phex.xml.sax.rules.DCondition;
import phex.xml.sax.rules.DFileUrnCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUrnCondition
implements Condition {
    private ListOrderedSet urnSet = new ListOrderedSet();

    public FileUrnCondition() {
    }

    public FileUrnCondition(FileUrnCondition condition) {
        this();
        this.update(condition);
    }

    public synchronized void update(FileUrnCondition condition) {
        this.urnSet.clear();
        this.urnSet.addAll((Collection)condition.urnSet);
    }

    public synchronized int getUrnCount() {
        return this.urnSet.size();
    }

    public synchronized Set<URN> getUrnSet() {
        return Collections.unmodifiableSet(this.urnSet);
    }

    public synchronized List<URN> getUrnList() {
        return this.urnSet.asList();
    }

    public synchronized FileUrnCondition addUrn(URN urn) {
        this.urnSet.add(urn);
        return this;
    }

    public synchronized void removeHash(URN urn) {
        this.urnSet.remove(urn);
    }

    @Override
    public synchronized boolean isMatched(Search search, RemoteFile remoteFile) {
        URN fileUrn = remoteFile.getURN();
        for (URN urn : this.urnSet) {
            if (!fileUrn.equals(urn)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean isComplete() {
        return this.getUrnCount() > 0;
    }

    @Override
    public synchronized Object clone() {
        try {
            FileUrnCondition clone = (FileUrnCondition)super.clone();
            clone.urnSet = new ListOrderedSet();
            clone.urnSet.addAll((Collection)this.urnSet);
            return clone;
        }
        catch (CloneNotSupportedException exp) {
            throw new InternalError();
        }
    }

    @Override
    public synchronized DCondition createDCondition() {
        DFileUrnCondition dCond = new DFileUrnCondition();
        ArrayList<String> newList = new ArrayList<String>();
        for (URN urn : this.urnSet) {
            newList.add(urn.getAsString());
        }
        dCond.setUrns(newList);
        return dCond;
    }
}

