/*
 * Decompiled with CFR 0.152.
 */
package phex.security;

import java.lang.ref.SoftReference;
import phex.common.ExpiryDate;
import phex.common.address.AddressUtils;
import phex.security.AbstractSecurityRule;
import phex.security.HittingIpCidrPair;
import phex.security.IpSecurityRule;
import phex.xml.sax.security.DIpAccessRule;
import phex.xml.sax.security.DSecurityRule;

public class IpUserSecurityRule
extends AbstractSecurityRule
implements IpSecurityRule {
    private final HittingIpCidrPair ipCidrPair;
    private SoftReference<String> addressString;

    public IpUserSecurityRule(String description, byte[] ip, byte cidr, boolean isDisabled, boolean isDeletedOnExpiry, long expiryTime) {
        this(description, AddressUtils.byteIpToIntIp(ip), cidr, isDisabled, isDeletedOnExpiry, expiryTime);
    }

    public IpUserSecurityRule(String description, byte[] ip, byte cidr, boolean isDisabled, boolean isDeletedOnExpiry, ExpiryDate expiryDate) {
        this(description, AddressUtils.byteIpToIntIp(ip), cidr, isDisabled, isDeletedOnExpiry, expiryDate);
    }

    public IpUserSecurityRule(String description, int ip, byte cidr, boolean isDisabled, boolean isDeletedOnExpiry, long expiryTime) {
        this(description, ip, cidr, isDisabled, isDeletedOnExpiry, ExpiryDate.getExpiryDate(expiryTime));
    }

    public IpUserSecurityRule(String description, int ip, byte cidr, boolean isDisabled, boolean isDeletedOnExpiry, ExpiryDate expiryDate) {
        super(description, true, false, false, isDisabled);
        this.setDeleteOnExpiry(isDeletedOnExpiry);
        this.setExpiryDate(expiryDate);
        this.ipCidrPair = new HittingIpCidrPair(ip, cidr);
    }

    public HittingIpCidrPair getIpCidrPair() {
        return this.ipCidrPair;
    }

    public int getIp() {
        return this.ipCidrPair.ipAddr;
    }

    public byte getCidr() {
        return this.ipCidrPair.cidr;
    }

    public int getTriggerCount() {
        return this.ipCidrPair.getHits();
    }

    protected void incrementTriggerCount() {
        this.ipCidrPair.countHit();
    }

    public void setTriggerCount(int count) {
        this.ipCidrPair.setHits(count);
    }

    public String getAddressString() {
        if (this.addressString == null || this.addressString.get() == null) {
            this.addressString = this.ipCidrPair.cidr == 32 ? new SoftReference<String>(AddressUtils.ip2string(this.ipCidrPair.ipAddr)) : new SoftReference<String>(AddressUtils.ip2string(this.ipCidrPair.ipAddr) + " / " + String.valueOf(this.ipCidrPair.cidr));
        }
        return this.addressString.get();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = super.hashCode();
        result = 31 * result + (this.ipCidrPair == null ? 0 : this.ipCidrPair.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IpUserSecurityRule other = (IpUserSecurityRule)obj;
        return !(this.ipCidrPair == null ? other.ipCidrPair != null : !this.ipCidrPair.equals(other.ipCidrPair));
    }

    public DSecurityRule createDSecurityRule() {
        DIpAccessRule dRule = new DIpAccessRule();
        if (!this.isSystemRule) {
            dRule.setDescription(this.description);
            dRule.setExpiryDate(this.expiryDate.getTime());
            dRule.setDeletedOnExpiry(this.isDeletedOnExpiry);
            dRule.setDenyingRule(this.isDenyingRule);
            dRule.setDisabled(this.isDisabled);
        } else {
            dRule.setSystemRule(true);
        }
        dRule.setIp(AddressUtils.intIp2ByteIp(this.ipCidrPair.ipAddr));
        dRule.setCidr(this.ipCidrPair.cidr);
        dRule.setTriggerCount(this.ipCidrPair.getHits());
        return dRule;
    }
}

