/*
 * Decompiled with CFR 0.152.
 */
package phex.servent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import phex.chat.ChatService;
import phex.common.AbstractLifeCycle;
import phex.common.GnutellaNetwork;
import phex.common.LifeCycle;
import phex.common.MultipleException;
import phex.common.address.DestAddress;
import phex.common.bandwidth.BandwidthManager;
import phex.common.log.NLogger;
import phex.download.swarming.SwarmingManager;
import phex.event.ChangeEvent;
import phex.event.PhexEventService;
import phex.event.PhexEventServiceImpl;
import phex.host.DefaultHostFetchingStrategy;
import phex.host.HostFetchingStrategy;
import phex.host.HostManager;
import phex.host.UltrapeerCapabilityChecker;
import phex.msg.GUID;
import phex.msghandling.MessageService;
import phex.net.OnlineObserver;
import phex.net.UdpService;
import phex.net.server.OIOServer;
import phex.net.server.Server;
import phex.prefs.core.ConnectionPrefs;
import phex.prefs.core.NetworkPrefs;
import phex.query.QueryManager;
import phex.security.PhexSecurityManager;
import phex.servent.OnlineStatus;
import phex.servent.ServentInfo;
import phex.share.SharedFilesService;
import phex.statistic.StatisticsManager;
import phex.upload.UploadManager;
import phex.utils.StringUtils;

public class Servent
extends AbstractLifeCycle
implements ServentInfo {
    private static final Logger logger = LoggerFactory.getLogger(Servent.class);
    private static final Servent servent = new Servent();
    private final List<LifeCycle> dependentLifeCycles = new ArrayList<LifeCycle>();
    private GUID serventGuid;
    private GnutellaNetwork gnutellaNetwork;
    private final Server server;
    private final UdpService udpService;
    private OnlineStatus onlineStatus;
    private final PhexEventService serventEventService = new PhexEventServiceImpl();
    private final OnlineObserver onlineObserver;
    private final HostFetchingStrategy hostFetchingStrategy;
    private final ChatService chatService;
    private final MessageService messageService;
    private final UploadManager uploadService;
    private final QueryManager queryService;
    private final HostManager hostService;
    private final PhexSecurityManager securityService;
    private final SharedFilesService sharedFilesService;
    private final BandwidthManager bandwidthService;
    private final StatisticsManager statisticsService;
    private final SwarmingManager downloadService;
    private UltrapeerCapabilityChecker upChecker;

    public static Servent getInstance() {
        return servent;
    }

    private Servent() {
        String serventGuidStr = NetworkPrefs.ServentGuid.get();
        if (StringUtils.isEmpty(serventGuidStr)) {
            this.serventGuid = new GUID();
            NetworkPrefs.ServentGuid.set(this.serventGuid.toHexString());
        } else {
            try {
                this.serventGuid = new GUID(serventGuidStr);
            }
            catch (Exception exp) {
                NLogger.warn(Servent.class, exp, exp);
                this.serventGuid = new GUID();
                NetworkPrefs.ServentGuid.set(this.serventGuid.toHexString());
            }
        }
        String networkName = NetworkPrefs.CurrentNetwork.get();
        this.gnutellaNetwork = GnutellaNetwork.getGnutellaNetworkFromString(networkName);
        if (ConnectionPrefs.AutoConnectOnStartup.get().booleanValue()) {
            this.setOnlineStatus(OnlineStatus.ONLINE);
        } else {
            this.setOnlineStatus(OnlineStatus.OFFLINE);
        }
        this.securityService = new PhexSecurityManager();
        this.dependentLifeCycles.add(this.securityService);
        this.sharedFilesService = new SharedFilesService(this);
        this.dependentLifeCycles.add(this.sharedFilesService);
        this.downloadService = new SwarmingManager(this, this.sharedFilesService);
        this.dependentLifeCycles.add(this.downloadService);
        this.bandwidthService = new BandwidthManager();
        this.chatService = new ChatService(this);
        this.uploadService = new UploadManager(this);
        this.statisticsService = new StatisticsManager();
        this.dependentLifeCycles.add(this.statisticsService);
        this.hostService = new HostManager(this, true);
        this.dependentLifeCycles.add(this.hostService);
        this.messageService = new MessageService(this.hostService.getNetworkHostsContainer(), this.hostService.getCaughtHostsContainer(), this.hostService.getUhcContainer(), this.securityService, this);
        this.dependentLifeCycles.add(this.messageService);
        this.queryService = new QueryManager(this.messageService, this);
        this.dependentLifeCycles.add(this.queryService);
        this.hostFetchingStrategy = new DefaultHostFetchingStrategy(this, this.hostService.getUhcContainer());
        this.onlineObserver = new OnlineObserver(this, this.hostFetchingStrategy);
        this.server = new OIOServer(this);
        this.udpService = new UdpService(NetworkPrefs.ListeningPort.get());
    }

    protected void doStart() throws Exception {
        MultipleException multiExp = new MultipleException();
        this.hostFetchingStrategy.postManagerInitRoutine();
        try {
            this.server.startup();
        }
        catch (IOException exp) {
            NLogger.error(Servent.class, exp, exp);
        }
        try {
            this.udpService.startup();
        }
        catch (IOException exp) {
            NLogger.error(Servent.class, exp, exp);
        }
        this.upChecker = new UltrapeerCapabilityChecker(this, this.statisticsService);
        if (!this.dependentLifeCycles.isEmpty()) {
            ListIterator<LifeCycle> iterator = this.dependentLifeCycles.listIterator(this.dependentLifeCycles.size());
            while (iterator.hasPrevious()) {
                try {
                    iterator.previous().start();
                }
                catch (Throwable e) {
                    multiExp.add(e);
                }
            }
        }
        multiExp.throwPossibleExp();
    }

    protected void doStop() throws Exception {
        MultipleException multiExp = new MultipleException();
        this.server.shutdown(false);
        this.udpService.shutdown();
        if (!this.dependentLifeCycles.isEmpty()) {
            ListIterator<LifeCycle> iterator = this.dependentLifeCycles.listIterator(this.dependentLifeCycles.size());
            while (iterator.hasPrevious()) {
                try {
                    iterator.previous().stop();
                }
                catch (Throwable e) {
                    multiExp.add(e);
                }
            }
        }
        multiExp.throwPossibleExp();
    }

    public UdpService getUdpService() {
        return this.udpService;
    }

    public ChatService getChatService() {
        return this.chatService;
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    public HostManager getHostService() {
        return this.hostService;
    }

    public UploadManager getUploadService() {
        return this.uploadService;
    }

    public QueryManager getQueryService() {
        return this.queryService;
    }

    public SharedFilesService getSharedFilesService() {
        return this.sharedFilesService;
    }

    public PhexSecurityManager getSecurityService() {
        return this.securityService;
    }

    public BandwidthManager getBandwidthService() {
        return this.bandwidthService;
    }

    public PhexEventService getEventService() {
        return this.serventEventService;
    }

    public StatisticsManager getStatisticsService() {
        return this.statisticsService;
    }

    public SwarmingManager getDownloadService() {
        return this.downloadService;
    }

    public boolean isUltrapeer() {
        return this.hostService.isUltrapeer();
    }

    public boolean isShieldedLeafNode() {
        return this.hostService.isShieldedLeafNode();
    }

    public boolean isAbleToBecomeUltrapeer() {
        if (this.isUltrapeer()) {
            return true;
        }
        return !this.isShieldedLeafNode() && ConnectionPrefs.AllowToBecomeUP.get() != false && this.upChecker.isUltrapeerCapable();
    }

    public boolean allowDowngradeToLeaf() {
        return !this.upChecker.isPerfectUltrapeer() && this.hostService.allowDowngradeToLeaf();
    }

    public void upgradeToUltrapeer() {
        if (!this.isShieldedLeafNode()) {
            return;
        }
        logger.debug("Upgrading to ultrapeer..");
        OnlineStatus oldStatus = this.onlineStatus;
        this.setOnlineStatus(OnlineStatus.OFFLINE);
        this.setOnlineStatus(oldStatus);
    }

    public boolean isFirewalled() {
        return !this.server.hasConnectedIncoming();
    }

    public boolean isUdpHostCache() {
        return false;
    }

    public boolean isUploadLimitReached() {
        return this.uploadService.isHostBusy();
    }

    public DestAddress getLocalAddress() {
        return this.server.getLocalAddress();
    }

    public void updateLocalAddress(DestAddress newAddress) {
        this.server.updateLocalAddress(newAddress);
    }

    public void restartServer() throws IOException {
        this.server.restart();
    }

    public GUID getServentGuid() {
        return this.serventGuid;
    }

    public OnlineStatus getOnlineStatus() {
        return this.onlineStatus;
    }

    public void setOnlineStatus(OnlineStatus newStatus) {
        if (newStatus == this.onlineStatus) {
            return;
        }
        OnlineStatus oldStatus = this.onlineStatus;
        this.onlineStatus = newStatus;
        this.serventEventService.publish("phex:servent/onlineStatus", new ChangeEvent(this, (Object)oldStatus, (Object)newStatus));
    }

    public GnutellaNetwork getGnutellaNetwork() {
        return this.gnutellaNetwork;
    }

    public void setGnutellaNetwork(GnutellaNetwork network) {
        OnlineStatus oldStatus = this.onlineStatus;
        this.setOnlineStatus(OnlineStatus.OFFLINE);
        GnutellaNetwork oldNetwork = this.gnutellaNetwork;
        this.gnutellaNetwork = network;
        this.serventEventService.publish("phex:servent/gnutellaNetwork", new ChangeEvent(this, oldNetwork, this.gnutellaNetwork));
        this.setOnlineStatus(oldStatus);
    }

    public HostFetchingStrategy getHostFetchingStrategy() {
        return this.hostFetchingStrategy;
    }
}

