/*
 * Decompiled with CFR 0.152.
 */
package phex.udp;

import java.util.Map;
import java.util.TreeMap;
import phex.common.address.DestAddress;
import phex.msg.GUID;

public class UdpGuidRoutingTable {
    private static final int MAX_ROUTE_TABLE_SIZE = 50;
    protected Map<GUID, DestAddress> currentMap;
    protected Map<GUID, DestAddress> lastMap;
    private long lifetime;
    private long nextReplaceTime;

    public UdpGuidRoutingTable(long lifetime) {
        this.lifetime = lifetime;
        this.currentMap = new TreeMap<GUID, DestAddress>(new GUID.GUIDComparator());
        this.lastMap = new TreeMap<GUID, DestAddress>(new GUID.GUIDComparator());
    }

    public synchronized boolean checkAndAddRouting(GUID guid, DestAddress address) {
        this.checkForSwitch();
        if (!this.currentMap.containsKey(guid) && !this.lastMap.containsKey(guid)) {
            this.currentMap.put(guid, address);
            return true;
        }
        return false;
    }

    protected void checkForSwitch() {
        long currentTime = System.currentTimeMillis();
        if (currentTime < this.nextReplaceTime && this.currentMap.size() < 50) {
            return;
        }
        this.lastMap.clear();
        Map<GUID, DestAddress> temp = this.lastMap;
        this.lastMap = this.currentMap;
        this.currentMap = temp;
        this.nextReplaceTime = currentTime + this.lifetime;
    }

    public synchronized DestAddress getRouting(GUID guid) {
        DestAddress address = null;
        address = this.currentMap.get(guid);
        if (address != null) {
            return address;
        }
        address = this.lastMap.get(guid);
        if (address != null) {
            return address;
        }
        return null;
    }

    public synchronized DestAddress getAndRemoveRouting(GUID guid) {
        DestAddress address = null;
        address = this.currentMap.remove(guid);
        if (address != null) {
            return address;
        }
        address = this.lastMap.remove(guid);
        if (address != null) {
            return address;
        }
        return null;
    }
}

